/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtImportOptimizer;
import org.jetbrains.kotlin.analysis.api.components.KtImportOptimizerResult;
import org.jetbrains.kotlin.analysis.api.fir.FirUtilsKt;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirImportOptimizer;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirImportOptimizerKt;
import org.jetbrains.kotlin.analysis.api.fir.components.TypeQualifier;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedError;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer;", "Lorg/jetbrains/kotlin/analysis/api/components/KtImportOptimizer;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "firResolveSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;", "(Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;)V", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "getFirSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "analyseImports", "Lorg/jetbrains/kotlin/analysis/api/components/KtImportOptimizerResult;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectReferencedEntities", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer$ReferencedEntitiesResult;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "ReferencedEntitiesResult", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirImportOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirImportOptimizer.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,504:1\n1#2:505\n*E\n"})
public final class KtFirImportOptimizer
extends KtImportOptimizer {
    @NotNull
    private final KtLifetimeToken token;
    @NotNull
    private final LLFirResolveSession firResolveSession;

    public KtFirImportOptimizer(@NotNull KtLifetimeToken token, @NotNull LLFirResolveSession firResolveSession) {
        Intrinsics.checkNotNullParameter(token, "token");
        Intrinsics.checkNotNullParameter(firResolveSession, "firResolveSession");
        this.token = token;
        this.firResolveSession = firResolveSession;
    }

    @Override
    @NotNull
    public KtLifetimeToken getToken() {
        return this.token;
    }

    private final FirSession getFirSession() {
        return this.firResolveSession.getUseSiteFirSession();
    }

    @Override
    @NotNull
    public KtImportOptimizerResult analyseImports(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        List<KtImportDirective> existingImports = file2.getImportDirectives();
        if (existingImports.isEmpty()) {
            return new KtImportOptimizerResult(null, null, 3, null);
        }
        Object object = LowLevelFirApiFacadeKt.getOrBuildFirFile(file2, this.firResolveSession);
        FirFile $this$analyseImports_u24lambda_u240 = object;
        boolean bl = false;
        FirLazyDeclarationResolverKt.lazyResolveToPhaseRecursively($this$analyseImports_u24lambda_u240, FirResolvePhase.BODY_RESOLVE);
        FirFile firFile = object;
        object = this.collectReferencedEntities(firFile);
        Map<FqName, Set<Name>> usedDeclarations = ((ReferencedEntitiesResult)object).component1();
        Set<Name> unresolvedNames = ((ReferencedEntitiesResult)object).component2();
        return new KtImportOptimizerResult(usedDeclarations, unresolvedNames);
    }

    private final ReferencedEntitiesResult collectReferencedEntities(FirFile firFile) {
        Map usedImports = new LinkedHashMap();
        Set unresolvedNames = new LinkedHashSet();
        firFile.accept(new FirVisitorVoid(unresolvedNames, this, usedImports){
            final /* synthetic */ Set<Name> $unresolvedNames;
            final /* synthetic */ KtFirImportOptimizer this$0;
            final /* synthetic */ Map<FqName, Set<Name>> $usedImports;
            {
                this.$unresolvedNames = $unresolvedNames;
                this.this$0 = $receiver;
                this.$usedImports = $usedImports;
            }

            public void visitElement(FirElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                element2.acceptChildren(this);
            }

            public void visitFunctionCall(FirFunctionCall functionCall) {
                Intrinsics.checkNotNullParameter(functionCall, "functionCall");
                this.processFunctionCall(functionCall);
                super.visitFunctionCall(functionCall);
            }

            public void visitImplicitInvokeCall(FirImplicitInvokeCall implicitInvokeCall) {
                Intrinsics.checkNotNullParameter(implicitInvokeCall, "implicitInvokeCall");
                this.processImplicitFunctionCall(implicitInvokeCall);
                super.visitImplicitInvokeCall(implicitInvokeCall);
            }

            public void visitComponentCall(FirComponentCall componentCall) {
                Intrinsics.checkNotNullParameter(componentCall, "componentCall");
                this.processFunctionCall(componentCall);
                super.visitComponentCall(componentCall);
            }

            public void visitPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                Intrinsics.checkNotNullParameter(propertyAccessExpression, "propertyAccessExpression");
                this.processPropertyAccessExpression(propertyAccessExpression);
                super.visitPropertyAccessExpression(propertyAccessExpression);
            }

            public void visitResolvedTypeRef(FirResolvedTypeRef resolvedTypeRef) {
                Intrinsics.checkNotNullParameter(resolvedTypeRef, "resolvedTypeRef");
                this.processTypeRef(resolvedTypeRef);
                FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
                if (firTypeRef != null) {
                    firTypeRef.accept(this);
                }
                super.visitTypeRef(resolvedTypeRef);
            }

            public void visitErrorTypeRef(FirErrorTypeRef errorTypeRef) {
                Intrinsics.checkNotNullParameter(errorTypeRef, "errorTypeRef");
                this.processTypeRef(errorTypeRef);
                this.processErrorTypeRef(errorTypeRef);
                FirTypeRef firTypeRef = errorTypeRef.getDelegatedTypeRef();
                if (firTypeRef != null) {
                    firTypeRef.accept(this);
                }
                super.visitErrorTypeRef(errorTypeRef);
            }

            public void visitCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess) {
                Intrinsics.checkNotNullParameter(callableReferenceAccess, "callableReferenceAccess");
                this.processCallableReferenceAccess(callableReferenceAccess);
                super.visitCallableReferenceAccess(callableReferenceAccess);
            }

            public void visitResolvedQualifier(FirResolvedQualifier resolvedQualifier) {
                Intrinsics.checkNotNullParameter(resolvedQualifier, "resolvedQualifier");
                this.processResolvedQualifier(resolvedQualifier);
                super.visitResolvedQualifier(resolvedQualifier);
            }

            public void visitErrorResolvedQualifier(FirErrorResolvedQualifier errorResolvedQualifier) {
                Intrinsics.checkNotNullParameter(errorResolvedQualifier, "errorResolvedQualifier");
                this.processResolvedQualifier(errorResolvedQualifier);
                super.visitErrorResolvedQualifier(errorResolvedQualifier);
            }

            private final void processErrorNameReference(FirResolvable resolvable) {
                FirReference firReference = resolvable.getCalleeReference();
                FirErrorNamedReference firErrorNamedReference = firReference instanceof FirErrorNamedReference ? (FirErrorNamedReference)firReference : null;
                if (firErrorNamedReference == null) {
                    return;
                }
                FirErrorNamedReference nameReference = firErrorNamedReference;
                Name name2 = KtFirImportOptimizerKt.access$getUnresolvedName(nameReference);
                if (name2 == null) {
                    return;
                }
                Name name3 = name2;
                ((Collection)this.$unresolvedNames).add(name3);
            }

            private final void processErrorTypeRef(FirErrorTypeRef typeRef) {
                ConeDiagnostic coneDiagnostic = typeRef.getDiagnostic();
                ConeUnresolvedError coneUnresolvedError = coneDiagnostic instanceof ConeUnresolvedError ? (ConeUnresolvedError)coneDiagnostic : null;
                if (coneUnresolvedError == null) {
                    return;
                }
                ConeUnresolvedError diagnostic = coneUnresolvedError;
                Name name2 = KtFirImportOptimizerKt.access$getUnresolvedName(diagnostic);
                if (name2 == null) {
                    return;
                }
                Name name3 = name2;
                ((Collection)this.$unresolvedNames).add(name3);
            }

            private final void processFunctionCall(FirFunctionCall functionCall) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport(functionCall)) {
                    return;
                }
                this.processErrorNameReference(functionCall);
                Name name2 = KtFirImportOptimizerKt.access$getFunctionReferenceName(functionCall);
                if (name2 == null) {
                    return;
                }
                Name referencesByName = name2;
                this.saveCallable(functionCall, referencesByName);
            }

            private final void processImplicitFunctionCall(FirImplicitInvokeCall implicitInvokeCall) {
                this.processErrorNameReference(implicitInvokeCall);
                this.saveCallable(implicitInvokeCall, OperatorNameConventions.INVOKE);
            }

            private final void processPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport(propertyAccessExpression)) {
                    return;
                }
                this.processErrorNameReference(propertyAccessExpression);
                Name name2 = KtFirImportOptimizerKt.access$getPropertyReferenceName(propertyAccessExpression);
                if (name2 == null) {
                    return;
                }
                Name referencedByName = name2;
                this.saveCallable(propertyAccessExpression, referencedByName);
            }

            private final void processTypeRef(FirResolvedTypeRef resolvedTypeRef) {
                TypeQualifier typeQualifier = TypeQualifier.Companion.createFor(resolvedTypeRef);
                if (typeQualifier == null) {
                    return;
                }
                TypeQualifier wholeQualifier = typeQualifier;
                this.processTypeQualifier(wholeQualifier);
            }

            private final void processCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess) {
                if (KtFirImportOptimizerKt.access$getDispatchedWithoutImport(callableReferenceAccess)) {
                    return;
                }
                this.processErrorNameReference(callableReferenceAccess);
                Name name2 = KtFirImportOptimizerKt.access$getCallableReferenceName(callableReferenceAccess);
                if (name2 == null) {
                    return;
                }
                Name referencedByName = name2;
                this.saveCallable(callableReferenceAccess, referencedByName);
            }

            private final void processResolvedQualifier(FirResolvedQualifier resolvedQualifier) {
                TypeQualifier typeQualifier = TypeQualifier.Companion.createFor(resolvedQualifier);
                if (typeQualifier == null) {
                    return;
                }
                TypeQualifier wholeQualifier = typeQualifier;
                this.processTypeQualifier(wholeQualifier);
            }

            private final void processTypeQualifier(TypeQualifier qualifier2) {
                TypeQualifier mostOuterTypeQualifier2 = SequencesKt.last(SequencesKt.generateSequence(qualifier2, (Function1)collectReferencedEntities.processTypeQualifier.mostOuterTypeQualifier.1.INSTANCE));
                if (mostOuterTypeQualifier2.isQualified()) {
                    return;
                }
                this.saveType(mostOuterTypeQualifier2);
            }

            private final void saveType(TypeQualifier qualifier2) {
                FqName importableName = qualifier2.getReferencedClassId().asSingleFqName();
                Name referencedByName = qualifier2.getReferencedByName();
                this.saveReferencedItem(importableName, referencedByName);
            }

            private final void saveCallable(FirQualifiedAccessExpression qualifiedCall, Name referencedByName) {
                FqName fqName2 = this.importableNameForReferencedSymbol(qualifiedCall);
                if (fqName2 == null) {
                    return;
                }
                FqName importableName = fqName2;
                this.saveReferencedItem(importableName, referencedByName);
            }

            private final FqName importableNameForReferencedSymbol(FirQualifiedAccessExpression qualifiedCall) {
                FqName fqName2 = this.importableNameForImplicitlyDispatchedCallable(qualifiedCall);
                if (fqName2 == null) {
                    FirCallableSymbol firCallableSymbol = KtFirImportOptimizerKt.access$getReferencedCallableSymbol(qualifiedCall);
                    fqName2 = firCallableSymbol != null ? org.jetbrains.kotlin.analysis.api.fir.utils.FirUtilsKt.computeImportableName(firCallableSymbol, KtFirImportOptimizer.access$getFirSession(this.this$0)) : null;
                }
                return fqName2;
            }

            private final FqName importableNameForImplicitlyDispatchedCallable(FirQualifiedAccessExpression $this$importableNameForImplicitlyDispatchedCallable) {
                FirExpression dispatchReceiver = $this$importableNameForImplicitlyDispatchedCallable.getDispatchReceiver();
                if (!(dispatchReceiver instanceof FirResolvedQualifier) || !FirUtilsKt.isImplicitDispatchReceiver((FirResolvedQualifier)dispatchReceiver)) {
                    return null;
                }
                ClassId classId = ((FirResolvedQualifier)dispatchReceiver).getClassId();
                if (classId == null) {
                    return null;
                }
                ClassId dispatcherClass = classId;
                Object object = KtFirImportOptimizerKt.access$getReferencedCallableSymbol($this$importableNameForImplicitlyDispatchedCallable);
                if (object == null || (object = ((FirCallableSymbol)object).getName()) == null) {
                    return null;
                }
                Object referencedSymbolName = object;
                return new CallableId(dispatcherClass, (Name)referencedSymbolName).asSingleFqName();
            }

            private final void saveReferencedItem(FqName importableName, Name referencedByName) {
                Set set;
                Map<FqName, Set<Name>> $this$getOrPut$iv = this.$usedImports;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(importableName);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new HashSet<E>();
                    $this$getOrPut$iv.put(importableName, answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                ((Collection)set).add(referencedByName);
            }
        });
        return new ReferencedEntitiesResult(usedImports, unresolvedNames);
    }

    public static final /* synthetic */ FirSession access$getFirSession(KtFirImportOptimizer $this) {
        return $this.getFirSession();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J5\u0010\u000f\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirImportOptimizer$ReferencedEntitiesResult;", "", "usedImports", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "unresolvedNames", "(Ljava/util/Map;Ljava/util/Set;)V", "getUnresolvedNames", "()Ljava/util/Set;", "getUsedImports", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "analysis-api-fir"})
    private static final class ReferencedEntitiesResult {
        @NotNull
        private final Map<FqName, Set<Name>> usedImports;
        @NotNull
        private final Set<Name> unresolvedNames;

        public ReferencedEntitiesResult(@NotNull Map<FqName, ? extends Set<Name>> usedImports, @NotNull Set<Name> unresolvedNames) {
            Intrinsics.checkNotNullParameter(usedImports, "usedImports");
            Intrinsics.checkNotNullParameter(unresolvedNames, "unresolvedNames");
            this.usedImports = usedImports;
            this.unresolvedNames = unresolvedNames;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getUsedImports() {
            return this.usedImports;
        }

        @NotNull
        public final Set<Name> getUnresolvedNames() {
            return this.unresolvedNames;
        }

        @NotNull
        public final Map<FqName, Set<Name>> component1() {
            return this.usedImports;
        }

        @NotNull
        public final Set<Name> component2() {
            return this.unresolvedNames;
        }

        @NotNull
        public final ReferencedEntitiesResult copy(@NotNull Map<FqName, ? extends Set<Name>> usedImports, @NotNull Set<Name> unresolvedNames) {
            Intrinsics.checkNotNullParameter(usedImports, "usedImports");
            Intrinsics.checkNotNullParameter(unresolvedNames, "unresolvedNames");
            return new ReferencedEntitiesResult(usedImports, unresolvedNames);
        }

        public static /* synthetic */ ReferencedEntitiesResult copy$default(ReferencedEntitiesResult referencedEntitiesResult, Map map, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                map = referencedEntitiesResult.usedImports;
            }
            if ((n & 2) != 0) {
                set = referencedEntitiesResult.unresolvedNames;
            }
            return referencedEntitiesResult.copy(map, set);
        }

        @NotNull
        public String toString() {
            return "ReferencedEntitiesResult(usedImports=" + this.usedImports + ", unresolvedNames=" + this.unresolvedNames + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.usedImports).hashCode();
            result2 = result2 * 31 + ((Object)this.unresolvedNames).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReferencedEntitiesResult)) {
                return false;
            }
            ReferencedEntitiesResult referencedEntitiesResult = (ReferencedEntitiesResult)other;
            if (!Intrinsics.areEqual(this.usedImports, referencedEntitiesResult.usedImports)) {
                return false;
            }
            return Intrinsics.areEqual(this.unresolvedNames, referencedEntitiesResult.unresolvedNames);
        }
    }
}

