/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0016R,\u0010\t\u001a\u001e\u0012\b\u0012\u00060\u000bR\u00020\u0000\u0018\u00010\fj\u000e\u0012\b\u0012\u00060\u000bR\u00020\u0000\u0018\u0001`\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\b\u0018\u00010\u000bR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R,\u0010\u0011\u001a\u001a\u0012\b\u0012\u00060\u000bR\u00020\u00000\fj\f\u0012\b\u0012\u00060\u000bR\u00020\u0000`\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope;", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "parent", "description", "", "useParentScopeStack", "", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsScope;Ljava/lang/String;Z)V", "labelScopesImpl", "Lkotlin/collections/ArrayList;", "Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$LabelScope;", "Ljava/util/ArrayList;", "Ljava/util/ArrayList;", "topLabelScope", "getTopLabelScope", "()Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$LabelScope;", "labelScopes", "getLabelScopes", "()Ljava/util/ArrayList;", "enterLabel", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "label", "outputName", "exitLabel", "", "findLabel", "LabelScope", "Companion", "js.ast"})
@SourceDebugExtension(value={"SMAP\njsScopes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jsScopes.kt\norg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public class JsDeclarationScope
extends JsScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ArrayList<LabelScope> labelScopesImpl;
    @NotNull
    private static final Set<String> RESERVED_WORDS;

    public JsDeclarationScope(@NotNull JsScope parent2, @NotNull String description, boolean useParentScopeStack) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        super(parent2, description);
        this.labelScopesImpl = parent2 instanceof JsDeclarationScope && useParentScopeStack ? ((JsDeclarationScope)parent2).labelScopesImpl : null;
    }

    public /* synthetic */ JsDeclarationScope(JsScope jsScope, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(jsScope, string2, bl);
    }

    private final LabelScope getTopLabelScope() {
        LabelScope labelScope;
        ArrayList<LabelScope> arrayList = this.labelScopesImpl;
        if (arrayList != null) {
            ArrayList<LabelScope> it = arrayList;
            boolean bl = false;
            labelScope = !((Collection)it).isEmpty() ? (LabelScope)CollectionsKt.last((List)it) : null;
        } else {
            labelScope = null;
        }
        return labelScope;
    }

    private final ArrayList<LabelScope> getLabelScopes() {
        ArrayList<LabelScope> arrayList = this.labelScopesImpl;
        if (arrayList == null) {
            ArrayList arrayList2;
            ArrayList it = arrayList2 = new ArrayList();
            boolean bl = false;
            this.labelScopesImpl = it;
            arrayList = arrayList2;
        }
        return arrayList;
    }

    @NotNull
    public JsName enterLabel(@NotNull String label, @NotNull String outputName) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)outputName, (String)"outputName");
        LabelScope scope = new LabelScope(this.getTopLabelScope(), label, outputName);
        this.getLabelScopes().add(scope);
        return scope.getLabelName();
    }

    public void exitLabel() {
        boolean bl;
        ArrayList<LabelScope> it = this.getLabelScopes();
        boolean bl2 = false;
        boolean bl3 = bl = !((Collection)it).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "No scope to exit from";
            throw new AssertionError((Object)string2);
        }
        LabelScope cfr_ignored_0 = (LabelScope)CollectionsKt.removeLast((List)it);
    }

    @Nullable
    public JsName findLabel(@NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        LabelScope labelScope = this.getTopLabelScope();
        return labelScope != null ? labelScope.findName(label) : null;
    }

    static {
        Object[] objectArray = new String[]{"NaN", "isNaN", "Infinity", "undefined", "Error", "Object", "Math", "String", "Number", "Boolean", "Date", "Array", "RegExp", "JSON", "require", "define", "module", "window", "self", "Kotlin"};
        RESERVED_WORDS = SetsKt.plus(IdentifierPolicyKt.getRESERVED_KEYWORDS(), (Iterable)SetsKt.setOf((Object[])objectArray));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$Companion;", "", "<init>", "()V", "RESERVED_WORDS", "", "", "getRESERVED_WORDS", "()Ljava/util/Set;", "js.ast"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getRESERVED_WORDS() {
            return RESERVED_WORDS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$LabelScope;", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "parent", "Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope;", "ident", "", "outputIdent", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope;Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$LabelScope;Ljava/lang/String;Ljava/lang/String;)V", "getIdent", "()Ljava/lang/String;", "labelName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getLabelName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "findOwnName", "name", "hasOwnName", "", "js.ast"})
    private final class LabelScope
    extends JsScope {
        @NotNull
        private final String ident;
        @NotNull
        private final JsName labelName;

        public LabelScope(@NotNull LabelScope parent2, @NotNull String ident, String outputIdent) {
            Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
            Intrinsics.checkNotNullParameter((Object)outputIdent, (String)"outputIdent");
            super(parent2, "Label scope for " + ident);
            this.ident = ident;
            this.labelName = new JsName(outputIdent, true);
        }

        @NotNull
        public final String getIdent() {
            return this.ident;
        }

        @NotNull
        public final JsName getLabelName() {
            return this.labelName;
        }

        @Override
        @Nullable
        protected JsName findOwnName(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return Intrinsics.areEqual((Object)name2, (Object)this.ident) ? this.labelName : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasOwnName(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            if (Companion.getRESERVED_WORDS().contains(name2)) return true;
            if (Intrinsics.areEqual((Object)name2, (Object)this.ident)) return true;
            JsName jsName = this.labelName;
            if (Intrinsics.areEqual((Object)name2, (Object)(jsName != null ? jsName.getIdent() : null))) return true;
            JsScope jsScope = this.getParent();
            if (jsScope == null) return false;
            boolean bl = jsScope.hasOwnName(name2);
            if (!bl) return false;
            return true;
        }
    }
}

