/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirEnumWhenTrackerComponent;
import org.jetbrains.kotlin.fir.FirEnumWhenTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnBooleanExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNothingExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnSealedClassExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenSelfTypeExhaustivenessChecker;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J)\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformWhenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "processExhaustivenessCheck", "", "computeStatusForNonIntersectionType", "Lorg/jetbrains/kotlin/fir/expressions/ExhaustivenessStatus;", "unwrappedSubjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,501:1\n1755#2,3:502\n48#3:505\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer\n*L\n123#1:502,3\n143#1:505\n*E\n"})
public final class FirWhenExhaustivenessTransformer
extends FirTransformer<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @NotNull
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;

    public FirWhenExhaustivenessTransformer(@NotNull BodyResolveComponents bodyResolveComponents2) {
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents2, (String)"bodyResolveComponents");
        this.bodyResolveComponents = bodyResolveComponents2;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element2, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(element2, (String)"element");
        throw new IllegalArgumentException("Should not be there");
    }

    @Override
    @NotNull
    public FirStatement transformWhenExpression(@NotNull FirWhenExpression whenExpression, @Nullable Object data) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            this.processExhaustivenessCheck(whenExpression);
            FirEnumWhenTrackerComponent firEnumWhenTrackerComponent = FirEnumWhenTrackerComponentKt.getEnumWhenTracker(this.bodyResolveComponents.getSession());
            if (firEnumWhenTrackerComponent == null) break block0;
            KtSourceFile ktSourceFile = this.bodyResolveComponents.getFile().getSourceFile();
            FirEnumWhenTrackerComponentKt.reportEnumUsageInWhen(firEnumWhenTrackerComponent, ktSourceFile != null ? ktSourceFile.getPath() : null, FirWhenExhaustivenessTransformer.Companion.getSubjectType(this.bodyResolveComponents.getSession(), whenExpression));
        }
        return whenExpression;
    }

    private final void processExhaustivenessCheck(FirWhenExpression whenExpression) {
        boolean bl;
        ConeKotlinType coneKotlinType;
        FirSession session;
        block17: {
            block16: {
                boolean bl2;
                block15: {
                    Iterable $this$any$iv = whenExpression.getBranches();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirWhenBranch it = (FirWhenBranch)element$iv;
                            boolean bl3 = false;
                            if (!(it.getCondition() instanceof FirElseIfTrueCondition)) continue;
                            bl2 = true;
                            break block15;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.ProperlyExhaustive.INSTANCE);
                    return;
                }
                session = this.bodyResolveComponents.getSession();
                coneKotlinType = FirWhenExhaustivenessTransformer.Companion.getSubjectType(session, whenExpression);
                if (coneKotlinType == null) break block16;
                ConeKotlinType it = coneKotlinType;
                boolean bl4 = false;
                ConeKotlinType coneKotlinType2 = TypeComponentsKt.getTypeApproximator(session).approximateToSuperType(it, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.FinalApproximationAfterResolutionAndInference.INSTANCE);
                if (coneKotlinType2 == null) {
                    coneKotlinType2 = it;
                }
                coneKotlinType = coneKotlinType2;
                if (coneKotlinType2 != null) break block17;
            }
            FirWhenExhaustivenessTransformer $this$processExhaustivenessCheck_u24lambda_u242 = this;
            boolean bl5 = false;
            whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH());
            return;
        }
        ConeKotlinType subjectType = coneKotlinType;
        if (whenExpression.getBranches().isEmpty() && ConeBuiltinTypeUtilsKt.isNothing(subjectType)) {
            whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.ExhaustiveAsNothing.INSTANCE);
            return;
        }
        ExhaustivenessStatus status2 = ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH();
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(subjectType, session);
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isExpect$iv = firRegularClassSymbol;
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getRawStatus().isExpect();
        } else {
            bl = false;
        }
        if (!bl) {
            Collection unwrappedIntersectionTypes = FirWhenExhaustivenessTransformer.Companion.unwrapIntersectionType(subjectType);
            for (ConeKotlinType unwrappedSubjectType : unwrappedIntersectionTypes) {
                ExhaustivenessStatus localStatus = this.computeStatusForNonIntersectionType(unwrappedSubjectType, session, whenExpression);
                if (localStatus == ExhaustivenessStatus.ProperlyExhaustive.INSTANCE) {
                    status2 = localStatus;
                    break;
                }
                if (localStatus == ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH() || status2 != ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH()) continue;
                status2 = localStatus;
            }
        }
        whenExpression.replaceExhaustivenessStatus(status2);
    }

    private final ExhaustivenessStatus computeStatusForNonIntersectionType(ConeKotlinType unwrappedSubjectType, FirSession session, FirWhenExpression whenExpression) {
        List checkers = FirWhenExhaustivenessTransformer.Companion.getCheckers(unwrappedSubjectType, session);
        if (checkers.isEmpty()) {
            return ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH();
        }
        List whenMissingCases = new ArrayList();
        FirWhenExhaustivenessTransformer.Companion.collectMissingCases(whenMissingCases, checkers, whenExpression, unwrappedSubjectType, session);
        return whenMissingCases.isEmpty() ? (ExhaustivenessStatus)ExhaustivenessStatus.ProperlyExhaustive.INSTANCE : (ExhaustivenessStatus)new ExhaustivenessStatus.NotExhaustive(whenMissingCases);
    }

    static {
        Object[] objectArray = new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedClassExhaustivenessChecker.INSTANCE, WhenOnNothingExhaustivenessChecker.INSTANCE};
        exhaustivenessCheckers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010*\u00020\u000eH\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J8\u0010\u0013\u001a\u00020\u0014*\b\u0012\u0004\u0012\u00020\b0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion;", "", "<init>", "()V", "exhaustivenessCheckers", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "computeAllMissingCases", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "getSubjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "unwrapIntersectionType", "", "getCheckers", "subjectType", "collectMissingCases", "", "", "checkers", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,501:1\n865#2,2:502\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion\n*L\n77#1:502,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<WhenMissingCase> computeAllMissingCases(@NotNull FirSession session, @NotNull FirWhenExpression whenExpression) {
            List list;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            ConeKotlinType coneKotlinType = this.getSubjectType(session, whenExpression);
            if (coneKotlinType == null) {
                return ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH().getReasons();
            }
            ConeKotlinType subjectType = coneKotlinType;
            List $this$computeAllMissingCases_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (ConeKotlinType type2 : Companion.unwrapIntersectionType(subjectType)) {
                List<WhenExhaustivenessChecker> checkers = Companion.getCheckers(type2, session);
                Companion.collectMissingCases($this$computeAllMissingCases_u24lambda_u240, checkers, whenExpression, type2, session);
            }
            return CollectionsKt.build((List)list);
        }

        private final ConeKotlinType getSubjectType(FirSession session, FirWhenExpression whenExpression) {
            Object object = whenExpression.getSubjectVariable();
            if (object == null || (object = ((FirVariable)object).getReturnTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
                FirExpression firExpression = whenExpression.getSubject();
                if (firExpression != null) {
                    object = FirTypeUtilsKt.getResolvedType(firExpression);
                } else {
                    return null;
                }
            }
            Object subjectType = object;
            return ConeTypeUtilsKt.lowerBoundIfFlexible(TypeExpansionUtilsKt.fullyExpandedType$default((ConeKotlinType)subjectType, session, null, 2, null));
        }

        private final Collection<ConeKotlinType> unwrapIntersectionType(ConeKotlinType $this$unwrapIntersectionType) {
            Object object = $this$unwrapIntersectionType instanceof ConeIntersectionType ? (ConeIntersectionType)$this$unwrapIntersectionType : null;
            if (object == null || (object = ((ConeIntersectionType)object).getIntersectedTypes()) == null) {
                object = CollectionsKt.listOf((Object)$this$unwrapIntersectionType);
            }
            return object;
        }

        private final List<WhenExhaustivenessChecker> getCheckers(ConeKotlinType subjectType, FirSession session) {
            List list;
            List $this$getCheckers_u24lambda_u242 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            Iterable $this$filterTo$iv = exhaustivenessCheckers;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                WhenExhaustivenessChecker it = (WhenExhaustivenessChecker)element$iv;
                boolean bl2 = false;
                if (!it.isApplicable(subjectType, session)) continue;
                ((Collection)$this$getCheckers_u24lambda_u242).add(element$iv);
            }
            if (!((Collection)$this$getCheckers_u24lambda_u242).isEmpty() && ConeTypeUtilsKt.isMarkedNullable(subjectType)) {
                $this$getCheckers_u24lambda_u242.add(WhenOnNullableExhaustivenessChecker.INSTANCE);
            }
            if ($this$getCheckers_u24lambda_u242.isEmpty()) {
                $this$getCheckers_u24lambda_u242.add(WhenSelfTypeExhaustivenessChecker.INSTANCE);
            }
            return CollectionsKt.build((List)list);
        }

        private final void collectMissingCases(List<WhenMissingCase> $this$collectMissingCases, List<? extends WhenExhaustivenessChecker> checkers, FirWhenExpression whenExpression, ConeKotlinType subjectType, FirSession session) {
            for (WhenExhaustivenessChecker whenExhaustivenessChecker : checkers) {
                whenExhaustivenessChecker.computeMissingCases(whenExpression, subjectType, session, (Collection<WhenMissingCase>)$this$collectMissingCases);
            }
            if ($this$collectMissingCases.isEmpty() && whenExpression.getBranches().isEmpty()) {
                $this$collectMissingCases.add(WhenMissingCase.Unknown.INSTANCE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

