/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReservedUnderscoreDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportIfUnderscore", "isSingleUnderscoreAllowed", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReservedUnderscoreDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReservedUnderscoreDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReservedUnderscoreDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1863#2,2:86\n*S KotlinDebug\n*F\n+ 1 FirReservedUnderscoreDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReservedUnderscoreDeclarationChecker\n*L\n28#1:86,2\n*E\n"})
public final class FirReservedUnderscoreDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirReservedUnderscoreDeclarationChecker INSTANCE = new FirReservedUnderscoreDeclarationChecker();

    private FirReservedUnderscoreDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                        if (!(declaration2 instanceof FirRegularClass) && (!(declaration2 instanceof FirProperty) || Intrinsics.areEqual((Object)ClassMembersKt.isCatchParameter((FirProperty)declaration2), (Object)true)) && !(declaration2 instanceof FirTypeAlias)) break block4;
                        FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, declaration2, context2, reporter, false, 8, null);
                        break block5;
                    }
                    if (!(declaration2 instanceof FirTypeParameter)) break block6;
                    FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, declaration2, context2, reporter, false, 8, null);
                    Iterable $this$forEach$iv = ((FirTypeParameter)declaration2).getBounds();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirTypeRef it = (FirTypeRef)element$iv;
                        boolean bl = false;
                        FirUnderscoreHelpersKt.checkTypeRefForUnderscore(it, context2, reporter);
                    }
                    break block5;
                }
                if (!(declaration2 instanceof FirFunction)) break block7;
                if (declaration2 instanceof FirSimpleFunction) {
                    FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, declaration2, context2, reporter, false, 8, null);
                }
                boolean isSingleUnderscoreAllowed = declaration2 instanceof FirAnonymousFunction || declaration2 instanceof FirPropertyAccessor;
                for (FirValueParameter parameter2 : ((FirFunction)declaration2).getValueParameters()) {
                    this.reportIfUnderscore(parameter2, context2, reporter, isSingleUnderscoreAllowed);
                }
                break block5;
            }
            if (!(declaration2 instanceof FirFile)) break block5;
            for (FirImport firImport : ((FirFile)declaration2).getImports()) {
                FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(firImport.getAliasSource(), context2, reporter, false);
            }
        }
    }

    private final void reportIfUnderscore(FirDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter, boolean isSingleUnderscoreAllowed) {
        FirDeclaration firDeclaration;
        KtSourceElement declarationSource = declaration2.getSource();
        if (declarationSource != null && !(declarationSource.getKind() instanceof KtFakeSourceElementKind)) {
            FirProperty firProperty = declaration2 instanceof FirProperty ? (FirProperty)declaration2 : null;
            if (!Intrinsics.areEqual((Object)(firProperty != null ? firProperty.getName() : null), (Object)SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) {
                String rawName;
                SourceNavigator $this$reportIfUnderscore_u24lambda_u241 = SourceNavigator.Companion.forElement(declaration2);
                boolean bl = false;
                String string2 = rawName = $this$reportIfUnderscore_u24lambda_u241.getRawName(declaration2);
                boolean bl2 = string2 != null ? FirUnderscoreHelpersKt.isUnderscore(string2) : false;
                if (!(!bl2 || isSingleUnderscoreAllowed && Intrinsics.areEqual((Object)rawName, (Object)"_"))) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declarationSource, FirErrors.INSTANCE.getUNDERSCORE_IS_RESERVED(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
        if ((firDeclaration = declaration2) instanceof FirValueParameter) {
            FirUnderscoreHelpersKt.checkTypeRefForUnderscore(((FirValueParameter)declaration2).getReturnTypeRef(), context2, reporter);
        } else if (firDeclaration instanceof FirFunction) {
            FirUnderscoreHelpersKt.checkTypeRefForUnderscore(((FirFunction)declaration2).getReturnTypeRef(), context2, reporter);
            FirReceiverParameter firReceiverParameter = ((FirFunction)declaration2).getReceiverParameter();
            FirUnderscoreHelpersKt.checkTypeRefForUnderscore(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, context2, reporter);
        }
    }

    static /* synthetic */ void reportIfUnderscore$default(FirReservedUnderscoreDeclarationChecker firReservedUnderscoreDeclarationChecker, FirDeclaration firDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        firReservedUnderscoreDeclarationChecker.reportIfUnderscore(firDeclaration, checkerContext, diagnosticReporter, bl);
    }
}

