/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@PhaseDescription(name="StaticDefaultFunction", description="Make function adapters for default arguments static", prerequisite={})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/StaticDefaultFunctionLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getStaticFunctionWithReceivers", "function", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nStaticDefaultFunctionLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StaticDefaultFunctionLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/StaticDefaultFunctionLowering\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n72#2,2:90\n1#3:92\n*S KotlinDebug\n*F\n+ 1 StaticDefaultFunctionLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/StaticDefaultFunctionLowering\n*L\n80#1:90,2\n80#1:92\n*E\n"})
public final class StaticDefaultFunctionLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public StaticDefaultFunctionLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.accept(this, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        StaticDefaultFunctionLowering staticDefaultFunctionLowering = this;
        if (Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER()) && declaration2.getDispatchReceiverParameter() != null) {
            void it;
            IrSimpleFunction irSimpleFunction2;
            IrSimpleFunction irSimpleFunction3 = irSimpleFunction2 = this.getStaticFunctionWithReceivers(declaration2);
            StaticDefaultFunctionLowering staticDefaultFunctionLowering2 = staticDefaultFunctionLowering;
            boolean bl = false;
            it.setBody(IrInlineUtilsKt.moveBodyTo(declaration2, (IrFunction)it));
            staticDefaultFunctionLowering = staticDefaultFunctionLowering2;
            irSimpleFunction = irSimpleFunction2;
        } else {
            irSimpleFunction = declaration2;
        }
        return super.visitFunction(irSimpleFunction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        IrReturn irReturn;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction irFunction = (IrSimpleFunction)((Map)this.context.getStaticDefaultStubs()).get(expression2.getReturnTargetSymbol());
        StaticDefaultFunctionLowering staticDefaultFunctionLowering = this;
        if (irFunction != null) {
            void $this$visitReturn_u24lambda_u241;
            IrReturn irReturn2 = expression2;
            StaticDefaultFunctionLowering staticDefaultFunctionLowering2 = staticDefaultFunctionLowering;
            boolean bl = false;
            staticDefaultFunctionLowering = staticDefaultFunctionLowering2;
            irReturn = new IrReturnImpl($this$visitReturn_u24lambda_u241.getStartOffset(), $this$visitReturn_u24lambda_u241.getEndOffset(), $this$visitReturn_u24lambda_u241.getType(), irFunction.getSymbol(), $this$visitReturn_u24lambda_u241.getValue());
        } else {
            irReturn = expression2;
        }
        return super.visitReturn(irReturn);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (callee.getOrigin() != IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER() || expression2.getDispatchReceiver() == null) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction newCallee = this.getStaticFunctionWithReceivers(callee);
        IrCall newCall = IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, newCallee, true, false, null, null, 56, null);
        return super.visitCall(newCall);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction getStaticFunctionWithReceivers(IrSimpleFunction function2) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = this.context.getStaticDefaultStubs();
        IrSimpleFunctionSymbol key$iv = function2.getSymbol();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            IrSimpleFunction default$iv = IrUtilsKt.createStaticFunctionWithReceivers$default(this.context.getIrFactory(), function2.getParent(), function2.getName(), function2, null, null, null, null, false, false, null, (Function3)new Function3<IrFunction, IrFunction, Map<IrValueParameter, ? extends IrValueParameter>, Unit>((Object)this.context){

                public final void invoke(IrFunction p0, IrFunction p1, Map<IrValueParameter, ? extends IrValueParameter> p2) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((JvmBackendContext)this.receiver).remapMultiFieldValueClassStructure(p0, p1, p2);
                }

                public final String getSignature() {
                    return "remapMultiFieldValueClassStructure(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Ljava/util/Map;)V";
                }

                public final String getName() {
                    return "remapMultiFieldValueClassStructure";
                }

                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JvmBackendContext.class);
                }
            }, 1016, null);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (IrSimpleFunction)object;
    }
}

