/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarations;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InheritedDefaultMethodsOnClassesLoweringKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@PhaseDescription(name="InheritedDefaultMethodsOnClasses", description="Add bridge-implementations in classes that inherit default implementations from interfaces")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InheritedDefaultMethodsOnClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "transformMemberDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "generateCloneImplementation", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "fakeOverride", "cloneFun", "generateDelegationToDefaultImpl", "interfaceImplementation", "classOverride", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nInheritedDefaultMethodsOnClassesLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InheritedDefaultMethodsOnClassesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InheritedDefaultMethodsOnClassesLowering\n+ 2 transform.kt\norg/jetbrains/kotlin/ir/util/TransformKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,308:1\n26#2,4:309\n1#3:313\n1734#4,3:314\n416#5,10:317\n388#5,13:329\n72#6,2:327\n98#7,2:342\n*S KotlinDebug\n*F\n+ 1 InheritedDefaultMethodsOnClassesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InheritedDefaultMethodsOnClassesLowering\n*L\n42#1:309,4\n54#1:314,3\n70#1:317,10\n93#1:329,13\n70#1:327,2\n93#1:342,2\n*E\n"})
public final class InheritedDefaultMethodsOnClassesLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public InheritedDefaultMethodsOnClassesLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!JvmIrUtilsKt.isJvmInterface(irClass)) {
            List<IrDeclaration> $this$transformInPlace$iv = irClass.getDeclarations();
            boolean $i$f$transformInPlace = false;
            int i$iv = 0;
            int n = $this$transformInPlace$iv.size();
            while (i$iv < n) {
                void it;
                IrElement irElement;
                IrDeclaration irDeclaration2 = $this$transformInPlace$iv.get(i$iv);
                int n2 = i$iv++;
                List<IrDeclaration> list = $this$transformInPlace$iv;
                boolean bl = false;
                IrElement irElement2 = irElement = (IrElement)this.transformMemberDeclaration((IrDeclaration)it);
                if (irElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                }
                list.set(n2, (IrDeclaration)((IrElement)((IrDeclaration)irElement2)));
            }
        }
    }

    private final IrDeclaration transformMemberDeclaration(IrDeclaration declaration2) {
        if (!(declaration2 instanceof IrSimpleFunction)) {
            return declaration2;
        }
        if (((IrSimpleFunction)declaration2).isFakeOverride() && Intrinsics.areEqual((Object)((IrSimpleFunction)declaration2).getName().asString(), (Object)"clone")) {
            Object v2;
            IrSimpleFunction it;
            List<IrOverridableDeclaration> overriddenFunctions;
            block9: {
                overriddenFunctions = IrUtilsKt.allOverridden((IrOverridableDeclaration)declaration2, false);
                Iterable iterable = overriddenFunctions;
                for (Object t : iterable) {
                    it = (IrSimpleFunction)t;
                    boolean bl = false;
                    IrDeclarationWithName irDeclarationWithName = IrUtilsKt.getParentAsClass(it);
                    FqName fqName = StandardNames.FqNames.cloneable.toSafe();
                    Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"toSafe(...)");
                    if (!AdditionalIrUtilsKt.hasEqualFqName(irDeclarationWithName, fqName)) continue;
                    v2 = t;
                    break block9;
                }
                v2 = null;
            }
            IrSimpleFunction cloneFun = v2;
            if (cloneFun != null) {
                boolean bl;
                block10: {
                    Iterable $this$all$iv = overriddenFunctions;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (IrSimpleFunction)element$iv;
                            boolean bl2 = false;
                            if (it.isFakeOverride() || Intrinsics.areEqual((Object)it, (Object)cloneFun)) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return this.generateCloneImplementation((IrSimpleFunction)declaration2, cloneFun);
                }
            }
        }
        IrSimpleFunction irSimpleFunction = InheritedDefaultMethodsOnClassesLoweringKt.findInterfaceImplementation((IrSimpleFunction)declaration2, this.context.getConfig().getJvmDefaultMode());
        if (irSimpleFunction == null) {
            return declaration2;
        }
        IrSimpleFunction implementation2 = irSimpleFunction;
        return this.generateDelegationToDefaultImpl(implementation2, (IrSimpleFunction)declaration2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateCloneImplementation(IrSimpleFunction fakeOverride, IrSimpleFunction cloneFun) {
        void $this$generateCloneImplementation_u24lambda_u245_u24lambda_u244_u24lambda_u243;
        void $this$generateCloneImplementation_u24lambda_u245_u24lambda_u244;
        IrCall irCall;
        void this_$iv$iv;
        JvmIrBuilder jvmIrBuilder;
        boolean bl = fakeOverride.isFakeOverride();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        IrSimpleFunction irFunction = this.context.getCachedDeclarations().getDefaultImplsRedirection(fakeOverride);
        IrClass irClass = IrUtilsKt.getParentAsClass(fakeOverride);
        int classStartOffset = irClass.getStartOffset();
        JvmIrBuilder $this$generateCloneImplementation_u24lambda_u245 = jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder(this.context, irFunction.getSymbol(), classStartOffset, classStartOffset);
        boolean bl2 = false;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = $this$generateCloneImplementation_u24lambda_u245;
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var15_17 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction = irFunction;
        boolean bl3 = false;
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateCloneImplementation_u24lambda_u245_u24lambda_u244, cloneFun, null, IrUtilsKt.getParentAsClass(cloneFun).getSymbol());
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$generateCloneImplementation_u24lambda_u245_u24lambda_u244;
        void var21_23 = $this$generateCloneImplementation_u24lambda_u245_u24lambda_u244;
        boolean bl4 = false;
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateCloneImplementation_u24lambda_u245_u24lambda_u244;
        IrValueParameter irValueParameter = irFunction.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        $this$generateCloneImplementation_u24lambda_u245_u24lambda_u244_u24lambda_u243.setDispatchReceiver(ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter));
        Unit unit = Unit.INSTANCE;
        var21_23.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irCall));
        irSimpleFunction.setBody(this_$iv$iv.doBuild());
        return irFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateDelegationToDefaultImpl(IrSimpleFunction interfaceImplementation, IrSimpleFunction classOverride) {
        void $this$generateDelegationToDefaultImpl_u24lambda_u2410_u24lambda_u249_u24lambda_u248;
        IrCall irCall;
        void $this$generateDelegationToDefaultImpl_u24lambda_u2410_u24lambda_u249;
        void this_$iv$iv;
        DeclarationIrBuilder declarationIrBuilder;
        IrSimpleFunction irFunction = this.context.getCachedDeclarations().getDefaultImplsRedirection(classOverride);
        IrSimpleFunction superMethod = (IrSimpleFunction)JvmIrUtilsKt.firstSuperMethodFromKotlin(irFunction, interfaceImplementation).getOwner();
        IrSimpleType superClassType = IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(superMethod));
        IrSimpleFunction defaultImplFun = JvmCachedDeclarations.getDefaultImplsFunction$default(this.context.getCachedDeclarations(), superMethod, false, 2, null);
        int classStartOffset = IrUtilsKt.getParentAsClass(classOverride).getStartOffset();
        JvmBackendContext backendContext = this.context;
        DeclarationIrBuilder $this$generateDelegationToDefaultImpl_u24lambda_u2410 = declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, (IrSymbol)irFunction.getSymbol(), classStartOffset, classStartOffset);
        boolean bl = false;
        IrBuilderWithScope $this$irBlock_u24default$iv = $this$generateDelegationToDefaultImpl_u24lambda_u2410;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void var20_20 = this_$iv$iv;
        IrBuilderWithScope irBuilderWithScope = $this$generateDelegationToDefaultImpl_u24lambda_u2410;
        IrSimpleFunction irSimpleFunction = irFunction;
        boolean bl2 = false;
        Map<IrValueParameter, IrExpression> parameter2arguments = backendContext.getMultiFieldValueClassReplacements().mapFunctionMfvcStructures((IrBlockBuilder)$this$generateDelegationToDefaultImpl_u24lambda_u2410_u24lambda_u249, defaultImplFun, irFunction, (Function2<? super IrValueParameter, ? super IrType, ? extends IrExpression>)((Function2)(arg_0, arg_1) -> InheritedDefaultMethodsOnClassesLowering.generateDelegationToDefaultImpl$lambda$10$lambda$9$lambda$7((IrBlockBuilder)$this$generateDelegationToDefaultImpl_u24lambda_u2410_u24lambda_u249, irFunction, superClassType, arg_0, arg_1)));
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)$this$generateDelegationToDefaultImpl_u24lambda_u2410_u24lambda_u249, defaultImplFun.getSymbol(), irFunction.getReturnType(), 0, 0, null, 28, null);
        void var27_27 = $this$generateDelegationToDefaultImpl_u24lambda_u2410_u24lambda_u249;
        boolean bl3 = false;
        int n = ((Collection)IrUtilsKt.getParentAsClass(superMethod).getTypeParameters()).size();
        for (int index = 0; index < n; ++index) {
            $this$generateDelegationToDefaultImpl_u24lambda_u2410_u24lambda_u249_u24lambda_u248.putTypeArgument(index, JvmIrUtilsKt.createPlaceholderAnyNType($this$generateDelegationToDefaultImpl_u24lambda_u2410_u24lambda_u249.getContext().getIrBuiltIns()));
        }
        IrUtilsKt.passTypeArgumentsFrom((IrFunctionAccessExpression)$this$generateDelegationToDefaultImpl_u24lambda_u2410_u24lambda_u249_u24lambda_u248, irFunction, IrUtilsKt.getParentAsClass(superMethod).getTypeParameters().size());
        for (Map.Entry<IrValueParameter, IrExpression> entry : parameter2arguments.entrySet()) {
            IrValueParameter parameter2 = entry.getKey();
            IrExpression argument = entry.getValue();
            if (argument == null) continue;
            IrExpressionsKt.putArgument((IrFunctionAccessExpression)$this$generateDelegationToDefaultImpl_u24lambda_u2410_u24lambda_u249_u24lambda_u248, parameter2, argument);
        }
        var27_27.unaryPlus(irCall);
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, this_$iv$iv.doBuild()));
        return irFunction;
    }

    private static final IrExpression generateDelegationToDefaultImpl$lambda$10$lambda$9$lambda$7(IrBlockBuilder $this_irBlock, IrSimpleFunction $irFunction, IrSimpleType $superClassType, IrValueParameter sourceParameter, IrType irType) {
        Intrinsics.checkNotNullParameter((Object)sourceParameter, (String)"sourceParameter");
        Intrinsics.checkNotNullParameter((Object)irType, (String)"<unused var>");
        IrGetValueImpl it = ExpressionHelpersKt.irGet($this_irBlock, sourceParameter);
        boolean bl = false;
        return !Intrinsics.areEqual((Object)sourceParameter, (Object)$irFunction.getDispatchReceiverParameter()) ? (IrExpression)it : InheritedDefaultMethodsOnClassesLoweringKt.reinterpretAsDispatchReceiverOfType(it, $superClassType);
    }
}

