/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.project.structure.DanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.project.structure.KtDanglingFileModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u00101\u001a\u00020\u000f2\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0002J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010*R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010*R\u0016\u00108\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0016\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/impl/KtDanglingFileModuleImpl;", "Lorg/jetbrains/kotlin/analysis/project/structure/KtDanglingFileModule;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "contextModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "resolutionMode", "Lorg/jetbrains/kotlin/analysis/project/structure/DanglingFileResolutionMode;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Lorg/jetbrains/kotlin/analysis/project/structure/DanglingFileResolutionMode;)V", "getContextModule", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getResolutionMode", "()Lorg/jetbrains/kotlin/analysis/project/structure/DanglingFileResolutionMode;", "isCodeFragment", "", "()Z", "fileRef", "Lcom/intellij/psi/SmartPsiElementPointer;", "getFileRef$annotations", "()V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "directRegularDependencies", "", "getDirectRegularDependencies", "()Ljava/util/List;", "directDependsOnDependencies", "getDirectDependsOnDependencies", "directFriendDependencies", "getDirectFriendDependencies", "transitiveDependsOnDependencies", "getTransitiveDependsOnDependencies", "equals", "other", "", "hashCode", "", "toString", "", "validFileOrNull", "getValidFileOrNull", "project-structure"})
@SourceDebugExtension(value={"SMAP\nKtDanglingFileModuleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtDanglingFileModuleImpl.kt\norg/jetbrains/kotlin/analysis/project/structure/impl/KtDanglingFileModuleImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class KtDanglingFileModuleImpl
implements KtDanglingFileModule {
    @NotNull
    private final KtModule contextModule;
    @NotNull
    private final DanglingFileResolutionMode resolutionMode;
    private final boolean isCodeFragment;
    @NotNull
    private final SmartPsiElementPointer<KtFile> fileRef;

    public KtDanglingFileModuleImpl(@NotNull KtFile file2, @NotNull KtModule contextModule, @NotNull DanglingFileResolutionMode resolutionMode) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)contextModule, (String)"contextModule");
        Intrinsics.checkNotNullParameter((Object)((Object)resolutionMode), (String)"resolutionMode");
        this.contextModule = contextModule;
        this.resolutionMode = resolutionMode;
        this.isCodeFragment = file2 instanceof KtCodeFragment;
        this.fileRef = PsiUtilsKt.createSmartPointer((PsiElement)file2);
        if (!(!Intrinsics.areEqual((Object)this.getContextModule(), (Object)this))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.getContextModule() instanceof KtDanglingFileModule && !(file2 instanceof KtCodeFragment)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    @Override
    @NotNull
    public KtModule getContextModule() {
        return this.contextModule;
    }

    @Override
    @NotNull
    public DanglingFileResolutionMode getResolutionMode() {
        return this.resolutionMode;
    }

    @Override
    public boolean isCodeFragment() {
        return this.isCodeFragment;
    }

    private static /* synthetic */ void getFileRef$annotations() {
    }

    @Override
    @NotNull
    public KtFile getFile() {
        KtFile ktFile = this.getValidFileOrNull();
        if (ktFile == null) {
            throw new IllegalStateException("Dangling file module is invalid".toString());
        }
        return ktFile;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.getContextModule().getProject();
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return this.getContextModule().getPlatform();
    }

    @Override
    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return this.getContextModule().getAnalyzerServices();
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope(this.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
        return globalSearchScope;
    }

    @Override
    @NotNull
    public List<KtModule> getDirectRegularDependencies() {
        return this.getContextModule().getDirectRegularDependencies();
    }

    @Override
    @NotNull
    public List<KtModule> getDirectDependsOnDependencies() {
        return this.getContextModule().getDirectDependsOnDependencies();
    }

    @Override
    @NotNull
    public List<KtModule> getDirectFriendDependencies() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.getContextModule()), (Iterable)this.getContextModule().getDirectFriendDependencies());
    }

    @Override
    @NotNull
    public List<KtModule> getTransitiveDependsOnDependencies() {
        return this.getContextModule().getTransitiveDependsOnDependencies();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof KtDanglingFileModuleImpl) {
            KtFile selfFile = this.fileRef.getElement();
            KtFile otherFile = ((KtDanglingFileModuleImpl)other).fileRef.getElement();
            return selfFile != null && Intrinsics.areEqual((Object)selfFile, (Object)otherFile) && Intrinsics.areEqual((Object)this.getContextModule(), (Object)((KtDanglingFileModuleImpl)other).getContextModule()) && this.getResolutionMode() == ((KtDanglingFileModuleImpl)other).getResolutionMode();
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.fileRef.getElement(), this.getContextModule()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        Object object = this.getValidFileOrNull();
        if (object == null || (object = ((PsiFileImpl)object).getName()) == null) {
            object = "Invalid dangling file module";
        }
        return object;
    }

    private final KtFile getValidFileOrNull() {
        KtFile ktFile;
        KtFile ktFile2 = this.fileRef.getElement();
        if (ktFile2 != null) {
            KtFile ktFile3;
            KtFile it = ktFile3 = ktFile2;
            boolean bl = false;
            ktFile = it.isValid() ? ktFile3 : null;
        } else {
            ktFile = null;
        }
        return ktFile;
    }
}

