/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.evaluate;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0005*\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0005*\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\f\u0010\u0013\u001a\u00020\u0005*\u00020\u0005H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u001a\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002J\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010\"\u001a\u0004\u0018\u00010\u0005*\u00020\u0005H\u0002J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u000e\u0010&\u001a\u0004\u0018\u00010\u001f*\u00020\u001cH\u0002J\u000e\u0010&\u001a\u0004\u0018\u00010\u001f*\u00020'H\u0002J\u0017\u0010&\u001a\u00020\u001f\"\u0004\b\u0000\u0010(*\u0002H(H\u0002\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u0004\u0018\u00010\u0001*\u00020\u001f2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0002J \u0010\u000e\u001a\u00020\u0005*\u00020\u001f2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0002J\u000e\u0010.\u001a\u0004\u0018\u00010/*\u00020\u0019H\u0002R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\rR\u0018\u0010$\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\rR\u0018\u0010%\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\r\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator;", "", "<init>", "()V", "evaluate", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "mode", "Lorg/jetbrains/kotlin/analysis/api/components/KtConstantEvaluationMode;", "isStringLength", "", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "toLiteralExpression", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;", "evaluateAsKtConstantValue", "Lorg/jetbrains/kotlin/analysis/api/base/KtConstantValue;", "adaptToConstKind", "evaluateStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "evaluateFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "adjustType", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "toCompileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "evaluateStringLength", "other", "isStringEquals", "isStringPlus", "toConstantValueKind", "", "T", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/types/ConstantValueKind;", "convertToNumber", "value", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "getOriginalFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirCompileTimeConstantEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,380:1\n32#2:381\n24#2:382\n16#2:383\n43#3:384\n43#3:385\n*S KotlinDebug\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator\n*L\n83#1:381\n95#1:382\n95#1:383\n159#1:384\n179#1:385\n*E\n"})
public final class FirCompileTimeConstantEvaluator {
    @NotNull
    public static final FirCompileTimeConstantEvaluator INSTANCE = new FirCompileTimeConstantEvaluator();

    private FirCompileTimeConstantEvaluator() {
    }

    @Nullable
    public final FirLiteralExpression evaluate(@Nullable FirElement fir, @NotNull KtConstantEvaluationMode mode) {
        FirLiteralExpression firLiteralExpression;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        FirElement firElement = fir;
        if (firElement instanceof FirPropertyAccessExpression) {
            FirVariableSymbol referredVariable = FirReferenceUtilsKt.toResolvedVariableSymbol$default(((FirPropertyAccessExpression)fir).getCalleeReference(), false, 1, null);
            if (referredVariable instanceof FirPropertySymbol) {
                if (this.isStringLength(((FirPropertySymbol)referredVariable).getCallableId())) {
                    FirLiteralExpression firLiteralExpression2 = this.evaluate(((FirPropertyAccessExpression)fir).getExplicitReceiver(), mode);
                    firLiteralExpression = firLiteralExpression2 != null ? this.evaluateStringLength(firLiteralExpression2) : null;
                } else {
                    firLiteralExpression = this.toLiteralExpression((FirPropertySymbol)referredVariable, mode);
                }
            } else {
                firLiteralExpression = referredVariable instanceof FirFieldSymbol ? this.toLiteralExpression((FirFieldSymbol)referredVariable, mode) : null;
            }
        } else if (firElement instanceof FirLiteralExpression) {
            firLiteralExpression = this.adaptToConstKind((FirLiteralExpression)fir);
        } else if (firElement instanceof FirFunctionCall) {
            firLiteralExpression = this.evaluateFunctionCall((FirFunctionCall)fir, mode);
        } else if (firElement instanceof FirStringConcatenationCall) {
            firLiteralExpression = this.evaluateStringConcatenationCall((FirStringConcatenationCall)fir, mode);
        } else if (firElement instanceof FirNamedReference) {
            FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)fir, false, 1, null);
            firLiteralExpression = firPropertySymbol != null ? this.toLiteralExpression(firPropertySymbol, mode) : null;
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    private final boolean isStringLength(CallableId $this$isStringLength) {
        return Intrinsics.areEqual((Object)$this$isStringLength.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringLength.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"length");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FirLiteralExpression toLiteralExpression(FirPropertySymbol $this$toLiteralExpression, KtConstantEvaluationMode mode) {
        if (mode == KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION) {
            FirCallableSymbol $this$isConst$iv = $this$toLiteralExpression;
            boolean $i$f$isConst = false;
            if (!$this$isConst$iv.getRawStatus().isConst()) {
                return null;
            }
        }
        if (!$this$toLiteralExpression.isVal()) return null;
        if (!$this$toLiteralExpression.getHasInitializer()) return null;
        FirLiteralExpression firLiteralExpression = this.evaluate($this$toLiteralExpression.getResolvedInitializer(), mode);
        return firLiteralExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FirLiteralExpression toLiteralExpression(FirFieldSymbol $this$toLiteralExpression, KtConstantEvaluationMode mode) {
        if (mode == KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION) {
            FirCallableSymbol $this$isStatic$iv = $this$toLiteralExpression;
            boolean $i$f$isStatic = false;
            if (!$this$isStatic$iv.getRawStatus().isStatic()) return null;
            FirCallableSymbol $this$isFinal$iv = $this$toLiteralExpression;
            boolean $i$f$isFinal = false;
            if ($this$isFinal$iv.getResolvedStatus().getModality() != Modality.FINAL) return null;
            boolean bl = true;
            if (!bl) {
                return null;
            }
        }
        if (!$this$toLiteralExpression.isVal()) return null;
        if (!$this$toLiteralExpression.getHasInitializer()) return null;
        FirLiteralExpression firLiteralExpression = this.evaluate(((FirField)$this$toLiteralExpression.getFir()).getInitializer(), mode);
        return firLiteralExpression;
    }

    @Nullable
    public final KtConstantValue evaluateAsKtConstantValue(@NotNull FirElement fir, @NotNull KtConstantEvaluationMode mode) {
        KtConstantValue ktConstantValue;
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        FirLiteralExpression firLiteralExpression = this.evaluate(fir, mode);
        if (firLiteralExpression == null) {
            return null;
        }
        FirLiteralExpression evaluated = firLiteralExpression;
        Object value2 = evaluated.getValue();
        Object object = UtilsKt.getPsi(evaluated);
        KtElement psi = object instanceof KtElement ? (KtElement)object : null;
        object = evaluated.getKind();
        if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.Byte.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Byte");
            ktConstantValue = new KtConstantValue.KtByteConstantValue((Byte)value2, psi);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.Int.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Int");
            ktConstantValue = new KtConstantValue.KtIntConstantValue((Integer)value2, psi);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.Long.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Long");
            ktConstantValue = new KtConstantValue.KtLongConstantValue((Long)value2, psi);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.Short.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Short");
            ktConstantValue = new KtConstantValue.KtShortConstantValue((Short)value2, psi);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.UByte");
            ktConstantValue = new KtConstantValue.KtUnsignedByteConstantValue(((UByte)value2).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.UInt");
            ktConstantValue = new KtConstantValue.KtUnsignedIntConstantValue(((UInt)value2).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.ULong");
            ktConstantValue = new KtConstantValue.KtUnsignedLongConstantValue(((ULong)value2).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.UShort");
            ktConstantValue = new KtConstantValue.KtUnsignedShortConstantValue(((UShort)value2).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.Double.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Double");
            ktConstantValue = new KtConstantValue.KtDoubleConstantValue((Double)value2, psi);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.Float.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Float");
            ktConstantValue = new KtConstantValue.KtFloatConstantValue(((Float)value2).floatValue(), psi);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            ktConstantValue = new KtConstantValue.KtBooleanConstantValue((Boolean)value2, psi);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.Char.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Char");
            ktConstantValue = new KtConstantValue.KtCharConstantValue(((Character)value2).charValue(), psi);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.String.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.String");
            ktConstantValue = new KtConstantValue.KtStringConstantValue((String)value2, psi);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.Null.INSTANCE)) {
            ktConstantValue = new KtConstantValue.KtNullConstantValue(psi);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.IntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Long");
            long l = (Long)value2;
            ktConstantValue = Integer.MIN_VALUE < l && l < Integer.MAX_VALUE ? (KtConstantValue)new KtConstantValue.KtIntConstantValue((int)l, psi) : (KtConstantValue)new KtConstantValue.KtLongConstantValue(l, psi);
        } else if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.ULong");
            long l = ((ULong)value2).unbox-impl();
            ktConstantValue = Long.compareUnsigned(ULong.constructor-impl((long)(0L & 0xFFFFFFFFL)), l) < 0 && Long.compareUnsigned(l, ULong.constructor-impl((long)((long)-1 & 0xFFFFFFFFL))) < 0 ? (KtConstantValue)new KtConstantValue.KtUnsignedIntConstantValue(UInt.constructor-impl((int)((int)l)), psi, null) : (KtConstantValue)new KtConstantValue.KtUnsignedLongConstantValue(l, psi, null);
        } else {
            if (Intrinsics.areEqual((Object)object, (Object)ConstantValueKind.Error.INSTANCE)) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Should not be possible to get from FIR tree", null, fir, null, null, null, 58, null);
                throw null;
            }
            throw new NoWhenBranchMatchedException();
        }
        return ktConstantValue;
    }

    private final FirLiteralExpression adaptToConstKind(FirLiteralExpression $this$adaptToConstKind) {
        ConstantValueKind constantValueKind = $this$adaptToConstKind.getKind();
        KtSourceElement ktSourceElement = $this$adaptToConstKind.getSource();
        Object object = this.convertToNumber($this$adaptToConstKind.getKind(), $this$adaptToConstKind.getValue());
        if (object == null) {
            object = $this$adaptToConstKind.getValue();
        }
        return this.toLiteralExpression(constantValueKind, ktSourceElement, object);
    }

    private final FirLiteralExpression evaluateStringConcatenationCall(FirStringConcatenationCall stringConcatenationCall, KtConstantEvaluationMode mode) {
        StringBuilder stringBuilder;
        StringBuilder $this$evaluateStringConcatenationCall_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        FirCall $this$arguments$iv = stringConcatenationCall;
        boolean $i$f$getArguments = false;
        for (FirExpression arg : $this$arguments$iv.getArgumentList().getArguments()) {
            FirLiteralExpression evaluated;
            if (INSTANCE.evaluate(arg, mode) == null) {
                return null;
            }
            $this$evaluateStringConcatenationCall_u24lambda_u240.append(String.valueOf(evaluated.getValue()));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String concatenated = string2;
        return this.toLiteralExpression(ConstantValueKind.String.INSTANCE, stringConcatenationCall.getSource(), concatenated);
    }

    private final FirLiteralExpression evaluateFunctionCall(FirFunctionCall functionCall, KtConstantEvaluationMode mode) {
        FirPureAbstractElement firPureAbstractElement = this.getOriginalFunction(functionCall);
        FirSimpleFunction firSimpleFunction = firPureAbstractElement instanceof FirSimpleFunction ? (FirSimpleFunction)firPureAbstractElement : null;
        if (firSimpleFunction == null) {
            return null;
        }
        FirSimpleFunction function2 = firSimpleFunction;
        FirLiteralExpression firLiteralExpression = this.evaluate(functionCall.getExplicitReceiver(), mode);
        if (firLiteralExpression == null) {
            return null;
        }
        FirLiteralExpression opr1 = firLiteralExpression;
        firPureAbstractElement = this.evaluate(opr1, function2);
        if (firPureAbstractElement != null) {
            FirPureAbstractElement it = firPureAbstractElement;
            boolean bl = false;
            return INSTANCE.adjustType((FirLiteralExpression)it, FirTypeUtilsKt.getResolvedType(functionCall));
        }
        FirCall $this$arguments$iv = functionCall;
        boolean $i$f$getArguments = false;
        FirExpression firExpression = (FirExpression)CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        if (firExpression == null) {
            return null;
        }
        FirExpression argument = firExpression;
        FirLiteralExpression firLiteralExpression2 = this.evaluate(argument, mode);
        if (firLiteralExpression2 == null) {
            return null;
        }
        FirLiteralExpression opr2 = firLiteralExpression2;
        FirLiteralExpression firLiteralExpression3 = this.evaluate(opr1, function2, opr2);
        if (firLiteralExpression3 != null) {
            FirLiteralExpression it = firLiteralExpression3;
            boolean bl = false;
            return INSTANCE.adjustType(it, FirTypeUtilsKt.getResolvedType(functionCall));
        }
        return null;
    }

    private final FirLiteralExpression adjustType(FirLiteralExpression $this$adjustType, ConeKotlinType expectedType) {
        FirLiteralExpression expression2;
        FirLiteralExpression firLiteralExpression;
        FirLiteralExpression firLiteralExpression2;
        ConstantValueKind expectedKind = this.toConstantValueKind(expectedType);
        if (expectedKind != null && !Intrinsics.areEqual((Object)expectedKind, (Object)$this$adjustType.getKind()) && $this$adjustType.getValue() instanceof Number) {
            Object object = $this$adjustType.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            Object object2 = this.convertToNumber(expectedKind, (Number)object);
            Intrinsics.checkNotNull((Object)object2);
            Object typeAdjustedValue = object2;
            firLiteralExpression2 = this.toLiteralExpression(expectedKind, $this$adjustType.getSource(), typeAdjustedValue);
        } else {
            firLiteralExpression2 = $this$adjustType;
        }
        FirLiteralExpression $this$adjustType_u24lambda_u243 = firLiteralExpression = (expression2 = firLiteralExpression2);
        boolean bl = false;
        $this$adjustType_u24lambda_u243.replaceConeTypeOrNull(expectedType);
        return firLiteralExpression;
    }

    private final CompileTimeType toCompileTimeType(ConstantValueKind $this$toCompileTimeType) {
        ConstantValueKind constantValueKind = $this$toCompileTimeType;
        return Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE) ? CompileTimeType.BYTE : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Short.INSTANCE) ? CompileTimeType.SHORT : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Int.INSTANCE) ? CompileTimeType.INT : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Long.INSTANCE) ? CompileTimeType.LONG : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Double.INSTANCE) ? CompileTimeType.DOUBLE : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Float.INSTANCE) ? CompileTimeType.FLOAT : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Char.INSTANCE) ? CompileTimeType.CHAR : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE) ? CompileTimeType.BOOLEAN : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.String.INSTANCE) ? CompileTimeType.STRING : CompileTimeType.ANY))))))));
    }

    private final FirLiteralExpression evaluate(FirLiteralExpression $this$evaluate, FirSimpleFunction function2) {
        FirLiteralExpression firLiteralExpression;
        Object object;
        Object opr;
        if ($this$evaluate.getValue() == null) {
            return null;
        }
        Object object2 = $this$evaluate.getValue();
        String string2 = object2 instanceof String ? (String)object2 : null;
        if (string2 != null) {
            opr = string2;
            boolean bl = false;
            String string3 = function2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            object = OperationsMapGeneratedKt.evalUnaryOp(string3, INSTANCE.toCompileTimeType($this$evaluate.getKind()), opr);
            if (object != null) {
                Object it = object;
                boolean bl2 = false;
                return INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
            }
        }
        Object object3 = this.convertToNumber($this$evaluate.getKind(), $this$evaluate.getValue());
        if (object3 != null) {
            opr = object3;
            boolean bl = false;
            String string4 = function2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
            object = OperationsMapGeneratedKt.evalUnaryOp(string4, INSTANCE.toCompileTimeType($this$evaluate.getKind()), opr);
            if (object != null) {
                Object it = object;
                boolean bl3 = false;
                firLiteralExpression = INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
            } else {
                firLiteralExpression = null;
            }
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    private final FirLiteralExpression evaluateStringLength(FirLiteralExpression $this$evaluateStringLength) {
        FirLiteralExpression firLiteralExpression;
        Object object = $this$evaluateStringLength.getValue();
        String string2 = object instanceof String ? (String)object : null;
        if (string2 != null) {
            int it = string2.length();
            boolean bl = false;
            firLiteralExpression = INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), $this$evaluateStringLength.getSource(), it);
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    private final FirLiteralExpression evaluate(FirLiteralExpression $this$evaluate, FirSimpleFunction function2, FirLiteralExpression other) {
        FirLiteralExpression firLiteralExpression;
        Object object;
        Object opr2;
        Object opr1;
        if ($this$evaluate.getValue() == null || other.getValue() == null) {
            return null;
        }
        CompileTimeType rightType = this.isStringEquals(function2.getSymbol().getCallableId()) ? CompileTimeType.ANY : (this.isStringPlus(function2.getSymbol().getCallableId()) ? CompileTimeType.ANY : this.toCompileTimeType(other.getKind()));
        Object object2 = $this$evaluate.getValue();
        String string2 = object2 instanceof String ? (String)object2 : null;
        if (string2 != null) {
            opr1 = string2;
            boolean bl = false;
            Object object3 = other.getValue();
            if (object3 != null) {
                opr2 = object3;
                boolean bl2 = false;
                String string3 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                object = OperationsMapGeneratedKt.evalBinaryOp(string3, INSTANCE.toCompileTimeType($this$evaluate.getKind()), opr1, rightType, opr2);
                if (object != null) {
                    Object it = object;
                    boolean bl3 = false;
                    return INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
                }
            }
        }
        Object object4 = this.convertToNumber($this$evaluate.getKind(), $this$evaluate.getValue());
        if (object4 != null) {
            opr1 = object4;
            boolean bl = false;
            Object object5 = INSTANCE.convertToNumber(other.getKind(), other.getValue());
            if (object5 != null) {
                opr2 = object5;
                boolean bl4 = false;
                String string4 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
                object = OperationsMapGeneratedKt.evalBinaryOp(string4, INSTANCE.toCompileTimeType($this$evaluate.getKind()), opr1, INSTANCE.toCompileTimeType(other.getKind()), opr2);
                if (object != null) {
                    Object it = object;
                    boolean bl5 = false;
                    firLiteralExpression = INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
                } else {
                    firLiteralExpression = null;
                }
            } else {
                firLiteralExpression = null;
            }
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    private final boolean isStringEquals(CallableId $this$isStringEquals) {
        return Intrinsics.areEqual((Object)$this$isStringEquals.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringEquals.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"equals");
    }

    private final boolean isStringPlus(CallableId $this$isStringPlus) {
        return Intrinsics.areEqual((Object)$this$isStringPlus.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringPlus.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"plus");
    }

    private final ConstantValueKind toConstantValueKind(ConeKotlinType $this$toConstantValueKind) {
        Object object;
        ConeKotlinType coneKotlinType = $this$toConstantValueKind;
        if (coneKotlinType instanceof ConeErrorType) {
            object = null;
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            String string2 = ((ConeLookupTagBasedType)$this$toConstantValueKind).getLookupTag().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            object = this.toConstantValueKind(string2);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = this.toConstantValueKind(((ConeFlexibleType)$this$toConstantValueKind).getUpperBound());
        } else if (coneKotlinType instanceof ConeCapturedType) {
            object = ((ConeCapturedType)$this$toConstantValueKind).getLowerType();
            if (object == null || (object = this.toConstantValueKind((ConeKotlinType)object)) == null) {
                List<ConeKotlinType> list = ((ConeCapturedType)$this$toConstantValueKind).getConstructor().getSupertypes();
                Intrinsics.checkNotNull(list);
                object = this.toConstantValueKind((ConeKotlinType)CollectionsKt.first(list));
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            object = this.toConstantValueKind(((ConeDefinitelyNotNullType)$this$toConstantValueKind).getOriginal());
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            object = this.toConstantValueKind((ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)$this$toConstantValueKind).getIntersectedTypes()));
        } else if (coneKotlinType instanceof ConeStubType || coneKotlinType instanceof ConeIntegerLiteralType || coneKotlinType instanceof ConeTypeVariableType) {
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final ConstantValueKind toConstantValueKind(String $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        switch ($this$toConstantValueKind) {
            case "Byte": {
                constantValueKind = ConstantValueKind.Byte.INSTANCE;
                break;
            }
            case "Double": {
                constantValueKind = ConstantValueKind.Double.INSTANCE;
                break;
            }
            case "Float": {
                constantValueKind = ConstantValueKind.Float.INSTANCE;
                break;
            }
            case "Int": {
                constantValueKind = ConstantValueKind.Int.INSTANCE;
                break;
            }
            case "Long": {
                constantValueKind = ConstantValueKind.Long.INSTANCE;
                break;
            }
            case "Short": {
                constantValueKind = ConstantValueKind.Short.INSTANCE;
                break;
            }
            case "Char": {
                constantValueKind = ConstantValueKind.Char.INSTANCE;
                break;
            }
            case "String": {
                constantValueKind = ConstantValueKind.String.INSTANCE;
                break;
            }
            case "Boolean": {
                constantValueKind = ConstantValueKind.Boolean.INSTANCE;
                break;
            }
            default: {
                constantValueKind = null;
            }
        }
        return constantValueKind;
    }

    private final <T> ConstantValueKind toConstantValueKind(T $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        T t = $this$toConstantValueKind;
        if (t instanceof Byte) {
            constantValueKind = ConstantValueKind.Byte.INSTANCE;
        } else if (t instanceof Double) {
            constantValueKind = ConstantValueKind.Double.INSTANCE;
        } else if (t instanceof Float) {
            constantValueKind = ConstantValueKind.Float.INSTANCE;
        } else if (t instanceof Integer) {
            constantValueKind = ConstantValueKind.Int.INSTANCE;
        } else if (t instanceof Long) {
            constantValueKind = ConstantValueKind.Long.INSTANCE;
        } else if (t instanceof Short) {
            constantValueKind = ConstantValueKind.Short.INSTANCE;
        } else if (t instanceof Character) {
            constantValueKind = ConstantValueKind.Char.INSTANCE;
        } else if (t instanceof String) {
            constantValueKind = ConstantValueKind.String.INSTANCE;
        } else if (t instanceof Boolean) {
            constantValueKind = ConstantValueKind.Boolean.INSTANCE;
        } else if (t == null) {
            constantValueKind = ConstantValueKind.Null.INSTANCE;
        } else {
            throw new IllegalStateException("Unknown constant value".toString());
        }
        return constantValueKind;
    }

    private final Object convertToNumber(ConstantValueKind $this$convertToNumber, Object value2) {
        if (value2 == null) {
            return null;
        }
        ConstantValueKind constantValueKind = $this$convertToNumber;
        return Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE) ? (Comparable)((Boolean)value2) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Char.INSTANCE) ? (Comparable)((Character)value2) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.String.INSTANCE) ? (Comparable)((Object)((String)value2)) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE) ? (Comparable)Byte.valueOf(((Number)value2).byteValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Double.INSTANCE) ? (Comparable)Double.valueOf(((Number)value2).doubleValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Float.INSTANCE) ? (Comparable)Float.valueOf(((Number)value2).floatValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Int.INSTANCE) ? (Comparable)Integer.valueOf(((Number)value2).intValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Long.INSTANCE) ? (Comparable)Long.valueOf(((Number)value2).longValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Short.INSTANCE) ? (Comparable)Short.valueOf(((Number)value2).shortValue()) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE) ? UByte.box-impl((byte)UByte.constructor-impl((byte)((byte)((Number)value2).longValue()))) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE) ? UShort.box-impl((short)UShort.constructor-impl((short)((short)((Number)value2).longValue()))) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE) ? UInt.box-impl((int)UInt.constructor-impl((int)((int)((Number)value2).longValue()))) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE) ? ULong.box-impl((long)ULong.constructor-impl((long)((Number)value2).longValue())) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE) ? ULong.box-impl((long)ULong.constructor-impl((long)((Number)value2).longValue())) : null)))))))))))));
    }

    private final FirLiteralExpression toLiteralExpression(ConstantValueKind $this$toLiteralExpression, KtSourceElement source, Object value2) {
        return FirConstExpressionBuilderKt.buildLiteralExpression$default(source, $this$toLiteralExpression, value2, null, false, 8, null);
    }

    private final FirCallableDeclaration getOriginalFunction(FirFunctionCall $this$getOriginalFunction) {
        FirBasedSymbol<?> symbol;
        FirNamedReference reference2 = $this$getOriginalFunction.getCalleeReference();
        FirBasedSymbol<?> firBasedSymbol = symbol = reference2 instanceof FirResolvedNamedReference ? ((FirResolvedNamedReference)reference2).getResolvedSymbol() : null;
        Object obj = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        return obj instanceof FirCallableDeclaration ? (FirCallableDeclaration)obj : null;
    }
}

