/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.components.ElementsToShortenCollector;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/CollectingVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "collector", "Lorg/jetbrains/kotlin/analysis/api/fir/components/ElementsToShortenCollector;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/components/ElementsToShortenCollector;)V", "visitedProperty", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitValueParameter", "", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "visitProperty", "property", "visitScript", "script", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitResolvedQualifier", "resolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "visitErrorResolvedQualifier", "errorResolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitThisReference", "thisReference", "Lorg/jetbrains/kotlin/fir/references/FirThisReference;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirReferenceShortener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirReferenceShortener.kt\norg/jetbrains/kotlin/analysis/api/fir/components/CollectingVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1590:1\n1#2:1591\n1863#3,2:1592\n*S KotlinDebug\n*F\n+ 1 KtFirReferenceShortener.kt\norg/jetbrains/kotlin/analysis/api/fir/components/CollectingVisitor\n*L\n454#1:1592,2\n*E\n"})
final class CollectingVisitor
extends FirVisitorVoid {
    @NotNull
    private final ElementsToShortenCollector collector;
    @NotNull
    private final Set<FirProperty> visitedProperty;

    public CollectingVisitor(@NotNull ElementsToShortenCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        this.collector = collector2;
        this.visitedProperty = new LinkedHashSet();
    }

    @Override
    public void visitValueParameter(@NotNull FirValueParameter valueParameter2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
            super.visitValueParameter(valueParameter2);
            FirProperty firProperty = ClassMembersKt.getCorrespondingProperty(valueParameter2);
            if (firProperty == null) break block0;
            FirProperty it = firProperty;
            boolean bl = false;
            this.visitProperty(it);
        }
    }

    @Override
    public void visitProperty(@NotNull FirProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (this.visitedProperty.add(property)) {
            super.visitProperty(property);
        }
    }

    @Override
    public void visitScript(@NotNull FirScript script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Iterable $this$forEach$iv = script.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            it.accept(this);
        }
    }

    @Override
    public void visitElement(@NotNull FirElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        element2.acceptChildren(this);
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
            this.visitResolvedTypeRef(errorTypeRef);
            FirTypeRef firTypeRef = errorTypeRef.getPartiallyResolvedTypeRef();
            if (firTypeRef == null) break block0;
            firTypeRef.accept(this);
        }
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
            this.collector.processTypeRef(resolvedTypeRef);
            resolvedTypeRef.acceptChildren(this);
            FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
            if (firTypeRef == null) break block0;
            firTypeRef.accept(this);
        }
    }

    @Override
    public void visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier) {
        Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
        super.visitResolvedQualifier(resolvedQualifier);
        this.collector.processTypeQualifier(resolvedQualifier);
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier) {
        Intrinsics.checkNotNullParameter((Object)errorResolvedQualifier, (String)"errorResolvedQualifier");
        super.visitErrorResolvedQualifier(errorResolvedQualifier);
        this.collector.processTypeQualifier(errorResolvedQualifier);
    }

    @Override
    public void visitFunctionCall(@NotNull FirFunctionCall functionCall) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        super.visitFunctionCall(functionCall);
        this.collector.processFunctionCall(functionCall);
    }

    @Override
    public void visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
        super.visitPropertyAccessExpression(propertyAccessExpression);
        this.collector.processPropertyAccess(propertyAccessExpression);
    }

    @Override
    public void visitThisReference(@NotNull FirThisReference thisReference) {
        Intrinsics.checkNotNullParameter((Object)thisReference, (String)"thisReference");
        super.visitThisReference(thisReference);
        this.collector.processThisReference(thisReference);
    }
}

