/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ArrayValue;
import org.jetbrains.kotlin.constant.BooleanValue;
import org.jetbrains.kotlin.constant.ByteValue;
import org.jetbrains.kotlin.constant.CharValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.DoubleValue;
import org.jetbrains.kotlin.constant.EnumValue;
import org.jetbrains.kotlin.constant.FloatValue;
import org.jetbrains.kotlin.constant.IntValue;
import org.jetbrains.kotlin.constant.LongValue;
import org.jetbrains.kotlin.constant.NullValue;
import org.jetbrains.kotlin.constant.ShortValue;
import org.jetbrains.kotlin.constant.StringValue;
import org.jetbrains.kotlin.constant.UByteValue;
import org.jetbrains.kotlin.constant.UIntValue;
import org.jetbrains.kotlin.constant.ULongValue;
import org.jetbrains.kotlin.constant.UShortValue;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEnumEntryDeserializedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirArrayOfCallTransformer;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.serialization.constant.ConstantValueUtilsKt;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformer;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerData;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0003H\u0016J*\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010(\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010)\u001a\u00020*2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001a\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002*\u00020/2\u0006\u0010\b\u001a\u00020\u0003H\u0002\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformerData;", "()V", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "data", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "visitArrayLiteral", "arrayLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntryDeserializedAccessExpression", "enumEntryDeserializedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirEnumEntryDeserializedAccessExpression;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitLiteralExpression", "T", "literalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "visitWrappedArgumentExpression", "wrappedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWrappedArgumentExpression;", "toConstantValue", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nFirToConstantValueTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,319:1\n1547#2:320\n1618#2,3:321\n1745#2,3:324\n1601#2,9:327\n1853#2:336\n1854#2:338\n1610#2:339\n1601#2,9:348\n1853#2:357\n1854#2:359\n1610#2:360\n1#3:337\n1#3:358\n47#4:340\n17#4,2:341\n57#5,4:343\n43#5:347\n*S KotlinDebug\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer\n*L\n91#1:320\n91#1:321,3\n92#1:324,3\n100#1:327,9\n100#1:336\n100#1:338\n100#1:339\n230#1:348,9\n230#1:357\n230#1:359\n230#1:360\n100#1:337\n230#1:358\n139#1:340\n143#1:341,2\n155#1:343,4\n227#1:347\n*E\n"})
public final class FirToConstantValueTransformer
extends FirDefaultVisitor<ConstantValue<?>, FirToConstantValueTransformerData> {
    @NotNull
    public static final FirToConstantValueTransformer INSTANCE = new FirToConstantValueTransformer();

    private FirToConstantValueTransformer() {
    }

    private final ConstantValue<?> toConstantValue(FirExpression $this$toConstantValue, FirToConstantValueTransformerData data2) {
        Object object = data2.getConstValueProvider();
        if (object == null || (object = ((ConstValueProvider)object).findConstantValueFor($this$toConstantValue)) == null) {
            object = (ConstantValue)$this$toConstantValue.accept(this, data2);
        }
        return object;
    }

    @Override
    @Nullable
    public ConstantValue<?> visitElement(@NotNull FirElement element2, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        throw new IllegalStateException(("Illegal element as annotation argument: " + Reflection.getOrCreateKotlinClass(element2.getClass()).getQualifiedName() + " -> " + UtilsKt.render(element2)).toString());
    }

    @Override
    @Nullable
    public <T> ConstantValue<?> visitLiteralExpression(@NotNull FirLiteralExpression<T> literalExpression, @NotNull FirToConstantValueTransformerData data2) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter(literalExpression, (String)"literalExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        T value2 = literalExpression.getValue();
        ConstantValueKind<T> constantValueKind = literalExpression.getKind();
        if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            constantValue = new BooleanValue((Boolean)value2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Char");
            constantValue = new CharValue(((Character)value2).charValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ByteValue(((Number)value2).byteValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UByteValue(((Number)value2).byteValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ShortValue(((Number)value2).shortValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UShortValue(((Number)value2).shortValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new IntValue(((Number)value2).intValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UIntValue(((Number)value2).intValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new LongValue(((Number)value2).longValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ULongValue(((Number)value2).longValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.String");
            constantValue = new StringValue((String)value2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new FloatValue(((Number)value2).floatValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new DoubleValue(((Number)value2).doubleValue());
        } else {
            constantValue = Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Null.INSTANCE) ? (ConstantValue)NullValue.INSTANCE : null;
        }
        return constantValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ConstantValue<?> visitStringConcatenationCall(@NotNull FirStringConcatenationCall stringConcatenationCall, @NotNull FirToConstantValueTransformerData data2) {
        boolean bl;
        List strings2;
        block5: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)stringConcatenationCall, (String)"stringConcatenationCall");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Iterable $this$map$iv = stringConcatenationCall.getArgumentList().getArguments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirExpression firExpression2 = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(INSTANCE.toConstantValue((FirExpression)it, data2));
            }
            strings2 = (List)destination$iv$iv;
            Iterable $this$any$iv = strings2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConstantValue it = (ConstantValue)element$iv;
                    boolean bl3 = false;
                    if (!(it == null || !(it instanceof StringValue))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return new StringValue(CollectionsKt.joinToString$default((Iterable)strings2, (CharSequence)"", null, null, (int)0, null, (Function1)visitStringConcatenationCall.2.INSTANCE, (int)30, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstantValue<?> visitArrayLiteral(@NotNull FirArrayLiteral arrayLiteral, @NotNull FirToConstantValueTransformerData data2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)arrayLiteral, (String)"arrayLiteral");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Iterable $this$mapNotNull$iv = arrayLiteral.getArgumentList().getArguments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.toConstantValue(it, data2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return new ArrayValue(list2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitAnnotation(@NotNull FirAnnotation annotation2, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        FirReference firReference = ReferenceUtilsKt.toReference(annotation2, data2.getSession());
        Map<Name, ConstantValue<Object>> mapping2 = ConstantValueUtilsKt.addEmptyVarargValuesFor(ConstantValueUtilsKt.convertToConstantValues(annotation2.getArgumentMapping().getMapping(), data2.getSession(), data2.getConstValueProvider()), firReference != null ? FirReferenceUtilsKt.toResolvedFunctionSymbol$default(firReference, false, 1, null) : null);
        return AnnotationValue.Companion.create(FirTypeUtilsKt.getConeType(annotation2.getAnnotationTypeRef()), mapping2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitAnnotation((FirAnnotation)annotationCall, data2);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitGetClassCall(@NotNull FirGetClassCall getClassCall, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return ConstantValueUtilsKt.create(FirTypeUtilsKt.getResolvedType(getClassCall.getArgument()));
    }

    @Override
    @Nullable
    public ConstantValue<?> visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull FirToConstantValueTransformerData data2) {
        ConstantValue<Object> constantValue;
        block43: {
            block46: {
                FirCallableSymbol<?> symbol2;
                block45: {
                    Modality modality$iv;
                    FirCallableDeclaration fir;
                    block44: {
                        block42: {
                            Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
                            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(qualifiedAccessExpression);
                            if (firCallableSymbol == null) {
                                return null;
                            }
                            symbol2 = firCallableSymbol;
                            fir = (FirCallableDeclaration)symbol2.getFir();
                            if (!(symbol2.getFir() instanceof FirEnumEntry)) break block42;
                            ClassId classId = symbol2.getCallableId().getClassId();
                            if (classId == null) {
                                return null;
                            }
                            ClassId classId2 = classId;
                            Object e = symbol2.getFir();
                            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirEnumEntry");
                            constantValue = new EnumValue(classId2, ((FirEnumEntry)e).getName());
                            break block43;
                        }
                        if (!(symbol2 instanceof FirPropertySymbol)) break block44;
                        FirMemberDeclaration $this$isConst$iv = (FirMemberDeclaration)((FirPropertySymbol)symbol2).getFir();
                        boolean $i$f$isConst = false;
                        if ($this$isConst$iv.getStatus().isConst()) {
                            FirExpression firExpression2 = ((FirProperty)((FirPropertySymbol)symbol2).getFir()).getInitializer();
                            constantValue = firExpression2 != null ? this.toConstantValue(firExpression2, data2) : null;
                        } else {
                            constantValue = null;
                        }
                        break block43;
                    }
                    if (!(fir instanceof FirField)) break block45;
                    FirMemberDeclaration $this$isFinal$iv = fir;
                    boolean $i$f$isFinal = false;
                    Modality modality = $this$isFinal$iv.getStatus().getModality();
                    if (modality == null ? true : (modality$iv = modality) == Modality.FINAL) {
                        FirExpression firExpression3 = ((FirField)fir).getInitializer();
                        constantValue = firExpression3 != null ? this.toConstantValue(firExpression3, data2) : null;
                    } else {
                        constantValue = null;
                    }
                    break block43;
                }
                if (symbol2 instanceof FirConstructorSymbol) {
                    Map<Name, ConstantValue<Object>> map;
                    Map<Name, ConstantValue<Object>> map2;
                    FirFunctionCall constructorCall = (FirFunctionCall)qualifiedAccessExpression;
                    Object object = ClassMembersKt.containingClassLookupTag(symbol2);
                    if (object == null || (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, data2.getSession())) == null) {
                        return null;
                    }
                    Object constructedClassSymbol = object;
                    if (((FirClassSymbol)constructedClassSymbol).getClassKind() != ClassKind.ANNOTATION_CLASS) {
                        return null;
                    }
                    FirCall $this$resolvedArgumentMapping$iv = constructorCall;
                    boolean $i$f$getResolvedArgumentMapping = false;
                    FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
                    LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
                    if (linkedHashMap == null || (map2 = ConstantValueUtilsKt.convertToConstantValues(linkedHashMap, data2.getSession(), data2.getConstValueProvider())) == null || (map = ConstantValueUtilsKt.addEmptyVarargValuesFor(map2, (FirFunctionSymbol)symbol2)) == null) {
                        return null;
                    }
                    Map<Name, ConstantValue<Object>> mapping2 = map;
                    return AnnotationValue.Companion.create(FirTypeUtilsKt.getResolvedType(qualifiedAccessExpression), mapping2);
                }
                if (!Intrinsics.areEqual((Object)symbol2.getCallableId().getPackageName().asString(), (Object)"kotlin")) break block46;
                String string2 = symbol2.getCallableId().getCallableName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                String callableName = string2;
                if (!FirToConstantValueTransformerKt.access$getConstantIntrinsicCalls$p().contains(callableName)) {
                    return null;
                }
                FirExpression dispatchReceiver = qualifiedAccessExpression.getDispatchReceiver();
                Object object = dispatchReceiver;
                if (object == null || (object = this.toConstantValue((FirExpression)object, data2)) == null) {
                    return null;
                }
                Object dispatchReceiverValue2 = object;
                switch (callableName) {
                    case "toByte": {
                        Object t = ((ConstantValue)dispatchReceiverValue2).getValue();
                        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new ByteValue(((Number)t).byteValue());
                        break;
                    }
                    case "toLong": {
                        Object t = ((ConstantValue)dispatchReceiverValue2).getValue();
                        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new LongValue(((Number)t).longValue());
                        break;
                    }
                    case "toShort": {
                        Object t = ((ConstantValue)dispatchReceiverValue2).getValue();
                        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new ShortValue(((Number)t).shortValue());
                        break;
                    }
                    case "toFloat": {
                        Object t = ((ConstantValue)dispatchReceiverValue2).getValue();
                        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new FloatValue(((Number)t).floatValue());
                        break;
                    }
                    case "toDouble": {
                        Object t = ((ConstantValue)dispatchReceiverValue2).getValue();
                        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new DoubleValue(((Number)t).doubleValue());
                        break;
                    }
                    case "toChar": {
                        Object t = ((ConstantValue)dispatchReceiverValue2).getValue();
                        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new CharValue((char)((Number)t).intValue());
                        break;
                    }
                    case "unaryMinus": {
                        Object object2 = dispatchReceiverValue2;
                        if (object2 instanceof ByteValue) {
                            constantValue = new ByteValue(-((Number)((ByteValue)dispatchReceiverValue2).getValue()).byteValue());
                            break;
                        }
                        if (object2 instanceof LongValue) {
                            constantValue = new LongValue(-((Number)((LongValue)dispatchReceiverValue2).getValue()).longValue());
                            break;
                        }
                        if (object2 instanceof ShortValue) {
                            constantValue = new ShortValue(-((Number)((ShortValue)dispatchReceiverValue2).getValue()).shortValue());
                            break;
                        }
                        if (object2 instanceof FloatValue) {
                            constantValue = new FloatValue(-((Number)((FloatValue)dispatchReceiverValue2).getValue()).floatValue());
                            break;
                        }
                        if (object2 instanceof DoubleValue) {
                            constantValue = new DoubleValue(-((Number)((DoubleValue)dispatchReceiverValue2).getValue()).doubleValue());
                            break;
                        }
                        constantValue = null;
                        break;
                    }
                    default: {
                        constantValue = null;
                        break;
                    }
                }
                break block43;
            }
            constantValue = null;
        }
        return constantValue;
    }

    @Override
    @Nullable
    public ConstantValue<?> visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)propertyAccessExpression, data2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitEnumEntryDeserializedAccessExpression(@NotNull FirEnumEntryDeserializedAccessExpression enumEntryDeserializedAccessExpression, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)enumEntryDeserializedAccessExpression, (String)"enumEntryDeserializedAccessExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        FirEnumEntryDeserializedAccessExpression element2 = enumEntryDeserializedAccessExpression;
        return new EnumValue(element2.getEnumClassId(), element2.getEnumEntryName());
    }

    @Override
    @Nullable
    public ConstantValue<?> visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (FirArrayOfCallTransformer.Companion.isArrayOfCall(functionCall, data2.getSession())) {
            return (ConstantValue)new FirArrayOfCallTransformer().transformFunctionCall(functionCall, data2.getSession()).accept(this, data2);
        }
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)functionCall, data2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstantValue<?> visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @NotNull FirToConstantValueTransformerData data2) {
        void $this$mapNotNullTo$iv$iv;
        List<FirExpression> list2;
        block4: {
            List<FirExpression> it;
            block3: {
                Intrinsics.checkNotNullParameter((Object)varargArgumentsExpression, (String)"varargArgumentsExpression");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                it = varargArgumentsExpression.getArguments();
                boolean bl = false;
                FirExpression firExpression2 = (FirExpression)CollectionsKt.singleOrNull(it);
                FirExpression firExpression3 = firExpression2 != null ? FirExpressionUtilKt.unwrapArgument(firExpression2) : null;
                list2 = firExpression3 instanceof FirArrayLiteral ? (FirArrayLiteral)firExpression3 : null;
                if (list2 == null) break block3;
                FirCall $this$arguments$iv = (FirCall)((Object)list2);
                boolean $i$f$getArguments = false;
                list2 = $this$arguments$iv.getArgumentList().getArguments();
                if (list2 != null) break block4;
            }
            list2 = it;
        }
        List<FirExpression> arguments2 = list2;
        Iterable $this$mapNotNull$iv = arguments2;
        boolean $i$f$mapNotNull = false;
        Iterable bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl3 = false;
            if (INSTANCE.toConstantValue(it, data2) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        return new ArrayValue(list3);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitWrappedArgumentExpression(@NotNull FirWrappedArgumentExpression wrappedArgumentExpression, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)wrappedArgumentExpression, (String)"wrappedArgumentExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.toConstantValue(wrappedArgumentExpression.getExpression(), data2);
    }
}

