/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirClassReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirFromMissingDependenciesNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.UseSiteTargetsList;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a8\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a.\u0010\u0003\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0014*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0006*\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012*\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010\n*\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0018\u0010\u001f\u001a\u0004\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0012\u0010!\u001a\u00020\"*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"defaultAnnotationTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "checkRepeatedAnnotation", "", "useSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "existingTargetsForAnnotation", "", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "annotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "annotations", "", "extractClassFromArgument", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "extractClassesFromArgument", "getAllowedAnnotationTargets", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getAnnotationClassForOptInMarker", "getDefaultUseSiteTarget", "getImplicitUseSiteTargetList", "getTargetAnnotation", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isRepeatable", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirAnnotationHelpersKt\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 6 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,172:1\n22#2,4:173\n1609#3:177\n1853#3:178\n288#3,2:179\n1854#3:182\n1610#3:183\n1601#3,9:184\n1853#3:193\n1854#3:195\n1610#3:196\n1745#3,3:197\n288#3,2:200\n1#4:181\n1#4:194\n93#5,3:202\n98#5:206\n93#6:205\n372#7,7:207\n*S KotlinDebug\n*F\n+ 1 FirAnnotationHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirAnnotationHelpersKt\n*L\n46#1:173,4\n63#1:177\n63#1:178\n72#1:179,2\n63#1:182\n63#1:183\n85#1:184,9\n85#1:193\n85#1:195\n85#1:196\n112#1:197,3\n130#1:200,2\n63#1:181\n85#1:194\n138#1:202,3\n138#1:206\n138#1:205\n165#1:207,7\n*E\n"})
public final class FirAnnotationHelpersKt {
    @NotNull
    private static final Set<KotlinTarget> defaultAnnotationTargets = KotlinTarget.Companion.getDEFAULT_TARGET_SET();

    @NotNull
    public static final Set<KotlinTarget> getAllowedAnnotationTargets(@NotNull FirAnnotation $this$getAllowedAnnotationTargets, @NotNull FirSession session2) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter((Object)$this$getAllowedAnnotationTargets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if ($this$getAllowedAnnotationTargets.getAnnotationTypeRef() instanceof FirErrorTypeRef) {
            return KotlinTarget.Companion.getALL_TARGET_SET();
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType($this$getAllowedAnnotationTargets.getAnnotationTypeRef());
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null || (coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType, session2, null, 2, null)) == null || (coneClassLikeLookupTag = ((ConeClassLikeType)coneKotlinType).getLookupTag()) == null || (firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, session2)) == null) {
            return defaultAnnotationTargets;
        }
        FirClassLikeSymbol<?> annotationClassSymbol = firClassLikeSymbol;
        FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)annotationClassSymbol, FirResolvePhase.BODY_RESOLVE);
        return FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotationClassSymbol, session2);
    }

    @Nullable
    public static final FirRegularClassSymbol getAnnotationClassForOptInMarker(@NotNull FirAnnotation $this$getAnnotationClassForOptInMarker, @NotNull FirSession session2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getAnnotationClassForOptInMarker, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirTypeRef $this$coneTypeSafe$iv = $this$getAnnotationClassForOptInMarker.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return null;
        }
        Object lookupTag2 = object;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)lookupTag2, session2);
        FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
        if (firRegularClassSymbol == null) {
            return null;
        }
        FirRegularClassSymbol annotationClassSymbol = firRegularClassSymbol;
        if (FirAnnotationUtilsKt.getAnnotationByClassId(annotationClassSymbol, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), session2) == null) {
            return null;
        }
        return annotationClassSymbol;
    }

    @NotNull
    public static final Set<KotlinTarget> getAllowedAnnotationTargets(@NotNull FirRegularClass $this$getAllowedAnnotationTargets, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllowedAnnotationTargets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirAnnotationHelpersKt.getAllowedAnnotationTargets($this$getAllowedAnnotationTargets.getSymbol(), session2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<KotlinTarget> getAllowedAnnotationTargets(@NotNull FirClassLikeSymbol<?> $this$getAllowedAnnotationTargets, @NotNull FirSession session2) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter($this$getAllowedAnnotationTargets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)$this$getAllowedAnnotationTargets, FirResolvePhase.ANNOTATION_ARGUMENTS);
        FirAnnotation firAnnotation = FirAnnotationHelpersKt.getTargetAnnotation($this$getAllowedAnnotationTargets, session2);
        if (firAnnotation == null) {
            return defaultAnnotationTargets;
        }
        FirAnnotation targetAnnotation = firAnnotation;
        FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName(targetAnnotation, StandardClassIds.Annotations.ParameterNames.INSTANCE.getTargetAllowedTargets());
        List list2 = firExpression2 != null ? FirExpressionUtilKt.unwrapAndFlattenArgument(firExpression2, true) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List arguments2 = list2;
        Iterable iterable = arguments2;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinTarget kotlinTarget;
            Object object;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression argument2 = (FirExpression)element$iv;
            boolean bl2 = false;
            FirReference calleeReference = ReferenceUtilsKt.toReference(argument2, session2);
            Object object2 = calleeReference;
            if ((object2 == null || (object2 = FirReferenceUtilsKt.getResolved((FirReference)object2)) == null || (object2 = ((FirResolvedNamedReference)object2).getName()) == null || (object2 = ((Name)object2).asString()) == null) && ((object = calleeReference instanceof FirFromMissingDependenciesNamedReference ? (FirFromMissingDependenciesNamedReference)calleeReference : null) != null && (object = ((FirFromMissingDependenciesNamedReference)object).getName()) != null ? ((Name)object).asString() : (object2 = null)) == null) {
                kotlinTarget = null;
            } else {
                Object v6;
                block6: {
                    Object object3 = object2;
                    Intrinsics.checkNotNull((Object)object3);
                    Object targetName = object3;
                    Iterable $this$firstOrNull$iv = (Iterable)KotlinTarget.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        KotlinTarget target = (KotlinTarget)((Object)element$iv2);
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)target.name(), (Object)targetName)) continue;
                        v6 = element$iv2;
                        break block6;
                    }
                    v6 = null;
                }
                kotlinTarget = v6;
            }
            if (kotlinTarget == null) continue;
            KotlinTarget it$iv = kotlinTarget;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    @Nullable
    public static final FirAnnotation getTargetAnnotation(@NotNull FirDeclaration $this$getTargetAnnotation, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirAnnotationUtilsKt.getAnnotationByClassId($this$getTargetAnnotation, StandardClassIds.Annotations.INSTANCE.getTarget(), session2);
    }

    @Nullable
    public static final FirAnnotation getTargetAnnotation(@NotNull FirClassLikeSymbol<?> $this$getTargetAnnotation, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$getTargetAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)$this$getTargetAnnotation, StandardClassIds.Annotations.INSTANCE.getTarget(), session2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirRegularClassSymbol> extractClassesFromArgument(@NotNull FirExpression $this$extractClassesFromArgument, @NotNull FirSession session2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$extractClassesFromArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Iterable $this$mapNotNull$iv = FirExpressionUtilKt.unwrapAndFlattenArgument($this$extractClassesFromArgument, true);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirRegularClassSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if (FirAnnotationHelpersKt.extractClassFromArgument(it, session2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final FirRegularClassSymbol extractClassFromArgument(@NotNull FirExpression $this$extractClassFromArgument, @NotNull FirSession session2) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$extractClassFromArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!($this$extractClassFromArgument instanceof FirGetClassCall)) {
            return null;
        }
        FirExpression argument2 = ((FirGetClassCall)$this$extractClassFromArgument).getArgument();
        if (argument2 instanceof FirResolvedQualifier) {
            FirClassLikeSymbol<?> firClassLikeSymbol = ((FirResolvedQualifier)argument2).getSymbol();
            firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
        } else if (argument2 instanceof FirClassReferenceExpression) {
            FirTypeRef classTypeRef = ((FirClassReferenceExpression)argument2).getClassTypeRef();
            ConeKotlinType coneType = ConeTypesKt.unwrapFlexibleAndDefinitelyNotNull(FirTypeUtilsKt.getConeType(classTypeRef));
            firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(TypeExpansionUtilsKt.fullyExpandedType(coneType, session2), session2);
        } else {
            firRegularClassSymbol = null;
        }
        return firRegularClassSymbol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void checkRepeatedAnnotation(@Nullable AnnotationUseSiteTarget useSiteTarget2, @NotNull List<AnnotationUseSiteTarget> existingTargetsForAnnotation, @NotNull FirAnnotation annotation2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(existingTargetsForAnnotation, (String)"existingTargetsForAnnotation");
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!existingTargetsForAnnotation.contains((Object)useSiteTarget2)) {
            AnnotationUseSiteTarget it;
            Iterable $this$any$iv = existingTargetsForAnnotation;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return;
                Object element$iv = iterator2.next();
                it = (AnnotationUseSiteTarget)((Object)element$iv);
                boolean bl = false;
            } while (!(it == null != (useSiteTarget2 == null)));
            boolean bl = true;
            if (!bl) return;
        }
        boolean bl = true;
        boolean duplicated = bl;
        if (!duplicated) return;
        if (FirAnnotationHelpersKt.isRepeatable(annotation2, context2.getSession())) return;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getREPEATED_ANNOTATION(), (DiagnosticContext)context2, null, 8, null);
    }

    public static final boolean isRepeatable(@NotNull FirAnnotation $this$isRepeatable, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isRepeatable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ClassId classId = FirAnnotationUtilsKt.toAnnotationClassId($this$isRepeatable, session2);
        if (classId == null) {
            return false;
        }
        ClassId annotationClassId = classId;
        if (annotationClassId.isLocal()) {
            return false;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(session2).getClassLikeSymbolByClassId(annotationClassId);
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> annotationClass2 = firClassLikeSymbol;
        return FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(session2).symbolContainsRepeatableAnnotation(annotationClass2, session2);
    }

    @Nullable
    public static final AnnotationUseSiteTarget getDefaultUseSiteTarget(@NotNull FirAnnotationContainer $this$getDefaultUseSiteTarget, @NotNull FirAnnotation annotation2, @NotNull CheckerContext context2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getDefaultUseSiteTarget, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Iterable $this$firstOrNull$iv = FirAnnotationHelpersKt.getImplicitUseSiteTargetList($this$getDefaultUseSiteTarget, context2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationUseSiteTarget it = (AnnotationUseSiteTarget)((Object)element$iv);
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context2.getSession()), (Object)((Object)KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)it)))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final List<AnnotationUseSiteTarget> getImplicitUseSiteTargetList(@NotNull FirAnnotationContainer $this$getImplicitUseSiteTargetList, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getImplicitUseSiteTargetList, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirAnnotationContainer firAnnotationContainer = $this$getImplicitUseSiteTargetList;
        if (firAnnotationContainer instanceof FirValueParameter) {
            FirElement firElement;
            block4: {
                CheckerContext $this$findClosest_u24default$iv = context2;
                boolean $i$f$findClosest = false;
                for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                    FirElement firElement2;
                    FirDeclaration firDeclaration = it$iv;
                    if (!(firDeclaration instanceof FirDeclaration)) {
                        firDeclaration = null;
                    }
                    if ((firElement = (FirElement)firDeclaration) == null) continue;
                    FirElement firElement3 = firElement2 = firElement;
                    boolean bl = false;
                    FirElement it = firElement3;
                    firElement = true ? firElement2 : null;
                    if (firElement == null) {
                        continue;
                    }
                    break block4;
                }
                firElement = null;
            }
            return firElement instanceof FirPrimaryConstructor ? UseSiteTargetsList.INSTANCE.getT_CONSTRUCTOR_PARAMETER() : CollectionsKt.emptyList();
        }
        return firAnnotationContainer instanceof FirProperty ? (!((FirProperty)$this$getImplicitUseSiteTargetList).isLocal() ? UseSiteTargetsList.INSTANCE.getT_PROPERTY() : CollectionsKt.emptyList()) : (firAnnotationContainer instanceof FirPropertyAccessor ? (((FirPropertyAccessor)$this$getImplicitUseSiteTargetList).isGetter() ? CollectionsKt.listOf((Object)((Object)AnnotationUseSiteTarget.PROPERTY_GETTER)) : CollectionsKt.listOf((Object)((Object)AnnotationUseSiteTarget.PROPERTY_SETTER))) : CollectionsKt.emptyList());
    }

    public static final void checkRepeatedAnnotation(@Nullable FirAnnotationContainer annotationContainer, @NotNull List<? extends FirAnnotation> annotations2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (annotations2.size() <= 1) {
            return;
        }
        HashMap annotationsMap = new HashMap();
        for (FirAnnotation firAnnotation : annotations2) {
            Object object;
            AnnotationUseSiteTarget annotationUseSiteTarget = firAnnotation.getUseSiteTarget();
            if (annotationUseSiteTarget == null) {
                FirAnnotationContainer firAnnotationContainer = annotationContainer;
                annotationUseSiteTarget = firAnnotationContainer != null ? FirAnnotationHelpersKt.getDefaultUseSiteTarget(firAnnotationContainer, firAnnotation, context2) : null;
            }
            AnnotationUseSiteTarget useSiteTarget2 = annotationUseSiteTarget;
            ConeKotlinType expandedType2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(firAnnotation.getAnnotationTypeRef()), context2.getSession());
            Map $this$getOrPut$iv = annotationsMap;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(expandedType2);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(expandedType2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List existingTargetsForAnnotation = (List)object;
            FirAnnotationHelpersKt.checkRepeatedAnnotation(useSiteTarget2, existingTargetsForAnnotation, firAnnotation, context2, reporter);
            existingTargetsForAnnotation.add(useSiteTarget2);
        }
    }
}

