/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols.pointers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.symbols.pointers.FirCallableSignatureKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B?\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u000e\u001a\u00020\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0011J\b\u0010\u0012\u001a\u00020\bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/FirCallableSignature;", "", "receiverType", "", "contextReceiverTypes", "", "parameters", "typeParametersCount", "", "returnType", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;ILjava/lang/String;)V", "equals", "", "other", "hasTheSameSignature", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "hashCode", "Companion", "analysis-api-fir"})
public final class FirCallableSignature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String receiverType;
    @NotNull
    private final List<String> contextReceiverTypes;
    @Nullable
    private final List<String> parameters;
    private final int typeParametersCount;
    @NotNull
    private final String returnType;

    private FirCallableSignature(String receiverType2, List<String> contextReceiverTypes, List<String> parameters2, int typeParametersCount2, String returnType2) {
        this.receiverType = receiverType2;
        this.contextReceiverTypes = contextReceiverTypes;
        this.parameters = parameters2;
        this.typeParametersCount = typeParametersCount2;
        this.returnType = returnType2;
    }

    public final boolean hasTheSameSignature(@NotNull FirCallableSymbol<?> declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        return this.hasTheSameSignature((FirCallableDeclaration)declaration2.getFir());
    }

    public final boolean hasTheSameSignature(@NotNull FirCallableDeclaration declaration2) {
        Object parameter2;
        int index2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (this.receiverType == null != (declaration2.getReceiverParameter() == null)) {
            return false;
        }
        if (this.contextReceiverTypes.size() != declaration2.getContextReceivers().size()) {
            return false;
        }
        if (this.typeParametersCount != declaration2.getTypeParameters().size()) {
            return false;
        }
        List<String> list2 = this.parameters;
        if (!Intrinsics.areEqual((Object)(list2 != null ? Integer.valueOf(list2.size()) : null), (object = declaration2 instanceof FirFunction ? (FirFunction)declaration2 : null) != null && (object = ((FirFunction)object).getValueParameters()) != null ? Integer.valueOf(object.size()) : null)) {
            return false;
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(declaration2, FirResolvePhase.TYPES);
        FirPureAbstractElement firPureAbstractElement = declaration2.getReceiverParameter();
        if (!Intrinsics.areEqual((Object)this.receiverType, firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirCallableSignatureKt.renderType$default((FirTypeRef)firPureAbstractElement, null, 1, null) : null)) {
            return false;
        }
        List<FirContextReceiver> receivers = declaration2.getContextReceivers();
        Iterator iterator2 = ((Iterable)this.contextReceiverTypes).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            index2 = n++;
            parameter2 = (String)iterator2.next();
            if (Intrinsics.areEqual((Object)FirCallableSignatureKt.renderType$default(receivers.get(index2).getTypeRef(), null, 1, null), (Object)parameter2)) continue;
            return false;
        }
        if (declaration2 instanceof FirFunction) {
            if (this.parameters == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            iterator2 = ((Iterable)((FirFunction)declaration2).getValueParameters()).iterator();
            n = 0;
            while (iterator2.hasNext()) {
                index2 = n++;
                parameter2 = (FirValueParameter)iterator2.next();
                if (Intrinsics.areEqual((Object)this.parameters.get(index2), (Object)FirCallableSignatureKt.renderType$default(((FirValueParameter)parameter2).getReturnTypeRef(), null, 1, null))) continue;
                return false;
            }
        }
        return Intrinsics.areEqual((Object)this.returnType, (Object)FirCallableSignatureKt.renderType$default(declaration2.getSymbol().getResolvedReturnTypeRef(), null, 1, null));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FirCallableSignature)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.receiverType, (Object)((FirCallableSignature)other).receiverType)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.contextReceiverTypes, ((FirCallableSignature)other).contextReceiverTypes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.parameters, ((FirCallableSignature)other).parameters)) {
            return false;
        }
        if (this.typeParametersCount != ((FirCallableSignature)other).typeParametersCount) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.returnType, (Object)((FirCallableSignature)other).returnType);
    }

    public int hashCode() {
        String string2 = this.receiverType;
        int result2 = string2 != null ? string2.hashCode() : 0;
        result2 = 31 * result2 + ((Object)this.contextReceiverTypes).hashCode();
        List<String> list2 = this.parameters;
        result2 = 31 * result2 + (list2 != null ? ((Object)list2).hashCode() : 0);
        result2 = 31 * result2 + Integer.hashCode(this.typeParametersCount);
        result2 = 31 * result2 + this.returnType.hashCode();
        return result2;
    }

    public /* synthetic */ FirCallableSignature(String receiverType2, List contextReceiverTypes, List parameters2, int typeParametersCount2, String returnType2, DefaultConstructorMarker $constructor_marker) {
        this(receiverType2, contextReceiverTypes, parameters2, typeParametersCount2, returnType2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/FirCallableSignature$Companion;", "", "()V", "createSignature", "Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/FirCallableSignature;", "callableDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "callableSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "analysis-api-fir"})
    @SourceDebugExtension(value={"SMAP\nFirCallableSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCallableSignature.kt\norg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/FirCallableSignature$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1547#2:120\n1618#2,3:121\n1547#2:124\n1618#2,3:125\n*S KotlinDebug\n*F\n+ 1 FirCallableSignature.kt\norg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/FirCallableSignature$Companion\n*L\n85#1:120\n85#1:121,3\n87#1:124\n87#1:125,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirCallableSignature createSignature(@NotNull FirCallableSymbol<?> callableSymbol) {
            Intrinsics.checkNotNullParameter(callableSymbol, (String)"callableSymbol");
            return this.createSignature((FirCallableDeclaration)callableSymbol.getFir());
        }

        @NotNull
        public final FirCallableSignature createSignature(@NotNull FirCallableDeclaration callableDeclaration) {
            List list2;
            FirValueParameter it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)callableDeclaration, (String)"callableDeclaration");
            FirLazyDeclarationResolverKt.lazyResolveToPhase(callableDeclaration, FirResolvePhase.TYPES);
            Iterable iterable = callableDeclaration.getContextReceivers();
            FirPureAbstractElement firPureAbstractElement = callableDeclaration.getReceiverParameter();
            String string2 = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirCallableSignatureKt.renderType$default((FirTypeRef)firPureAbstractElement, null, 1, null) : null;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirContextReceiver firContextReceiver = (FirContextReceiver)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FirCallableSignatureKt.renderType$default(((FirContextReceiver)((Object)it)).getTypeRef(), null, 1, null));
            }
            Collection collection2 = (List)destination$iv$iv;
            String string3 = string2;
            if (callableDeclaration instanceof FirFunction) {
                Collection<String> collection3;
                $this$map$iv = ((FirFunction)callableDeclaration).getValueParameters();
                collection = collection2;
                string2 = string3;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (FirValueParameter)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl = false;
                    collection3.add(FirCallableSignatureKt.renderType$default(it.getReturnTypeRef(), null, 1, null));
                }
                collection3 = (List)destination$iv$iv;
                string3 = string2;
                collection2 = collection;
                list2 = collection3;
            } else {
                list2 = null;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            String string4 = FirCallableSignatureKt.renderType$default(callableDeclaration.getSymbol().getResolvedReturnTypeRef(), null, 1, null);
            int n = callableDeclaration.getTypeParameters().size();
            List list3 = list2;
            List list4 = collection2;
            String string5 = string3;
            return new FirCallableSignature(string5, list4, list3, n, string4, defaultConstructorMarker);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

