/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javaslang.Kind1;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.collection.Collections;
import javaslang.collection.Comparators;
import javaslang.collection.Iterator;
import javaslang.collection.Map;
import javaslang.collection.RedBlackTree;
import javaslang.collection.Set;
import javaslang.collection.SortedSet;
import javaslang.control.Option;

public final class TreeSet<T>
implements Kind1<TreeSet<?>, T>,
SortedSet<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final RedBlackTree<T> tree;

    TreeSet(RedBlackTree<T> tree) {
        this.tree = tree;
    }

    public static <T extends Comparable<? super T>> Collector<T, ArrayList<T>, TreeSet<T>> collector() {
        return TreeSet.collector(Comparators.naturalComparator());
    }

    public static <T> Collector<T, ArrayList<T>, TreeSet<T>> collector(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, TreeSet> finisher = list2 -> TreeSet.ofAll(comparator, list2);
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T extends Comparable<? super T>> TreeSet<T> empty() {
        return new TreeSet(RedBlackTree.empty());
    }

    public static <T> TreeSet<T> empty(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return new TreeSet<T>(RedBlackTree.empty(comparator));
    }

    public static <T> TreeSet<T> narrow(TreeSet<? extends T> treeSet) {
        return treeSet;
    }

    public static <T extends Comparable<? super T>> TreeSet<T> of(T value2) {
        return new TreeSet<T>(RedBlackTree.of(value2));
    }

    public static <T> TreeSet<T> of(Comparator<? super T> comparator, T value2) {
        Objects.requireNonNull(comparator, "comparator is null");
        return new TreeSet<T>(RedBlackTree.of(comparator, value2));
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> TreeSet<T> of(T ... values2) {
        Objects.requireNonNull(values2, "values is null");
        return new TreeSet<T[]>(RedBlackTree.of(values2));
    }

    @SafeVarargs
    public static <T> TreeSet<T> of(Comparator<? super T> comparator, T ... values2) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(values2, "values is null");
        return new TreeSet<T>(RedBlackTree.of(comparator, values2));
    }

    public static <T> TreeSet<T> tabulate(Comparator<? super T> comparator, int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(f, "f is null");
        return Collections.tabulate(n, f, TreeSet.empty(comparator), values2 -> TreeSet.of(comparator, values2));
    }

    public static <T extends Comparable<? super T>> TreeSet<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return TreeSet.tabulate(Comparators.naturalComparator(), n, f);
    }

    public static <T> TreeSet<T> fill(Comparator<? super T> comparator, int n, Supplier<? extends T> s) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(s, "s is null");
        return Collections.fill(n, s, TreeSet.empty(comparator), values2 -> TreeSet.of(comparator, values2));
    }

    public static <T extends Comparable<? super T>> TreeSet<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return TreeSet.fill(Comparators.naturalComparator(), n, s);
    }

    public static <T extends Comparable<? super T>> TreeSet<T> ofAll(Iterable<? extends T> values2) {
        Objects.requireNonNull(values2, "values is null");
        return values2.iterator().hasNext() ? new TreeSet<T>(RedBlackTree.ofAll(values2)) : TreeSet.empty();
    }

    public static <T> TreeSet<T> ofAll(Comparator<? super T> comparator, Iterable<? extends T> values2) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(values2, "values is null");
        return values2.iterator().hasNext() ? new TreeSet<T>(RedBlackTree.ofAll(comparator, values2)) : TreeSet.empty();
    }

    public static TreeSet<Boolean> ofAll(boolean[] array) {
        Objects.requireNonNull(array, "array is null");
        return TreeSet.ofAll(Iterator.ofAll(array));
    }

    public static TreeSet<Byte> ofAll(byte[] array) {
        Objects.requireNonNull(array, "array is null");
        return TreeSet.ofAll(Iterator.ofAll(array));
    }

    public static TreeSet<Character> ofAll(char[] array) {
        Objects.requireNonNull(array, "array is null");
        return TreeSet.ofAll(Iterator.ofAll(array));
    }

    public static TreeSet<Double> ofAll(double[] array) {
        Objects.requireNonNull(array, "array is null");
        return TreeSet.ofAll(Iterator.ofAll(array));
    }

    public static TreeSet<Float> ofAll(float[] array) {
        Objects.requireNonNull(array, "array is null");
        return TreeSet.ofAll(Iterator.ofAll(array));
    }

    public static TreeSet<Integer> ofAll(int[] array) {
        Objects.requireNonNull(array, "array is null");
        return TreeSet.ofAll(Iterator.ofAll(array));
    }

    public static TreeSet<Long> ofAll(long[] array) {
        Objects.requireNonNull(array, "array is null");
        return TreeSet.ofAll(Iterator.ofAll(array));
    }

    public static TreeSet<Short> ofAll(short[] array) {
        Objects.requireNonNull(array, "array is null");
        return TreeSet.ofAll(Iterator.ofAll(array));
    }

    public static TreeSet<Integer> range(int from2, int toExclusive) {
        return TreeSet.ofAll(Iterator.range(from2, toExclusive));
    }

    public static TreeSet<Character> range(char from2, char toExclusive) {
        return TreeSet.ofAll(Iterator.range(from2, toExclusive));
    }

    public static TreeSet<Integer> rangeBy(int from2, int toExclusive, int step) {
        return TreeSet.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static TreeSet<Character> rangeBy(char from2, char toExclusive, int step) {
        return TreeSet.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static TreeSet<Double> rangeBy(double from2, double toExclusive, double step) {
        return TreeSet.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static TreeSet<Long> range(long from2, long toExclusive) {
        return TreeSet.ofAll(Iterator.range(from2, toExclusive));
    }

    public static TreeSet<Long> rangeBy(long from2, long toExclusive, long step) {
        return TreeSet.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static TreeSet<Integer> rangeClosed(int from2, int toInclusive) {
        return TreeSet.ofAll(Iterator.rangeClosed(from2, toInclusive));
    }

    public static TreeSet<Character> rangeClosed(char from2, char toInclusive) {
        return TreeSet.ofAll(Iterator.rangeClosed(from2, toInclusive));
    }

    public static TreeSet<Integer> rangeClosedBy(int from2, int toInclusive, int step) {
        return TreeSet.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    public static TreeSet<Character> rangeClosedBy(char from2, char toInclusive, int step) {
        return TreeSet.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    public static TreeSet<Double> rangeClosedBy(double from2, double toInclusive, double step) {
        return TreeSet.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    public static TreeSet<Long> rangeClosed(long from2, long toInclusive) {
        return TreeSet.ofAll(Iterator.rangeClosed(from2, toInclusive));
    }

    public static TreeSet<Long> rangeClosedBy(long from2, long toInclusive, long step) {
        return TreeSet.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    @Override
    public TreeSet<T> add(T element2) {
        return this.contains(element2) ? this : new TreeSet<T>(this.tree.insert(element2));
    }

    @Override
    public TreeSet<T> addAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        RedBlackTree<T> that = this.tree;
        for (T element2 : elements) {
            that = that.insert(element2);
        }
        if (this.tree == that) {
            return this;
        }
        return new TreeSet<T>(that);
    }

    @Override
    public Comparator<T> comparator() {
        return this.tree.comparator();
    }

    @Override
    public TreeSet<T> diff(Set<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof TreeSet) {
            RedBlackTree<T> that = ((TreeSet)elements).tree;
            return new TreeSet<T>(this.tree.difference(that));
        }
        return this.removeAll(elements);
    }

    @Override
    public boolean contains(T element2) {
        return this.tree.contains(element2);
    }

    @Override
    public TreeSet<T> distinct() {
        return this;
    }

    @Override
    public TreeSet<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return TreeSet.ofAll(this.tree.comparator(), this.iterator().distinctBy(comparator));
    }

    @Override
    public <U> TreeSet<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        return TreeSet.ofAll(this.tree.comparator(), this.iterator().distinctBy(keyExtractor));
    }

    @Override
    public TreeSet<T> drop(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= (long)this.length()) {
            return TreeSet.empty(this.tree.comparator());
        }
        return TreeSet.ofAll(this.tree.comparator(), this.iterator().drop(n));
    }

    @Override
    public TreeSet<T> dropRight(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= (long)this.length()) {
            return TreeSet.empty(this.tree.comparator());
        }
        return TreeSet.ofAll(this.tree.comparator(), this.iterator().dropRight(n));
    }

    @Override
    public TreeSet<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropWhile((Predicate)predicate.negate());
    }

    @Override
    public TreeSet<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        TreeSet<T> treeSet = TreeSet.ofAll(this.tree.comparator(), this.iterator().dropWhile(predicate));
        return treeSet.length() == this.length() ? this : treeSet;
    }

    @Override
    public TreeSet<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        TreeSet<T> treeSet = TreeSet.ofAll(this.tree.comparator(), this.iterator().filter(predicate));
        return treeSet.length() == this.length() ? this : treeSet;
    }

    @Override
    public <U> TreeSet<U> flatMap(Comparator<? super U> comparator, Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return TreeSet.ofAll(comparator, this.iterator().flatMap(mapper));
    }

    @Override
    public <U> TreeSet<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        return this.flatMap(Comparators.naturalComparator(), (Function)mapper);
    }

    @Override
    public <U> U foldRight(U zero, BiFunction<? super T, ? super U, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return this.iterator().foldRight(zero, f);
    }

    @Override
    public <C> Map<C, TreeSet<T>> groupBy(Function<? super T, ? extends C> classifier) {
        Objects.requireNonNull(classifier, "classifier is null");
        return this.iterator().groupBy(classifier).map((? super K key, ? super V iterator2) -> Tuple.of(key, TreeSet.ofAll(this.tree.comparator(), iterator2)));
    }

    @Override
    public Iterator<TreeSet<T>> grouped(long size) {
        return this.sliding(size, size);
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty TreeSet");
        }
        return this.tree.min().get();
    }

    @Override
    public Option<T> headOption() {
        return this.tree.min();
    }

    @Override
    public TreeSet<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty TreeSet");
        }
        return new TreeSet<T>(this.tree.delete(this.tree.max().get()));
    }

    @Override
    public Option<TreeSet<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    public TreeSet<T> intersect(Set<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof TreeSet) {
            RedBlackTree<T> that = ((TreeSet)elements).tree;
            return new TreeSet<T>(this.tree.intersection(that));
        }
        return this.retainAll(elements);
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.tree.iterator();
    }

    @Override
    public int length() {
        return this.tree.size();
    }

    @Override
    public <U> TreeSet<U> map(Comparator<? super U> comparator, Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return TreeSet.ofAll(comparator, this.iterator().map(mapper));
    }

    @Override
    public <U> TreeSet<U> map(Function<? super T, ? extends U> mapper) {
        return this.map(Comparators.naturalComparator(), (Function)mapper);
    }

    @Override
    public Option<T> max() {
        return this.tree.max();
    }

    @Override
    public Option<T> min() {
        return this.tree.min();
    }

    @Override
    public Tuple2<TreeSet<T>, TreeSet<T>> partition(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.iterator().partition(predicate).map((? super T1 i1) -> TreeSet.ofAll(this.tree.comparator(), i1), (? super T2 i2) -> TreeSet.ofAll(this.tree.comparator(), i2));
    }

    @Override
    public TreeSet<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.isEmpty()) {
            action.accept(this.head());
        }
        return this;
    }

    @Override
    public TreeSet<T> remove(T element2) {
        return new TreeSet<T>(this.tree.delete(element2));
    }

    @Override
    public TreeSet<T> removeAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty()) {
            return this;
        }
        RedBlackTree<T> that = this.tree;
        java.util.Iterator<T> iter2 = elements.iterator();
        while (!that.isEmpty() && iter2.hasNext()) {
            that = that.delete(iter2.next());
        }
        if (that == this.tree) {
            return this;
        }
        return new TreeSet<T>(that);
    }

    @Override
    public TreeSet<T> replace(T currentElement, T newElement) {
        if (this.tree.contains(currentElement)) {
            return new TreeSet<T>(this.tree.delete(currentElement).insert(newElement));
        }
        return this;
    }

    @Override
    public TreeSet<T> replaceAll(T currentElement, T newElement) {
        return this.replace((Object)currentElement, (Object)newElement);
    }

    @Override
    public TreeSet<T> retainAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty()) {
            return this;
        }
        RedBlackTree<? extends T> kept = RedBlackTree.ofAll(this.tree.comparator(), elements);
        RedBlackTree<T> newTree = this.tree.intersection(kept);
        return newTree.size() == this.tree.size() ? this : new TreeSet<T>(this.tree.intersection(kept));
    }

    /*
     * Exception decompiling
     */
    @Override
    public TreeSet<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <U> Set<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <U> Set<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Iterator<TreeSet<T>> sliding(long size) {
        return this.sliding(size, 1L);
    }

    @Override
    public Iterator<TreeSet<T>> sliding(long size, long step) {
        return this.iterator().sliding(size, step).map((T seq) -> TreeSet.ofAll(this.tree.comparator(), seq));
    }

    @Override
    public Tuple2<TreeSet<T>, TreeSet<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.iterator().span(predicate).map((? super T1 i1) -> TreeSet.ofAll(this.tree.comparator(), i1), (? super T2 i2) -> TreeSet.ofAll(this.tree.comparator(), i2));
    }

    @Override
    public TreeSet<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty TreeSet");
        }
        return new TreeSet<T>(this.tree.delete(this.tree.min().get()));
    }

    @Override
    public Option<TreeSet<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    public TreeSet<T> take(long n) {
        if (n <= 0L) {
            return TreeSet.empty(this.tree.comparator());
        }
        if (n >= (long)this.length()) {
            return this;
        }
        return TreeSet.ofAll(this.tree.comparator(), this.iterator().take(n));
    }

    @Override
    public TreeSet<T> takeRight(long n) {
        if (n <= 0L) {
            return TreeSet.empty(this.tree.comparator());
        }
        if (n >= (long)this.length()) {
            return this;
        }
        return TreeSet.ofAll(this.tree.comparator(), this.iterator().takeRight(n));
    }

    @Override
    public TreeSet<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        SortedSet treeSet = this.takeWhile((Predicate)predicate.negate());
        return ((TreeSet)treeSet).length() == this.length() ? this : treeSet;
    }

    @Override
    public TreeSet<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        TreeSet<T> treeSet = TreeSet.ofAll(this.tree.comparator(), this.iterator().takeWhile(predicate));
        return treeSet.length() == this.length() ? this : treeSet;
    }

    public <U> U transform(Function<? super TreeSet<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    public java.util.TreeSet<T> toJavaSet() {
        return this.toJavaSet(() -> new java.util.TreeSet<T>(this.comparator()));
    }

    @Override
    public TreeSet<T> union(Set<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof TreeSet) {
            RedBlackTree<T> that = ((TreeSet)elements).tree;
            return new TreeSet<T>(this.tree.union(that));
        }
        return this.addAll(elements);
    }

    @Override
    public <T1, T2> Tuple2<TreeSet<T1>, TreeSet<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        return this.iterator().unzip(unzipper).map((? super T1 i1) -> TreeSet.ofAll(Comparators.naturalComparator(), i1), (? super T2 i2) -> TreeSet.ofAll(Comparators.naturalComparator(), i2));
    }

    @Override
    public <T1, T2, T3> Tuple3<TreeSet<T1>, TreeSet<T2>, TreeSet<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        return this.iterator().unzip3(unzipper).map(i1 -> TreeSet.ofAll(Comparators.naturalComparator(), i1), i2 -> TreeSet.ofAll(Comparators.naturalComparator(), i2), i3 -> TreeSet.ofAll(Comparators.naturalComparator(), i3));
    }

    @Override
    public <U> TreeSet<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        Comparator tuple2Comparator = Tuple2.comparator(this.tree.comparator(), Comparators.naturalComparator());
        return TreeSet.ofAll(tuple2Comparator, this.iterator().zip(that));
    }

    @Override
    public <U> TreeSet<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        Comparator tuple2Comparator = Tuple2.comparator(this.tree.comparator(), Comparators.naturalComparator());
        return TreeSet.ofAll(tuple2Comparator, this.iterator().zipAll(that, thisElem, thatElem));
    }

    @Override
    public TreeSet<Tuple2<T, Long>> zipWithIndex() {
        Comparator component1Comparator = this.tree.comparator();
        Comparator tuple2Comparator = (t1, t2) -> component1Comparator.compare(t1._1, t2._1);
        return TreeSet.ofAll(tuple2Comparator, this.iterator().zipWithIndex());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TreeSet) {
            TreeSet that = (TreeSet)o;
            return this.tree.equals(that.tree);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.tree.hashCode();
    }

    @Override
    public String stringPrefix() {
        return "TreeSet";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }
}

