/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.XmlElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.XCollection;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCollectionBinding
extends NotNullDeserializeBinding
implements MultiNodeBinding,
NestedBinding {
    private final MutableAccessor myAccessor;
    private List<Binding> itemBindings;
    protected final Class<?> itemType;
    @Nullable
    private final AbstractCollection annotation;
    @Nullable
    protected final XCollection newAnnotation;
    private Serializer serializer;

    AbstractCollectionBinding(@NotNull Class<?> elementType, @Nullable MutableAccessor accessor) {
        if (elementType == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(0);
        }
        this.myAccessor = accessor;
        this.itemType = elementType;
        XCollection xCollection = this.newAnnotation = accessor == null ? null : accessor.getAnnotation(XCollection.class);
        this.annotation = this.newAnnotation == null ? (accessor == null ? null : accessor.getAnnotation(AbstractCollection.class)) : null;
    }

    @Override
    @NotNull
    public final MutableAccessor getAccessor() {
        MutableAccessor mutableAccessor = this.myAccessor;
        if (mutableAccessor == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(1);
        }
        return mutableAccessor;
    }

    protected final boolean isSortOrderedSet() {
        return this.annotation == null || this.annotation.sortOrderedSet();
    }

    @Override
    public final boolean isMulti() {
        return true;
    }

    @Override
    public final void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        if (originalType == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(2);
        }
        if (serializer == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(3);
        }
        this.serializer = serializer;
    }

    private boolean isSurroundWithTag() {
        return this.newAnnotation == null && (this.annotation == null || this.annotation.surroundWithTag());
    }

    @NotNull
    private @NotNull Class<?> @NotNull [] getElementTypes() {
        if (this.newAnnotation != null) {
            Class<?>[] classArray = this.newAnnotation.elementTypes();
            if (classArray == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(4);
            }
            return classArray;
        }
        Class[] classArray = this.annotation == null ? ArrayUtil.EMPTY_CLASS_ARRAY : this.annotation.elementTypes();
        if (classArray == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(5);
        }
        return classArray;
    }

    @Nullable
    private Binding getItemBinding(@NotNull Class<?> aClass) {
        if (aClass == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(6);
        }
        return ClassUtil.isPrimitive(aClass) ? null : this.serializer.getRootBinding(aClass, aClass);
    }

    @NotNull
    private synchronized List<Binding> getItemBindings() {
        if (this.itemBindings == null) {
            Binding binding = this.getItemBinding(this.itemType);
            Class<?>[] elementTypes = this.getElementTypes();
            if (elementTypes.length == 0) {
                this.itemBindings = binding == null ? Collections.emptyList() : Collections.singletonList(binding);
            } else {
                this.itemBindings = new SmartList<Binding>();
                if (binding != null) {
                    this.itemBindings.add(binding);
                }
                for (Class<?> aClass : elementTypes) {
                    Binding b = this.getItemBinding(aClass);
                    if (b == null || this.itemBindings.contains(b)) continue;
                    this.itemBindings.add(b);
                }
                if (this.itemBindings.isEmpty()) {
                    this.itemBindings = Collections.emptyList();
                }
            }
        }
        List<Binding> list2 = this.itemBindings;
        if (list2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Nullable
    private Binding getElementBinding(@NotNull Element element2) {
        if (element2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(8);
        }
        for (Binding binding : this.getItemBindings()) {
            if (!binding.isBoundTo(element2)) continue;
            return binding;
        }
        return null;
    }

    @Nullable
    private Binding getElementBinding(@NotNull XmlElement element2) {
        if (element2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(9);
        }
        for (Binding binding : this.getItemBindings()) {
            if (!binding.isBoundTo(element2)) continue;
            return binding;
        }
        return null;
    }

    @NotNull
    abstract Collection<?> getIterable(@NotNull Object var1);

    @Override
    @NotNull
    public final Object serialize(@NotNull Object object, @Nullable Object context2, @Nullable SerializationFilter filter2) {
        String tagName;
        if (object == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(10);
        }
        Collection<?> collection = this.getIterable(object);
        String string2 = tagName = this.isSurroundWithTag() ? this.getCollectionTagName(object) : null;
        if (tagName == null) {
            SmartList result2 = new SmartList();
            if (!collection.isEmpty()) {
                for (Object item : collection) {
                    ContainerUtil.addAllNotNull(result2, this.serializeItem(item, result2, filter2));
                }
            }
            SmartList smartList = result2;
            if (smartList == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(11);
            }
            return smartList;
        }
        Element result3 = new Element(tagName);
        if (!collection.isEmpty()) {
            for (Object item : collection) {
                Content child = (Content)this.serializeItem(item, result3, filter2);
                if (child == null) continue;
                result3.addContent(child);
            }
        }
        Element element2 = result3;
        if (element2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(12);
        }
        return element2;
    }

    @Override
    @NotNull
    public final Object deserialize(@Nullable Object context2, @NotNull Element element2) {
        if (element2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(13);
        }
        if (this.isSurroundWithTag()) {
            Object object = this.doDeserializeList(context2, element2.getChildren());
            if (object == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(14);
            }
            return object;
        }
        Object object = this.doDeserializeList(context2, Collections.singletonList(element2));
        if (object == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(15);
        }
        return object;
    }

    @Override
    @NotNull
    public final Object deserialize(@Nullable Object context2, @NotNull XmlElement element2) {
        if (element2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(16);
        }
        if (this.isSurroundWithTag()) {
            Object object = this.doDeserializeList2(context2, element2.children);
            if (object == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(17);
            }
            return object;
        }
        Object object = this.doDeserializeList2(context2, Collections.singletonList(element2));
        if (object == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(18);
        }
        return object;
    }

    @Override
    @NotNull
    public final Object deserializeList(@Nullable Object context2, @NotNull List<Element> elements) {
        if (elements == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(19);
        }
        if (!this.isSurroundWithTag()) {
            Object object = this.doDeserializeList(context2, elements);
            if (object == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(20);
            }
            return object;
        }
        assert (elements.size() == 1);
        Element element2 = elements.get(0);
        Object object = this.doDeserializeList(context2 == null && element2.getName().equals("set") ? new HashSet() : context2, element2.getChildren());
        if (object == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(21);
        }
        return object;
    }

    @Override
    @Nullable
    public Object deserializeList2(@Nullable Object context2, @NotNull List<XmlElement> elements) {
        if (elements == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(22);
        }
        if (!this.isSurroundWithTag()) {
            return this.doDeserializeList2(context2, elements);
        }
        assert (elements.size() == 1);
        XmlElement element2 = elements.get(0);
        return this.doDeserializeList2(context2 == null && element2.name.equals("set") ? new HashSet() : context2, element2.children);
    }

    @NotNull
    protected abstract Object doDeserializeList(@Nullable Object var1, @NotNull List<Element> var2);

    @NotNull
    protected abstract Object doDeserializeList2(@Nullable Object var1, @NotNull List<XmlElement> var2);

    @Nullable
    private Object serializeItem(@Nullable Object value2, Object context2, @Nullable SerializationFilter filter2) {
        if (value2 == null) {
            LOG.warn("Collection " + this.myAccessor + " contains 'null' object");
            return null;
        }
        Binding binding = this.getItemBinding(value2.getClass());
        if (binding == null) {
            String elementName = this.getElementName();
            if (StringUtil.isEmpty(elementName)) {
                throw new Error("elementName must be not empty");
            }
            Element serializedItem = new Element(elementName);
            String attributeName = this.getValueAttributeName();
            String serialized = XmlSerializerImpl.convertToString(value2);
            if (attributeName.isEmpty()) {
                if (!serialized.isEmpty()) {
                    serializedItem.addContent(new Text(serialized));
                }
            } else {
                serializedItem.setAttribute(attributeName, JDOMUtil.removeControlChars(serialized));
            }
            return serializedItem;
        }
        return binding.serialize(value2, context2, filter2);
    }

    protected final Object deserializeItem(@NotNull Element node, @Nullable Object context2) {
        Binding binding;
        if (node == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(23);
        }
        if ((binding = this.getElementBinding(node)) == null) {
            String attributeName = this.getValueAttributeName();
            String value2 = attributeName.isEmpty() ? XmlSerializerImpl.getTextValue(node, "") : node.getAttributeValue(attributeName);
            return XmlSerializerImpl.convert(value2, this.itemType);
        }
        return binding.deserializeUnsafe(context2, node);
    }

    protected final Object deserializeItem(@NotNull XmlElement node, @Nullable Object context2) {
        Binding binding;
        if (node == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(24);
        }
        if ((binding = this.getElementBinding(node)) == null) {
            String attributeName = this.getValueAttributeName();
            String value2 = attributeName.isEmpty() ? node.content : node.getAttributeValue(attributeName);
            return XmlSerializerImpl.convert(value2, this.itemType);
        }
        return binding.deserializeUnsafe(context2, node);
    }

    @NotNull
    private String getElementName() {
        if (this.newAnnotation != null) {
            String string2 = this.newAnnotation.elementName();
            if (string2 == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(25);
            }
            return string2;
        }
        String string3 = this.annotation == null ? "option" : this.annotation.elementTag();
        if (string3 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(26);
        }
        return string3;
    }

    @NotNull
    private String getValueAttributeName() {
        if (this.newAnnotation != null) {
            String string2 = this.newAnnotation.valueAttributeName();
            if (string2 == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(27);
            }
            return string2;
        }
        String string3 = this.annotation == null ? "value" : this.annotation.elementValueAttribute();
        if (string3 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(28);
        }
        return string3;
    }

    @Override
    public final boolean isBoundTo(@NotNull Element element2) {
        if (element2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(29);
        }
        if (this.isSurroundWithTag()) {
            return element2.getName().equals(this.getCollectionTagName(null));
        }
        if (this.getItemBindings().isEmpty()) {
            return element2.getName().equals(this.getElementName());
        }
        return this.getElementBinding(element2) != null;
    }

    @Override
    public final boolean isBoundTo(@NotNull XmlElement element2) {
        if (element2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(30);
        }
        if (this.isSurroundWithTag()) {
            return element2.name.equals(this.getCollectionTagName(null));
        }
        if (this.getItemBindings().isEmpty()) {
            return element2.name.equals(this.getElementName());
        }
        for (Binding binding : this.getItemBindings()) {
            if (!binding.isBoundTo(element2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract String getCollectionTagName(@Nullable Object var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/AbstractCollectionBinding";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/AbstractCollectionBinding";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemBindings";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeList";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAttributeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getItemBinding";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementBinding";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList2";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deserializeItem";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

