/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.text.CharArrayUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteArrayCharSequence
implements CharSequenceWithStringHash {
    private final int myStart;
    private final int myEnd;
    private transient int hash;
    private final byte[] myChars;
    private static final boolean JAVA_9;

    public ByteArrayCharSequence(byte @NotNull [] chars) {
        if (chars == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(0);
        }
        this(chars, 0, chars.length);
    }

    public ByteArrayCharSequence(byte @NotNull [] chars, int start, int end) {
        if (chars == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(1);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Strings.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    @Override
    public int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public char charAt(int index2) {
        return (char)(this.myChars[index2 + this.myStart] & 0xFF);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new ByteArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        return new String(this.myChars, this.myStart, this.length(), StandardCharsets.ISO_8859_1);
    }

    public void getChars(int start, int end, char[] dest, int pos) {
        for (int idx = start; idx < end; ++idx) {
            dest[idx - start + pos] = (char)(this.myChars[idx + this.myStart] & 0xFF);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static CharSequence convertToBytesIfAsciiString(@NotNull String name2) {
        if (name2 == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(2);
        }
        String string2 = name2;
        if (string2 == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static CharSequence convertToBytesIfPossible(@NotNull CharSequence string2) {
        if (string2 == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(4);
        }
        if (JAVA_9) {
            CharSequence charSequence = string2;
            if (charSequence == null) {
                ByteArrayCharSequence.$$$reportNull$$$0(5);
            }
            return charSequence;
        }
        if (string2.length() == 0) {
            return "";
        }
        if (string2 instanceof ByteArrayCharSequence) {
            CharSequence charSequence = string2;
            if (charSequence == null) {
                ByteArrayCharSequence.$$$reportNull$$$0(6);
            }
            return charSequence;
        }
        byte[] bytes = ByteArrayCharSequence.toBytesIfPossible(string2);
        return bytes == null ? string2 : new ByteArrayCharSequence(bytes);
    }

    private byte @NotNull [] getBytes() {
        byte[] byArray = this.myStart == 0 && this.myEnd == this.myChars.length ? this.myChars : Arrays.copyOfRange(this.myChars, this.myStart, this.myEnd);
        if (byArray == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(7);
        }
        return byArray;
    }

    private static byte @Nullable [] toBytesIfPossible(@NotNull CharSequence seq) {
        if (seq == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(8);
        }
        if (seq instanceof ByteArrayCharSequence) {
            return ((ByteArrayCharSequence)seq).getBytes();
        }
        byte[] bytes = new byte[seq.length()];
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(seq);
        if (chars == null) {
            for (int i = 0; i < bytes.length; ++i) {
                char c = seq.charAt(i);
                if ((c & 0xFF00) != 0) {
                    return null;
                }
                bytes[i] = (byte)c;
            }
        } else {
            for (int i = 0; i < bytes.length; ++i) {
                char c = chars[i];
                if ((c & 0xFF00) != 0) {
                    return null;
                }
                bytes[i] = (byte)c;
            }
        }
        return bytes;
    }

    static {
        boolean hasModuleClass;
        try {
            Class.class.getMethod("getModule", new Class[0]);
            hasModuleClass = true;
        }
        catch (Throwable t) {
            hasModuleClass = false;
        }
        JAVA_9 = hasModuleClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/ByteArrayCharSequence";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/ByteArrayCharSequence";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToBytesIfAsciiString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToBytesIfPossible";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertToBytesIfAsciiString";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToBytesIfPossible";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toBytesIfPossible";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

