/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.Bits;
import com.intellij.util.io.OpenChannelsCache;
import com.intellij.util.io.Page;
import com.intellij.util.io.PagePool;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class RandomAccessDataFile
implements Forceable,
Closeable {
    private static final Logger LOG = Logger.getInstance(RandomAccessDataFile.class);
    private static final OpenChannelsCache ourCache = new OpenChannelsCache(10);
    private static final AtomicInteger ourFilesCount = new AtomicInteger();
    private final int myCount;
    private final Path myFile;
    private final PagePool myPool;
    private static final ThreadLocal<byte[]> ourTypedIOBuffer = ThreadLocal.withInitial(() -> new byte[8]);
    private final OutputStreamWriter log;
    private volatile long mySize;
    private volatile boolean myIsDirty;
    private volatile boolean myIsDisposed;
    private static final boolean DEBUG = false;
    public static int totalReads;
    public static long totalReadBytes;
    public static int totalWrites;
    public static long totalWriteBytes;

    public RandomAccessDataFile(@NotNull Path file2, @NotNull PagePool pool) throws IOException {
        if (file2 == null) {
            RandomAccessDataFile.$$$reportNull$$$0(0);
        }
        if (pool == null) {
            RandomAccessDataFile.$$$reportNull$$$0(1);
        }
        this.myCount = ourFilesCount.incrementAndGet();
        this.myPool = pool;
        this.myFile = file2;
        this.mySize = Files.size(file2);
        this.log = null;
    }

    public void put(long addr, byte[] bytes, int off, int len) {
        this.assertNotDisposed();
        RandomAccessDataFile.ensureNonNegative(addr, "addr");
        RandomAccessDataFile.ensureArrayBounds(bytes, off, len);
        this.myIsDirty = true;
        this.mySize = Math.max(this.mySize, addr + (long)len);
        while (len > 0) {
            Page page = this.myPool.alloc(this, addr);
            int written = page.put(addr, bytes, off, len);
            len -= written;
            addr += (long)written;
            off += written;
        }
    }

    public void get(long addr, byte[] bytes, int off, int len) {
        this.assertNotDisposed();
        RandomAccessDataFile.ensureNonNegative(addr, "addr");
        RandomAccessDataFile.ensureArrayBounds(bytes, off, len);
        while (len > 0) {
            Page page = this.myPool.alloc(this, addr);
            int read2 = page.get(addr, bytes, off, len);
            len -= read2;
            addr += (long)read2;
            off += read2;
        }
    }

    private static void ensureArrayBounds(byte[] bytes, int off, int len) {
        if (off < 0) {
            throw new IllegalArgumentException("offset (" + off + ") should be non-negative");
        }
        if (len < 0) {
            throw new IllegalArgumentException("length (" + len + ") should be non-negative");
        }
        if (off > bytes.length) {
            throw new IllegalArgumentException("offset (" + off + ") is greater than array size (" + bytes.length + ")");
        }
        if (off + len > bytes.length) {
            throw new IllegalArgumentException("offset (" + off + ") + length (" + len + ") is greater than array size (" + bytes.length + ")");
        }
    }

    /*
     * WARNING - void declaration
     */
    static void ensureNonNegative(long value2, @NotNull String string2) {
        if (string2 == null) {
            RandomAccessDataFile.$$$reportNull$$$0(2);
        }
        if (value2 < 0L) {
            void name2;
            throw new IllegalArgumentException((String)name2 + " should be non-negative but actual is " + value2);
        }
    }

    private <T> T useFileChannel(@NotNull OpenChannelsCache.ChannelProcessor<T> channelConsumer) throws IOException {
        if (channelConsumer == null) {
            RandomAccessDataFile.$$$reportNull$$$0(3);
        }
        return ourCache.useChannel(this.myFile, channelConsumer, false);
    }

    public void putInt(long addr, int value2) {
        Bits.putInt(ourTypedIOBuffer.get(), 0, value2);
        this.put(addr, ourTypedIOBuffer.get(), 0, 4);
    }

    public int getInt(long addr) {
        this.get(addr, ourTypedIOBuffer.get(), 0, 4);
        return Bits.getInt(ourTypedIOBuffer.get(), 0);
    }

    public void putLong(long addr, long value2) {
        Bits.putLong(ourTypedIOBuffer.get(), 0, value2);
        this.put(addr, ourTypedIOBuffer.get(), 0, 8);
    }

    public long getLong(long addr) {
        this.get(addr, ourTypedIOBuffer.get(), 0, 8);
        return Bits.getLong(ourTypedIOBuffer.get(), 0);
    }

    public long length() {
        this.assertNotDisposed();
        return this.mySize;
    }

    public long physicalLength() {
        this.assertNotDisposed();
        try {
            return this.useFileChannel(FileChannel::size);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void dispose() {
        if (this.myIsDisposed) {
            return;
        }
        this.myPool.flushPages(this);
        try {
            ourCache.closeChannel(this.myFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.myIsDisposed = true;
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void force() {
        this.assertNotDisposed();
        if (this.isDirty()) {
            this.myPool.flushPages(this);
            this.myIsDirty = false;
        }
    }

    public void sync() {
        this.force();
        try {
            this.useFileChannel(ch -> {
                ch.force(true);
                return null;
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isDirty() {
        this.assertNotDisposed();
        return this.myIsDirty;
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    private void assertNotDisposed() {
        if (this.myIsDisposed) {
            LOG.error("storage file is disposed: " + this.myFile);
        }
    }

    void loadPage(Page page) {
        this.assertNotDisposed();
        try {
            ByteBuffer buf = page.getBuf();
            this.useFileChannel(file2 -> file2.read(ByteBuffer.wrap(buf.array(), 0, Page.PAGE_SIZE), page.getOffset()));
            ++totalReads;
            totalReadBytes += (long)Page.PAGE_SIZE;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void flushPage(Page page, int start, int end) {
        this.assertNotDisposed();
        try {
            this.flush(page.getBuf(), page.getOffset() + (long)start, start, end - start);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void flush(ByteBuffer buf, long fileOffset, int bufOffset, int length) throws IOException {
        if (fileOffset + (long)length > this.mySize) {
            length = (int)(this.mySize - fileOffset);
        }
        int finalLength = length;
        this.useFileChannel(file2 -> {
            int written = file2.write(ByteBuffer.wrap(buf.array(), bufOffset, finalLength), fileOffset);
            ++totalWrites;
            totalWriteBytes += (long)finalLength;
            return written;
        });
    }

    public int hashCode() {
        return this.myCount;
    }

    public String toString() {
        return "RandomAccessFile[" + this.myFile + ", dirty=" + this.myIsDirty + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pool";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channelConsumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/RandomAccessDataFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureNonNegative";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "useFileChannel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

