/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.cache.TypeAnnotationContainer;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsReferenceParameterListImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsJavaCodeReferenceElementImpl
extends ClsElementImpl
implements PsiAnnotatedJavaCodeReferenceElement {
    private final PsiElement myParent;
    private final String myCanonicalText;
    private String myShortName;
    private final String myQualifiedName;
    private final PsiReferenceParameterList myRefParameterList;
    private final TypeAnnotationContainer myAnnotations;
    private final ClsJavaCodeReferenceElementImpl myQualifier;

    public ClsJavaCodeReferenceElementImpl(@NotNull PsiElement parent2, @NotNull String canonicalText) {
        if (parent2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(0);
        }
        if (canonicalText == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(1);
        }
        this(parent2, canonicalText, TypeAnnotationContainer.EMPTY);
    }

    public ClsJavaCodeReferenceElementImpl(@NotNull PsiElement parent2, @NotNull String canonicalText, @NotNull TypeAnnotationContainer annotations2) {
        String canonical;
        if (parent2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(2);
        }
        if (canonicalText == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(3);
        }
        if (annotations2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(4);
        }
        this.myParent = parent2;
        this.myCanonicalText = canonical = TypeInfo.internFrequentType(canonicalText);
        String qName = TypeInfo.internFrequentType(PsiNameHelper.getQualifiedClassName(this.myCanonicalText, false));
        this.myQualifiedName = qName.equals(canonical) ? canonical : qName;
        String[] classParameters = PsiNameHelper.getClassParametersText(canonicalText);
        this.myRefParameterList = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl(this, classParameters, annotations2);
        this.myAnnotations = annotations2;
        String prefix = PsiNameHelper.getOuterClassReference(canonicalText);
        TypeAnnotationContainer container2 = prefix.isEmpty() ? TypeAnnotationContainer.EMPTY : annotations2.forEnclosingClass();
        this.myQualifier = container2.isEmpty() ? null : new ClsJavaCodeReferenceElementImpl(this, prefix, container2);
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray;
        if (this.myQualifier != null) {
            PsiElement[] psiElementArray2;
            if (this.myRefParameterList != null) {
                PsiElement[] psiElementArray3 = new PsiElement[2];
                psiElementArray3[0] = this.myQualifier;
                psiElementArray2 = psiElementArray3;
                psiElementArray3[1] = this.myRefParameterList;
            } else {
                PsiElement[] psiElementArray4 = new PsiElement[1];
                psiElementArray2 = psiElementArray4;
                psiElementArray4[0] = this.myQualifier;
            }
            if (psiElementArray2 == null) {
                ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(5);
            }
            return psiElementArray2;
        }
        if (this.myRefParameterList != null) {
            PsiElement[] psiElementArray5 = new PsiElement[1];
            psiElementArray = psiElementArray5;
            psiElementArray5[0] = this.myRefParameterList;
        } else {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        return PsiNameHelper.getPresentableText(this);
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string2 = this.myCanonicalText;
        if (string2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated, PsiAnnotation @Nullable [] annotations2) {
        String text = this.getCanonicalText();
        if (!annotated || annotations2 == null) {
            String string2 = text;
            if (string2 == null) {
                ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(8);
            }
            return string2;
        }
        StringBuilder sb = new StringBuilder();
        String prefix = PsiNameHelper.getOuterClassReference(text);
        int simpleNamePos = 0;
        if (!StringUtil.isEmpty(prefix)) {
            if (this.myQualifier != null) {
                sb.append(this.myQualifier.getCanonicalText(true, this.myQualifier.myAnnotations.getProvider(this.myQualifier).getAnnotations()));
            } else {
                sb.append(prefix);
            }
            sb.append('.');
            simpleNamePos = prefix.length() + 1;
        }
        PsiNameHelper.appendAnnotations(sb, Arrays.asList(annotations2), true);
        int typeArgPos = text.indexOf(60, simpleNamePos);
        if (typeArgPos == -1) {
            sb.append(text, simpleNamePos, text.length());
        } else {
            sb.append(text, simpleNamePos, typeArgPos);
            PsiNameHelper.appendTypeArgs(sb, this.getTypeParameters(), true, true);
        }
        String string3 = sb.toString();
        if (string3 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(9);
        }
        return string3;
    }

    private JavaResolveResult advancedResolveImpl(@NotNull PsiFile containingFile2) {
        if (containingFile2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(10);
        }
        PsiTypeElement[] typeElements = this.myRefParameterList == null ? PsiTypeElement.EMPTY_ARRAY : this.myRefParameterList.getTypeParameterElements();
        PsiElement resolve2 = this.resolveElement(containingFile2);
        if (resolve2 == null) {
            return null;
        }
        if (resolve2 instanceof PsiClass) {
            HashMap<PsiTypeParameter, PsiType> substitutionMap = new HashMap<PsiTypeParameter, PsiType>();
            int index2 = 0;
            for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiClass)resolve2)) {
                if (index2 >= typeElements.length) {
                    substitutionMap.put(parameter2, null);
                } else {
                    substitutionMap.put(parameter2, typeElements[index2].getType());
                }
                ++index2;
            }
            this.collectOuterClassTypeArgs((PsiClass)resolve2, this.myCanonicalText, substitutionMap);
            return new CandidateInfo(resolve2, PsiSubstitutor.createSubstitutor(substitutionMap));
        }
        return new CandidateInfo(resolve2, PsiSubstitutor.EMPTY);
    }

    private void collectOuterClassTypeArgs(@NotNull PsiClass psiClass, String canonicalText, Map<PsiTypeParameter, PsiType> substitutionMap) {
        PsiClass containingClass;
        if (psiClass == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(11);
        }
        if ((containingClass = psiClass.getContainingClass()) != null) {
            String outerClassRef = PsiNameHelper.getOuterClassReference(canonicalText);
            String[] classParameters = PsiNameHelper.getClassParametersText(outerClassRef);
            PsiType[] args = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl(this, classParameters, TypeAnnotationContainer.EMPTY).getTypeArguments();
            PsiTypeParameter[] typeParameters2 = containingClass.getTypeParameters();
            for (int i = 0; i < typeParameters2.length; ++i) {
                if (args != null) {
                    if (i >= args.length) continue;
                    substitutionMap.put(typeParameters2[i], args[i]);
                    continue;
                }
                substitutionMap.put(typeParameters2[i], null);
            }
            if (!containingClass.hasModifierProperty("static")) {
                this.collectOuterClassTypeArgs(containingClass, outerClassRef, substitutionMap);
            }
        }
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            JavaResolveResult javaResolveResult = results[0];
            if (javaResolveResult == null) {
                ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(12);
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(13);
        }
        return javaResolveResult;
    }

    @Override
    public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getContainingFile();
        if (file2 == null) {
            return this.diagnoseNoFile();
        }
        ResolveCache resolveCache = ResolveCache.getInstance(file2.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, Resolver.INSTANCE, true, incompleteCode, file2);
        if (results.length == 0) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(14);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(15);
        }
        return javaResolveResultArray;
    }

    private JavaResolveResult @NotNull [] diagnoseNoFile() {
        PsiElement root = SyntaxTraverser.psiApi().parents(this).last();
        PsiUtilCore.ensureValid(Objects.requireNonNull(root));
        throw new PsiInvalidElementAccessException((PsiElement)this, "parent=" + this.myParent + ", root=" + root + ", canonicalText=" + this.myCanonicalText);
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Nullable
    private PsiElement resolveElement(@NotNull PsiFile containingFile2) {
        if (containingFile2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(16);
        }
        for (PsiElement element2 = this.getParent(); element2 != null && !(element2 instanceof PsiFile); element2 = element2.getParent()) {
            if (element2 instanceof PsiMethod) {
                for (PsiTypeParameter psiTypeParameter : PsiUtil.typeParametersIterable((PsiMethod)element2)) {
                    if (!this.myQualifiedName.equals(psiTypeParameter.getName())) continue;
                    return psiTypeParameter;
                }
                continue;
            }
            if (!(element2 instanceof PsiClass) || element2 instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)element2;
            if (this.myQualifiedName.equals(psiClass.getQualifiedName())) {
                return element2;
            }
            for (PsiTypeParameter parameter3 : PsiUtil.typeParametersIterable(psiClass)) {
                if (!this.myQualifiedName.equals(parameter3.getName())) continue;
                return parameter3;
            }
            for (PsiClass innerClass : psiClass.getInnerClasses()) {
                if (!this.myQualifiedName.equals(innerClass.getQualifiedName())) continue;
                return innerClass;
            }
        }
        Project project = containingFile2.getProject();
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getInstance(project).getResolveScope(this);
        return JavaPsiFacade.getInstance(project).findClass(this.myQualifiedName, globalSearchScope);
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        if (processor2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(17);
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return this.myRefParameterList;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public String getReferenceName() {
        String name2 = this.myShortName;
        if (name2 == null) {
            this.myShortName = name2 = PsiNameHelper.getShortClassName(this.myCanonicalText);
        }
        return name2;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(18);
        }
        throw ClsJavaCodeReferenceElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(19);
        }
        throw ClsJavaCodeReferenceElementImpl.cannotModifyException(this);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(20);
        }
        if (!(element2 instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)element2;
        return this.myCanonicalText.equals(aClass.getQualifiedName()) || this.getManager().areElementsEquivalent(this.resolve(), element2);
    }

    @Override
    public Object @NotNull [] getVariants() {
        throw new RuntimeException("Variants are not available for references to compiled code");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(21);
        }
        buffer.append(this.getCanonicalText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element2) throws ClsElementImpl.InvalidMirrorException {
        if (element2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(22);
        }
        this.setMirrorCheckingType(element2, JavaElementType.JAVA_CODE_REFERENCE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(23);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        ClsJavaCodeReferenceElementImpl clsJavaCodeReferenceElementImpl = this;
        if (clsJavaCodeReferenceElementImpl == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(24);
        }
        return clsJavaCodeReferenceElementImpl;
    }

    @Override
    public PsiType @NotNull [] getTypeParameters() {
        PsiType[] psiTypeArray = this.myRefParameterList == null ? PsiType.EMPTY_ARRAY : this.myRefParameterList.getTypeArguments();
        if (psiTypeArray == null) {
            ClsJavaCodeReferenceElementImpl.$$$reportNull$$$0(25);
        }
        return psiTypeArray;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    @Override
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "advancedResolveImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectOuterClassTypeArgs";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantContextResolver<ClsJavaCodeReferenceElementImpl> {
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        public JavaResolveResult @NotNull [] resolve(@NotNull ClsJavaCodeReferenceElementImpl ref, @NotNull PsiFile containingFile2, boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            JavaResolveResult resolveResult;
            if (ref == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            if (containingFile2 == null) {
                Resolver.$$$reportNull$$$0(1);
            }
            if ((resolveResult = ref.advancedResolveImpl(containingFile2)) == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = resolveResult;
            }
            if (javaResolveResultArray == null) {
                Resolver.$$$reportNull$$$0(2);
            }
            return javaResolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

