/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EncodingRegistry {
    public abstract boolean isNative2Ascii(@NotNull VirtualFile var1);

    public abstract boolean isNative2AsciiForPropertiesFiles();

    @NotNull
    public abstract Charset getDefaultCharset();

    @Nullable
    public abstract Charset getEncoding(@Nullable VirtualFile var1, boolean var2);

    public abstract void setEncoding(@Nullable(value="null means project") @Nullable(value="null means project") VirtualFile var1, @Nullable(value="null means remove mapping") @Nullable(value="null means remove mapping") Charset var2);

    @Nullable(value="null means 'use system-default'")
    public @Nullable(value="null means 'use system-default'") Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile2) {
        return null;
    }

    @NotNull
    public abstract Charset getDefaultConsoleEncoding();

    public static EncodingRegistry getInstance() {
        return EncodingManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> VirtualFile doActionAndRestoreEncoding(@NotNull VirtualFile fileBefore, @NotNull ThrowableComputable<? extends VirtualFile, E> action) throws E {
        if (fileBefore == null) {
            EncodingRegistry.$$$reportNull$$$0(0);
        }
        if (action == null) {
            EncodingRegistry.$$$reportNull$$$0(1);
        }
        EncodingRegistry registry = EncodingRegistry.getInstance();
        Charset charsetBefore = registry.getEncoding(fileBefore, true);
        VirtualFile fileAfter = null;
        try {
            VirtualFile virtualFile2 = fileAfter = action.compute();
            return virtualFile2;
        }
        finally {
            Charset actual;
            if (fileAfter != null && !Comparing.equal(actual = registry.getEncoding(fileAfter, true), charsetBefore)) {
                registry.setEncoding(fileAfter, charsetBefore);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fileBefore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "action";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vfs/encoding/EncodingRegistry";
        objectArray[2] = "doActionAndRestoreEncoding";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

