/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinAccessibility;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.SymbolInternals;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001CB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011J8\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ2\u0010\u001f\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J4\u0010\"\u001a\u00020\u0016*\u0004\u0018\u00010#2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%2\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u001c\u0010)\u001a\u00020\u0007*\u00020*2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010+\u001a\u00020,H\u0002J\u001c\u0010-\u001a\u00020\u0007*\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010.\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030/2\u0006\u0010+\u001a\u00020,J$\u00100\u001a\u00020\u0007*\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0002JN\u00101\u001a\u00020\u0016*\u0002022\n\u0010 \u001a\u0006\u0012\u0002\b\u0003032\u0006\u0010\n\u001a\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u00104\u001a\u00020\u00072\b\u00105\u001a\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%H\u0002J<\u00106\u001a\u00020\u0016*\u0002072\n\u0010 \u001a\u0006\u0012\u0002\b\u0003032\u0006\u0010\n\u001a\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%H\u0002J.\u00108\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u0006\u0012\u0002\b\u0003032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u00072\b\u00105\u001a\u0004\u0018\u00010#JV\u00108\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u0006\u0012\u0002\b\u0003032\u0006\u0010\n\u001a\u00020\u000b2\u000e\u00109\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u00104\u001a\u00020\u00072\b\u00105\u001a\u0004\u0018\u00010#2\u0006\u0010\f\u001a\u00020\u0007H\u0002J*\u0010:\u001a\u00020\u0016*\u00020(2\u0006\u0010+\u001a\u00020,2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0;2\u0006\u0010\f\u001a\u00020\u0007H\u0002J$\u0010:\u001a\u00020\u0016*\u0006\u0012\u0002\b\u0003032\u0006\u0010+\u001a\u00020,2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0;J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u0006\u0012\u0002\b\u00030/2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010=\u001a\u0004\u0018\u00010\u000f*\u00020>2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010@H\u0002J \u0010=\u001a\u0004\u0018\u00010\u000f*\u00020A2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010@J\u001c\u0010B\u001a\u00020\u0007*\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker;", "", "()V", "LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "MESSAGE", "isExperimentalityAcceptableInContext", "", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "fromSupertype", "loadExperimentalitiesFromConeArguments", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "typeArguments", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "loadExperimentalitiesFromTypeArguments", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "reportNotAcceptedExperimentalities", "", "experimentalities", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reportNotAcceptedOverrideExperimentalities", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "addExperimentalities", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "result", "Lorg/jetbrains/kotlin/utils/SmartSet;", "visited", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isAnnotatedWithOptIn", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isAnnotatedWithSubclassOptInRequired", "isExperimentalMarker", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "isExperimentalityAcceptable", "loadCallableSpecificExperimentalities", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "fromSetter", "dispatchReceiverType", "loadClassLikeSpecificExperimentalities", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "loadExperimentalities", "knownExperimentalities", "loadExperimentalitiesFromAnnotationTo", "", "loadExperimentalitiesFromSupertype", "loadExperimentalityForMarkerAnnotation", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "annotatedOwnerClassName", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "primaryConstructorParameterIsExperimentalityAcceptable", "Experimentality", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageBaseChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageBaseChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n22#2,4:416\n22#2,4:428\n1547#3:420\n1618#3,3:421\n1853#3,2:424\n1853#3,2:426\n1853#3,2:432\n798#3,11:435\n288#3,2:446\n1745#3,3:453\n57#4:434\n13291#5,2:448\n1282#5,2:450\n1#6:452\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageBaseChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker\n*L\n99#1:416,4\n212#1:428,4\n127#1:420\n127#1:421,3\n136#1:424,2\n184#1:426,2\n217#1:432,2\n226#1:435,11\n227#1:446,2\n388#1:453,3\n222#1:434\n267#1:448,2\n288#1:450,2\n*E\n"})
public final class FirOptInUsageBaseChecker {
    @NotNull
    public static final FirOptInUsageBaseChecker INSTANCE = new FirOptInUsageBaseChecker();
    @NotNull
    private static final Name LEVEL;
    @NotNull
    private static final Name MESSAGE;

    private FirOptInUsageBaseChecker() {
    }

    @Nullable
    public final Experimentality loadExperimentalityForMarkerAnnotation(@NotNull FirRegularClassSymbol $this$loadExperimentalityForMarkerAnnotation, @NotNull FirSession session2, @Nullable String annotatedOwnerClassName) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalityForMarkerAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$loadExperimentalityForMarkerAnnotation, FirResolvePhase.BODY_RESOLVE);
        return this.loadExperimentalityForMarkerAnnotation((FirRegularClass)$this$loadExperimentalityForMarkerAnnotation.getFir(), session2, annotatedOwnerClassName);
    }

    public static /* synthetic */ Experimentality loadExperimentalityForMarkerAnnotation$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, FirRegularClassSymbol firRegularClassSymbol, FirSession firSession, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return firOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation(firRegularClassSymbol, firSession, string2);
    }

    public final void loadExperimentalitiesFromAnnotationTo(@NotNull FirBasedSymbol<?> $this$loadExperimentalitiesFromAnnotationTo, @NotNull FirSession session2, @NotNull Collection<Experimentality> result2) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalitiesFromAnnotationTo, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(result2, "result");
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$loadExperimentalitiesFromAnnotationTo, FirResolvePhase.STATUS);
        this.loadExperimentalitiesFromAnnotationTo((FirDeclaration)$this$loadExperimentalitiesFromAnnotationTo.getFir(), session2, result2, false);
    }

    private final void loadExperimentalitiesFromAnnotationTo(FirDeclaration $this$loadExperimentalitiesFromAnnotationTo, FirSession session2, Collection<Experimentality> result2, boolean fromSupertype) {
        for (FirAnnotation annotation2 : $this$loadExperimentalitiesFromAnnotationTo.getAnnotations()) {
            Experimentality experimentality;
            FirExpression annotationClass2;
            ConeClassLikeType annotationType2;
            Object object;
            Object $this$coneTypeSafe$iv = annotation2.getAnnotationTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
            $this$coneTypeSafe$iv = $this$loadExperimentalitiesFromAnnotationTo;
            String className = $this$coneTypeSafe$iv instanceof FirRegularClass ? ((FirRegularClass)$this$loadExperimentalitiesFromAnnotationTo).getName().asString() : ($this$coneTypeSafe$iv instanceof FirCallableDeclaration ? ((object = ((FirCallableDeclaration)$this$loadExperimentalitiesFromAnnotationTo).getSymbol().getCallableId().getClassName()) != null && (object = ((FqName)object).shortName()) != null ? ((Name)object).asString() : null) : null);
            $this$coneTypeSafe$iv = LookupTagUtilsKt.toFirRegularClassSymbol(annotationType2.getLookupTag(), session2);
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, $this$coneTypeSafe$iv != null ? this.loadExperimentalityForMarkerAnnotation((FirRegularClassSymbol)$this$coneTypeSafe$iv, session2, className) : null);
            if (!fromSupertype || !Intrinsics.areEqual(annotationType2.getLookupTag().getClassId(), OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName(annotation2, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS()) == null) continue;
            FirRegularClassSymbol firRegularClassSymbol = FirAnnotationHelpersKt.extractClassFromArgument(annotationClass2, session2);
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, firRegularClassSymbol != null && (experimentality = FirOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation$default(this, firRegularClassSymbol, session2, null, 2, null)) != null ? Experimentality.copy$default(experimentality, null, null, null, null, true, 15, null) : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromTypeArguments(@NotNull CheckerContext context2, @NotNull List<? extends FirTypeProjection> typeArguments2) {
        Collection<ConeTypeProjection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(typeArguments2, "typeArguments");
        if (typeArguments2.isEmpty()) {
            return SetsKt.emptySet();
        }
        Iterable iterable = typeArguments2;
        CheckerContext checkerContext = context2;
        FirOptInUsageBaseChecker firOptInUsageBaseChecker = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeProjection firTypeProjection = (FirTypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)it));
        }
        collection = (List)destination$iv$iv;
        return firOptInUsageBaseChecker.loadExperimentalitiesFromConeArguments(checkerContext, (List<? extends ConeTypeProjection>)collection);
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromConeArguments(@NotNull CheckerContext context2, @NotNull List<? extends ConeTypeProjection> typeArguments2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(typeArguments2, "typeArguments");
        if (typeArguments2.isEmpty()) {
            return SetsKt.emptySet();
        }
        SmartSet result2 = SmartSet.Companion.create();
        Iterable $this$forEach$iv = typeArguments2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeTypeProjection it = (ConeTypeProjection)element$iv;
            boolean bl = false;
            if (ConeTypeProjectionKt.isStarProjection(it)) continue;
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it);
            if (coneKotlinType == null) continue;
            FirOptInUsageBaseChecker.addExperimentalities$default(INSTANCE, coneKotlinType, context2, result2, null, 4, null);
        }
        return result2;
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalities(@NotNull FirBasedSymbol<?> $this$loadExperimentalities, @NotNull CheckerContext context2, boolean fromSetter, @Nullable ConeKotlinType dispatchReceiverType) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalities, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        return this.loadExperimentalities($this$loadExperimentalities, context2, null, new LinkedHashSet(), fromSetter, dispatchReceiverType, false);
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromSupertype(@NotNull FirClassLikeSymbol<?> $this$loadExperimentalitiesFromSupertype, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalitiesFromSupertype, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        return this.loadExperimentalities((FirBasedSymbol)$this$loadExperimentalitiesFromSupertype, context2, null, new LinkedHashSet(), false, null, true);
    }

    public final boolean isExperimentalMarker(@NotNull FirClassLikeSymbol<?> $this$isExperimentalMarker, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isExperimentalMarker, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return $this$isExperimentalMarker instanceof FirRegularClassSymbol && FirAnnotationUtilsKt.getAnnotationByClassId((FirAnnotationContainer)((FirRegularClassSymbol)$this$isExperimentalMarker).getFir(), OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), session2) != null;
    }

    private final Set<Experimentality> loadExperimentalities(FirBasedSymbol<?> $this$loadExperimentalities, CheckerContext context2, SmartSet<Experimentality> knownExperimentalities, Set<FirDeclaration> visited2, boolean fromSetter, ConeKotlinType dispatchReceiverType, boolean fromSupertype) {
        FirSinceKotlinAccessibility accessibility;
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$loadExperimentalities, FirResolvePhase.STATUS);
        Object fir = $this$loadExperimentalities.getFir();
        if (!visited2.add((FirDeclaration)fir)) {
            return SetsKt.emptySet();
        }
        SmartSet<Experimentality> smartSet = knownExperimentalities;
        if (smartSet == null) {
            smartSet = SmartSet.Companion.create();
        }
        SmartSet<Experimentality> result2 = smartSet;
        FirSession session2 = context2.getSession();
        Object obj = fir;
        if (obj instanceof FirCallableDeclaration) {
            this.loadCallableSpecificExperimentalities((FirCallableDeclaration)fir, $this$loadExperimentalities, context2, visited2, fromSetter, dispatchReceiverType, result2);
        } else if (obj instanceof FirClassLikeDeclaration) {
            this.loadClassLikeSpecificExperimentalities((FirClassLikeDeclaration)fir, $this$loadExperimentalities, context2, visited2, result2);
        } else if (((((obj instanceof FirAnonymousInitializer ? true : obj instanceof FirDanglingModifierList) ? true : obj instanceof FirFile) ? true : obj instanceof FirTypeParameter) ? true : obj instanceof FirScript) ? true : obj instanceof FirCodeFragment) {
            // empty if block
        }
        this.loadExperimentalitiesFromAnnotationTo((FirDeclaration)fir, session2, (Collection<Experimentality>)result2, fromSupertype);
        if (FirAnnotationUtilsKt.getAnnotationByClassId((FirAnnotationContainer)fir, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_CLASS_ID(), session2) != null && (accessibility = FirSinceKotlinHelpersKt.checkSinceKotlinVersionAccessibility(fir, context2)) instanceof FirSinceKotlinAccessibility.NotAccessibleButWasExperimental) {
            Iterable $this$forEach$iv = ((FirSinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                boolean bl = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, FirOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation$default(INSTANCE, (FirRegularClass)it.getFir(), session2, null, 2, null));
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadCallableSpecificExperimentalities(FirCallableDeclaration $this$loadCallableSpecificExperimentalities, FirBasedSymbol<?> symbol2, CheckerContext context2, Set<FirDeclaration> visited2, boolean fromSetter, ConeKotlinType dispatchReceiverType, SmartSet<Experimentality> result2) {
        block15: {
            FirRegularClassSymbol parentClassSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag($this$loadCallableSpecificExperimentalities);
            FirClassLikeSymbol<?> firClassLikeSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession()) : null;
            FirRegularClassSymbol firRegularClassSymbol = parentClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if ($this$loadCallableSpecificExperimentalities instanceof FirConstructor) {
                FirClassLikeSymbol ownerClassLikeSymbol;
                FirTypeAliasSymbol firTypeAliasSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirConstructor)$this$loadCallableSpecificExperimentalities);
                FirClassLikeSymbol firClassLikeSymbol2 = ownerClassLikeSymbol = firTypeAliasSymbol != null ? (FirClassLikeSymbol)firTypeAliasSymbol : (FirClassLikeSymbol)parentClassSymbol;
                if (firClassLikeSymbol2 != null) {
                    this.loadExperimentalities(firClassLikeSymbol2, context2, result2, visited2, false, null, false);
                }
            } else {
                FirTypeRef $this$coneTypeSafe$iv = $this$loadCallableSpecificExperimentalities.getReturnTypeRef();
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(coneKotlinType instanceof ConeKotlinType)) {
                    coneKotlinType = null;
                }
                this.addExperimentalities(coneKotlinType, context2, result2, visited2);
                FirPureAbstractElement firPureAbstractElement = $this$loadCallableSpecificExperimentalities.getReceiverParameter();
                this.addExperimentalities(firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null, context2, result2, visited2);
            }
            ConeKotlinType coneKotlinType = dispatchReceiverType;
            if (coneKotlinType != null) {
                this.addExperimentalities(coneKotlinType, context2, result2, visited2);
            }
            if ($this$loadCallableSpecificExperimentalities instanceof FirFunction) {
                boolean bl;
                Iterable $this$forEach$iv = ((FirFunction)$this$loadCallableSpecificExperimentalities).getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv;
                    boolean bl2 = false;
                    INSTANCE.addExperimentalities(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), context2, result2, visited2);
                }
                FirRegularClassSymbol firRegularClassSymbol2 = parentClassSymbol;
                if (firRegularClassSymbol2 != null) {
                    FirClassLikeSymbol $this$isData$iv = firRegularClassSymbol2;
                    boolean $i$f$isData = false;
                    bl = $this$isData$iv.getRawStatus().isData();
                } else {
                    bl = false;
                }
                if (bl && DataClassResolver.INSTANCE.isComponentLike(FirDeclarationUtilKt.getNameOrSpecialName($this$loadCallableSpecificExperimentalities)) && parentClassSymbol.getClassKind() == ClassKind.CLASS) {
                    FirPropertySymbol property;
                    Object v14;
                    block14: {
                        void $this$filterIsInstanceTo$iv$iv;
                        List<FirValueParameterSymbol> valueParameters2;
                        String string2 = FirDeclarationUtilKt.getNameOrSpecialName($this$loadCallableSpecificExperimentalities).getIdentifier();
                        Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
                        int componentNIndex = DataClassResolver.INSTANCE.getComponentIndex(string2);
                        FirConstructorSymbol firConstructorSymbol2 = DeclarationUtilsKt.primaryConstructorSymbol(parentClassSymbol, context2.getSession());
                        List<FirValueParameterSymbol> list2 = valueParameters2 = firConstructorSymbol2 != null ? firConstructorSymbol2.getValueParameterSymbols() : null;
                        FirValueParameterSymbol valueParameter2 = list2 != null ? CollectionsKt.getOrNull(list2, componentNIndex - 1) : null;
                        Iterable $this$filterIsInstance$iv = parentClassSymbol.getDeclarationSymbols();
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List properties2 = (List)destination$iv$iv;
                        Iterable $this$firstOrNull$iv = properties2;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            FirPropertySymbol it = (FirPropertySymbol)element$iv;
                            boolean bl3 = false;
                            FirValueParameterSymbol firValueParameterSymbol = valueParameter2;
                            if (!Intrinsics.areEqual(it.getName(), firValueParameterSymbol != null ? firValueParameterSymbol.getName() : null)) continue;
                            v14 = element$iv;
                            break block14;
                        }
                        v14 = null;
                    }
                    FirPropertySymbol firPropertySymbol = property = (FirPropertySymbol)v14;
                    if (firPropertySymbol != null) {
                        this.loadExperimentalities(firPropertySymbol, context2, result2, visited2, false, dispatchReceiverType, false);
                    }
                }
            }
            if (!fromSetter || !(symbol2 instanceof FirPropertySymbol)) break block15;
            FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)symbol2).getSetterSymbol();
            if (firPropertyAccessorSymbol != null) {
                this.loadExperimentalities(firPropertyAccessorSymbol, context2, result2, visited2, false, dispatchReceiverType, false);
            }
        }
    }

    private final void loadClassLikeSpecificExperimentalities(FirClassLikeDeclaration $this$loadClassLikeSpecificExperimentalities, FirBasedSymbol<?> symbol2, CheckerContext context2, Set<FirDeclaration> visited2, SmartSet<Experimentality> result2) {
        FirClassLikeDeclaration firClassLikeDeclaration = $this$loadClassLikeSpecificExperimentalities;
        if (firClassLikeDeclaration instanceof FirRegularClass) {
            if (symbol2 instanceof FirRegularClassSymbol) {
                FirClassLikeSymbol<?> parentClassSymbol;
                FirClassLikeSymbol<?> firClassLikeSymbol = parentClassSymbol = FirHelpersKt.outerClassSymbol((FirClassLikeSymbol)symbol2, context2);
                if (firClassLikeSymbol != null) {
                    this.loadExperimentalities((FirBasedSymbol)firClassLikeSymbol, context2, result2, visited2, false, null, false);
                }
            }
        } else if (firClassLikeDeclaration instanceof FirAnonymousObject ? true : firClassLikeDeclaration instanceof FirTypeAlias) {
            // empty if block
        }
    }

    private final void addExperimentalities(ConeKotlinType $this$addExperimentalities, CheckerContext context2, SmartSet<Experimentality> result2, Set<FirDeclaration> visited2) {
        if (!($this$addExperimentalities instanceof ConeClassLikeType)) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(((ConeClassLikeType)$this$addExperimentalities).getLookupTag(), context2.getSession());
        if (firClassLikeSymbol != null) {
            this.loadExperimentalities((FirBasedSymbol)firClassLikeSymbol, context2, result2, visited2, false, null, false);
        }
        ConeTypeProjection[] $this$forEach$iv = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$addExperimentalities, context2.getSession(), null, 2, null).getTypeArguments();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ConeTypeProjection element$iv;
            ConeTypeProjection it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (ConeTypeProjectionKt.isStarProjection(it)) continue;
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it);
            if (coneKotlinType == null) continue;
            INSTANCE.addExperimentalities(coneKotlinType, context2, result2, visited2);
        }
    }

    static /* synthetic */ void addExperimentalities$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, ConeKotlinType coneKotlinType, CheckerContext checkerContext, SmartSet smartSet, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        firOptInUsageBaseChecker.addExperimentalities(coneKotlinType, checkerContext, smartSet, set);
    }

    private final Experimentality loadExperimentalityForMarkerAnnotation(FirRegularClass $this$loadExperimentalityForMarkerAnnotation, FirSession session2, String annotatedOwnerClassName) {
        Experimentality.Severity severity;
        Experimentality.Severity severity2;
        FirAnnotation experimental;
        block3: {
            FirReference calleeReference;
            FirQualifiedAccessExpression levelArgument;
            FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId($this$loadExperimentalityForMarkerAnnotation, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), session2);
            if (firAnnotation == null) {
                return null;
            }
            experimental = firAnnotation;
            FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName(experimental, LEVEL);
            FirQualifiedAccessExpression firQualifiedAccessExpression = levelArgument = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
            FirReference firReference = calleeReference = firQualifiedAccessExpression != null ? firQualifiedAccessExpression.getCalleeReference() : null;
            String levelName = calleeReference instanceof FirErrorNamedReference ? null : (calleeReference instanceof FirNamedReference ? ((FirNamedReference)calleeReference).getName().asString() : null);
            Experimentality.Severity[] $this$firstOrNull$iv = Experimentality.Severity.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Experimentality.Severity element$iv;
                Experimentality.Severity it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual(it.name(), levelName)) continue;
                severity2 = element$iv;
                break block3;
            }
            severity2 = severity = null;
        }
        if (severity2 == null) {
            severity = Experimentality.Companion.getDEFAULT_SEVERITY();
        }
        Experimentality.Severity severity3 = severity;
        FirExpression firExpression3 = FirAnnotationUtilsKt.findArgumentByName(experimental, MESSAGE);
        FirConstExpression firConstExpression = firExpression3 instanceof FirConstExpression ? (FirConstExpression)firExpression3 : null;
        Object t = firConstExpression != null ? firConstExpression.getValue() : null;
        String message2 = t instanceof String ? (String)t : null;
        return new Experimentality($this$loadExperimentalityForMarkerAnnotation.getSymbol().getClassId(), severity3, message2, annotatedOwnerClassName, false, 16, null);
    }

    static /* synthetic */ Experimentality loadExperimentalityForMarkerAnnotation$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, FirRegularClass firRegularClass, FirSession firSession, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return firOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation(firRegularClass, firSession, string2);
    }

    public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull FirElement element2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement source) {
        Intrinsics.checkNotNullParameter(experimentalities, "experimentalities");
        Intrinsics.checkNotNullParameter(element2, "element");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (Experimentality experimentality : experimentalities) {
            String string2;
            FqName fqName2;
            KtDiagnosticFactory2<FqName, String> diagnostic;
            block9: {
                String verb;
                block8: {
                    String string3;
                    Pair<KtDiagnosticFactory2<FqName, String>, String> pair;
                    ClassId annotationClassId = experimentality.component1();
                    Experimentality.Severity severity = experimentality.component2();
                    String message2 = experimentality.component3();
                    boolean fromSupertype = experimentality.component5();
                    if (this.isExperimentalityAcceptableInContext(annotationClassId, context2, fromSupertype)) continue;
                    switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                        case 1: {
                            pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_USAGE(), "should");
                            break;
                        }
                        case 2: {
                            pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_USAGE_ERROR(), "must");
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    Pair<KtDiagnosticFactory2<FqName, String>, String> pair2 = pair;
                    diagnostic = pair2.component1();
                    verb = pair2.component2();
                    fqName2 = annotationClassId.asSingleFqName();
                    string2 = message2;
                    if (string2 == null) break block8;
                    String it = string3 = string2;
                    boolean bl = false;
                    string2 = !StringsKt.isBlank(it) ? string3 : null;
                    if (string2 != null) break block9;
                }
                String string4 = OptInNames.INSTANCE.buildMessagePrefix(verb);
                String string5 = fqName2.asString();
                Intrinsics.checkNotNullExpressionValue(string5, "asString(...)");
                string2 = OptInNames.INSTANCE.buildDefaultDiagnosticMessage(string4, string5);
            }
            String reportedMessage = string2;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (Object)fqName2, (Object)reportedMessage, (DiagnosticContext)context2, null, 32, null);
        }
    }

    public static /* synthetic */ void reportNotAcceptedExperimentalities$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, Collection collection, FirElement firElement, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, int n, Object object) {
        if ((n & 0x10) != 0) {
            ktSourceElement = firElement.getSource();
        }
        firOptInUsageBaseChecker.reportNotAcceptedExperimentalities(collection, firElement, checkerContext, diagnosticReporter, ktSourceElement);
    }

    @SymbolInternals
    public final void reportNotAcceptedOverrideExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull FirCallableSymbol<?> symbol2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(experimentalities, "experimentalities");
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (Experimentality experimentality : experimentalities) {
            Pair<KtDiagnosticFactory2<FqName, String>, String> pair;
            ClassId annotationClassId = experimentality.component1();
            Experimentality.Severity severity = experimentality.component2();
            String markerMessage = experimentality.component3();
            String supertypeName = experimentality.component4();
            if (this.isExperimentalityAcceptable((FirAnnotationContainer)symbol2.getFir(), context2.getSession(), annotationClassId, false) || this.isExperimentalityAcceptableInContext(annotationClassId, context2, false)) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_OVERRIDE(), "should");
                    break;
                }
                case 2: {
                    pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_OVERRIDE_ERROR(), "must");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair<KtDiagnosticFactory2<FqName, String>, String> pair2 = pair;
            KtDiagnosticFactory2<FqName, String> diagnostic = pair2.component1();
            String verb = pair2.component2();
            String string2 = supertypeName;
            if (string2 == null) {
                string2 = "???";
            }
            String message2 = OptInNames.INSTANCE.buildOverrideMessage(string2, markerMessage, verb, annotationClassId.asFqNameString());
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)symbol2.getSource(), diagnostic, (Object)annotationClassId.asSingleFqName(), (Object)message2, (DiagnosticContext)context2, null, 32, null);
        }
    }

    private final boolean isExperimentalityAcceptableInContext(ClassId annotationClassId, CheckerContext context2, boolean fromSupertype) {
        LanguageVersionSettings languageVersionSettings2 = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        String fqNameAsString = annotationClassId.asFqNameString();
        if (languageVersionSettings2.getFlag(AnalysisFlags.getOptIn()).contains(fqNameAsString)) {
            return true;
        }
        for (FirAnnotationContainer annotationContainer : context2.getAnnotationContainers()) {
            if (!this.isExperimentalityAcceptable(annotationContainer, context2.getSession(), annotationClassId, fromSupertype)) continue;
            return true;
        }
        return false;
    }

    private final boolean isExperimentalityAcceptable(FirAnnotationContainer $this$isExperimentalityAcceptable, FirSession session2, ClassId annotationClassId, boolean fromSupertype) {
        return FirAnnotationUtilsKt.getAnnotationByClassId($this$isExperimentalityAcceptable, annotationClassId, session2) != null || this.isAnnotatedWithOptIn($this$isExperimentalityAcceptable, annotationClassId, session2) || fromSupertype && this.isAnnotatedWithSubclassOptInRequired($this$isExperimentalityAcceptable, session2, annotationClassId) || this.primaryConstructorParameterIsExperimentalityAcceptable($this$isExperimentalityAcceptable, session2, annotationClassId);
    }

    private final boolean primaryConstructorParameterIsExperimentalityAcceptable(FirAnnotationContainer $this$primaryConstructorParameterIsExperimentalityAcceptable, FirSession session2, ClassId annotationClassId) {
        if (!($this$primaryConstructorParameterIsExperimentalityAcceptable instanceof FirProperty)) {
            return false;
        }
        FirValueParameterSymbol firValueParameterSymbol = DeclarationAttributesKt.getCorrespondingValueParameterFromPrimaryConstructor((FirProperty)$this$primaryConstructorParameterIsExperimentalityAcceptable);
        if (firValueParameterSymbol == null) {
            return false;
        }
        FirValueParameterSymbol parameterSymbol = firValueParameterSymbol;
        return this.isExperimentalityAcceptable((FirAnnotationContainer)parameterSymbol.getFir(), session2, annotationClassId, false);
    }

    private final boolean isAnnotatedWithOptIn(FirAnnotationContainer $this$isAnnotatedWithOptIn, ClassId annotationClassId, FirSession session2) {
        for (FirAnnotation annotation2 : $this$isAnnotatedWithOptIn.getAnnotations()) {
            boolean bl;
            block4: {
                FirExpression annotationClasses;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(annotation2.getAnnotationTypeRef());
                ConeClassLikeType coneType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                Object object = coneType;
                if (!Intrinsics.areEqual(object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null, OptInNames.INSTANCE.getOPT_IN_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName(annotation2, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS()) == null) continue;
                Iterable $this$any$iv = FirAnnotationHelpersKt.extractClassesFromArgument(annotationClasses, session2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getClassId(), annotationClassId)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private final boolean isAnnotatedWithSubclassOptInRequired(FirAnnotationContainer $this$isAnnotatedWithSubclassOptInRequired, FirSession session2, ClassId annotationClassId) {
        for (FirAnnotation annotation2 : $this$isAnnotatedWithSubclassOptInRequired.getAnnotations()) {
            FirExpression annotationClass2;
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(annotation2.getAnnotationTypeRef());
            ConeClassLikeType coneType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
            Object object = coneType;
            if (!Intrinsics.areEqual(object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null, OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName(annotation2, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS()) == null) continue;
            FirRegularClassSymbol firRegularClassSymbol = FirAnnotationHelpersKt.extractClassFromArgument(annotationClass2, session2);
            if (!Intrinsics.areEqual(firRegularClassSymbol != null ? firRegularClassSymbol.getClassId() : null, annotationClassId)) continue;
            return true;
        }
        return false;
    }

    static {
        Name name2 = Name.identifier("level");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        LEVEL = name2;
        Name name3 = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        MESSAGE = name3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0002 !B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J?\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "severity", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "message", "", "supertypeName", "fromSupertype", "", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;Ljava/lang/String;Ljava/lang/String;Z)V", "getAnnotationClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getFromSupertype", "()Z", "getMessage", "()Ljava/lang/String;", "getSeverity", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "getSupertypeName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "Severity", "checkers"})
    public static final class Experimentality {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ClassId annotationClassId;
        @NotNull
        private final Severity severity;
        @Nullable
        private final String message;
        @Nullable
        private final String supertypeName;
        private final boolean fromSupertype;
        @NotNull
        private static final Severity DEFAULT_SEVERITY = Severity.ERROR;

        public Experimentality(@NotNull ClassId annotationClassId, @NotNull Severity severity, @Nullable String message2, @Nullable String supertypeName, boolean fromSupertype) {
            Intrinsics.checkNotNullParameter(annotationClassId, "annotationClassId");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            this.annotationClassId = annotationClassId;
            this.severity = severity;
            this.message = message2;
            this.supertypeName = supertypeName;
            this.fromSupertype = fromSupertype;
        }

        public /* synthetic */ Experimentality(ClassId classId, Severity severity, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(classId, severity, string2, string3, bl);
        }

        @NotNull
        public final ClassId getAnnotationClassId() {
            return this.annotationClassId;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getSupertypeName() {
            return this.supertypeName;
        }

        public final boolean getFromSupertype() {
            return this.fromSupertype;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Experimentality)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.annotationClassId, ((Experimentality)other).annotationClassId)) {
                return false;
            }
            if (this.severity != ((Experimentality)other).severity) {
                return false;
            }
            return Intrinsics.areEqual(this.message, ((Experimentality)other).message);
        }

        public int hashCode() {
            int result2 = this.annotationClassId.hashCode();
            result2 = 31 * result2 + this.severity.hashCode();
            String string2 = this.message;
            result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
            return result2;
        }

        @NotNull
        public final ClassId component1() {
            return this.annotationClassId;
        }

        @NotNull
        public final Severity component2() {
            return this.severity;
        }

        @Nullable
        public final String component3() {
            return this.message;
        }

        @Nullable
        public final String component4() {
            return this.supertypeName;
        }

        public final boolean component5() {
            return this.fromSupertype;
        }

        @NotNull
        public final Experimentality copy(@NotNull ClassId annotationClassId, @NotNull Severity severity, @Nullable String message2, @Nullable String supertypeName, boolean fromSupertype) {
            Intrinsics.checkNotNullParameter(annotationClassId, "annotationClassId");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            return new Experimentality(annotationClassId, severity, message2, supertypeName, fromSupertype);
        }

        public static /* synthetic */ Experimentality copy$default(Experimentality experimentality, ClassId classId, Severity severity, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                classId = experimentality.annotationClassId;
            }
            if ((n & 2) != 0) {
                severity = experimentality.severity;
            }
            if ((n & 4) != 0) {
                string2 = experimentality.message;
            }
            if ((n & 8) != 0) {
                string3 = experimentality.supertypeName;
            }
            if ((n & 0x10) != 0) {
                bl = experimentality.fromSupertype;
            }
            return experimentality.copy(classId, severity, string2, string3, bl);
        }

        @NotNull
        public String toString() {
            return "Experimentality(annotationClassId=" + this.annotationClassId + ", severity=" + (Object)((Object)this.severity) + ", message=" + this.message + ", supertypeName=" + this.supertypeName + ", fromSupertype=" + this.fromSupertype + ')';
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Companion;", "", "()V", "DEFAULT_SEVERITY", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "getDEFAULT_SEVERITY", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Severity getDEFAULT_SEVERITY() {
                return DEFAULT_SEVERITY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "", "(Ljava/lang/String;I)V", "WARNING", "ERROR", "checkers"})
        public static final class Severity
        extends Enum<Severity> {
            public static final /* enum */ Severity WARNING = new Severity();
            public static final /* enum */ Severity ERROR = new Severity();
            private static final /* synthetic */ Severity[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Severity[] values() {
                return (Severity[])$VALUES.clone();
            }

            public static Severity valueOf(String value2) {
                return Enum.valueOf(Severity.class, value2);
            }

            @NotNull
            public static EnumEntries<Severity> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = severityArray = new Severity[]{Severity.WARNING, Severity.ERROR};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Experimentality.Severity.values().length];
            try {
                nArray[Experimentality.Severity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Experimentality.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

