/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.WeakList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractProgressIndicatorExBase
extends AbstractProgressIndicatorBase
implements ProgressIndicatorEx {
    private final boolean myReusable;
    private volatile ProgressIndicatorEx @Nullable [] myStateDelegates;
    private volatile WeakList<TaskInfo> myFinished;
    private volatile boolean myWasStarted;
    private TaskInfo myOwnerTask;

    public AbstractProgressIndicatorExBase(boolean reusable) {
        this.myReusable = reusable;
    }

    public AbstractProgressIndicatorExBase() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.getLock();
        synchronized (object) {
            super.start();
            this.doDelegateRunningChange(ProgressIndicator::start);
            this.myWasStarted = true;
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.doDelegateRunningChange(ProgressIndicator::stop);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.doDelegateRunningChange(ProgressIndicator::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(@NotNull TaskInfo task) {
        WeakList<TaskInfo> finished;
        if (task == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(0);
        }
        if ((finished = this.myFinished) == null) {
            Object object = this.getLock();
            synchronized (object) {
                finished = this.myFinished;
                if (finished == null) {
                    this.myFinished = finished = new WeakList();
                }
            }
        }
        if (!finished.addIfAbsent(task)) {
            return;
        }
        this.doDelegateRunningChange(each -> each.finish(task));
    }

    @Override
    public boolean isFinished(@NotNull TaskInfo task) {
        WeakList<TaskInfo> list2;
        if (task == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(1);
        }
        return (list2 = this.myFinished) != null && list2.contains(task);
    }

    protected void setOwnerTask(TaskInfo owner) {
        this.myOwnerTask = owner;
    }

    @Override
    public void processFinish() {
        if (this.myOwnerTask != null) {
            this.finish(this.myOwnerTask);
            this.myOwnerTask = null;
        }
    }

    @Override
    public final void checkCanceled() {
        super.checkCanceled();
        this.delegate(ProgressIndicator::checkCanceled);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.delegateProgressChange(each -> each.setText(text));
    }

    @Override
    public void setText2(String text) {
        super.setText2(text);
        this.delegateProgressChange(each -> each.setText2(text));
    }

    @Override
    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.delegateProgressChange(each -> each.setFraction(fraction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushState() {
        Object object = this.getLock();
        synchronized (object) {
            super.pushState();
            this.delegateProgressChange(ProgressIndicator::pushState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popState() {
        Object object = this.getLock();
        synchronized (object) {
            super.popState();
            this.delegateProgressChange(ProgressIndicator::popState);
        }
    }

    @Override
    protected boolean isReuseable() {
        return this.myReusable;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.delegateProgressChange(each -> each.setIndeterminate(indeterminate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStateDelegate(@NotNull ProgressIndicatorEx delegate2) {
        if (delegate2 == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(2);
        }
        Object object = this.getLock();
        synchronized (object) {
            delegate2.initStateFrom(this);
            ProgressIndicatorEx[] stateDelegates = this.myStateDelegates;
            if (stateDelegates == null) {
                this.myStateDelegates = new ProgressIndicatorEx[]{delegate2};
            } else {
                if (ArrayUtil.contains(delegate2, stateDelegates)) {
                    throw new IllegalArgumentException("Already registered: " + delegate2);
                }
                this.myStateDelegates = ArrayUtil.append(stateDelegates, delegate2, ProgressIndicatorEx.class);
            }
        }
        this.onProgressChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeStateDelegate(@NotNull ProgressIndicatorEx delegate2) {
        if (delegate2 == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(3);
        }
        Object object = this.getLock();
        synchronized (object) {
            ProgressIndicatorEx[] delegates = this.myStateDelegates;
            if (delegates == null) {
                return;
            }
            this.myStateDelegates = ArrayUtil.remove(delegates, delegate2);
        }
        this.onProgressChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeAllStateDelegates() {
        Object object = this.getLock();
        synchronized (object) {
            this.myStateDelegates = null;
        }
    }

    private void delegateProgressChange(@NotNull IndicatorAction action) {
        if (action == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(4);
        }
        this.delegate(action);
        this.onProgressChange();
    }

    private void doDelegateRunningChange(@NotNull IndicatorAction action) {
        if (action == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(5);
        }
        this.delegate(action);
        this.onRunningChange();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    protected void delegateRunningChange(@NotNull IndicatorAction action) {
        if (action == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(6);
        }
    }

    private void delegate(@NotNull IndicatorAction action) {
        ProgressIndicatorEx[] list2;
        if (action == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(7);
        }
        if ((list2 = this.myStateDelegates) != null) {
            for (ProgressIndicatorEx each : list2) {
                action.execute(each);
            }
        }
    }

    @Override
    public void initStateFrom(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            AbstractProgressIndicatorExBase.$$$reportNull$$$0(8);
        }
        super.initStateFrom(indicator);
        this.delegate(it -> it.initStateFrom(this));
    }

    protected void onProgressChange() {
    }

    protected void onRunningChange() {
    }

    @Override
    public boolean wasStarted() {
        return this.myWasStarted;
    }

    @Override
    @NonNls
    public String toString() {
        return "ProgressIndicatorEx " + System.identityHashCode(this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled() + (this.isReuseable() ? "; reusable=true" : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/progress/util/AbstractProgressIndicatorExBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "finish";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFinished";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addStateDelegate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeStateDelegate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "delegateProgressChange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doDelegateRunningChange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "delegateRunningChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "delegate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "initStateFrom";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    protected static interface IndicatorAction {
        public void execute(@NotNull ProgressIndicatorEx var1);
    }
}

