/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;

public class MavenComparableVersion
implements Comparable<MavenComparableVersion> {
    private String value;
    private String canonical;
    private ListItem items;

    public MavenComparableVersion(String version) {
        this.parseVersion(version);
    }

    public final void parseVersion(String version) {
        this.value = version;
        this.items = new ListItem();
        version = version.toLowerCase(Locale.ENGLISH);
        ListItem list2 = this.items;
        Stack<ListItem> stack = new Stack<ListItem>();
        stack.push(list2);
        boolean isDigit = false;
        int startIndex = 0;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c == '.') {
                if (i == startIndex) {
                    list2.add(IntegerItem.ZERO);
                } else {
                    list2.add(MavenComparableVersion.parseItem(isDigit, version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                continue;
            }
            if (c == '-') {
                if (i == startIndex) {
                    list2.add(IntegerItem.ZERO);
                } else {
                    list2.add(MavenComparableVersion.parseItem(isDigit, version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                ListItem listItem = list2;
                list2 = new ListItem();
                listItem.add(list2);
                stack.push(list2);
                continue;
            }
            if (Character.isDigit(c)) {
                if (!isDigit && i > startIndex) {
                    list2.add(new StringItem(version.substring(startIndex, i), true));
                    startIndex = i;
                    ListItem listItem = list2;
                    list2 = new ListItem();
                    listItem.add(list2);
                    stack.push(list2);
                }
                isDigit = true;
                continue;
            }
            if (isDigit && i > startIndex) {
                list2.add(MavenComparableVersion.parseItem(true, version.substring(startIndex, i)));
                startIndex = i;
                ListItem listItem = list2;
                list2 = new ListItem();
                listItem.add(list2);
                stack.push(list2);
            }
            isDigit = false;
        }
        if (version.length() > startIndex) {
            list2.add(MavenComparableVersion.parseItem(isDigit, version.substring(startIndex)));
        }
        while (!stack.isEmpty()) {
            list2 = (ListItem)stack.pop();
            list2.normalize();
        }
        this.canonical = this.items.toString();
    }

    private static Item parseItem(boolean isDigit, String buf) {
        return isDigit ? new IntegerItem(buf) : new StringItem(buf, false);
    }

    @Override
    public int compareTo(MavenComparableVersion o) {
        return this.items.compareTo(o.items);
    }

    public String toString() {
        return this.value;
    }

    public String getCanonical() {
        return this.canonical;
    }

    public boolean equals(Object o) {
        return o instanceof MavenComparableVersion && this.canonical.equals(((MavenComparableVersion)o).canonical);
    }

    public int hashCode() {
        return this.canonical.hashCode();
    }

    public static void main(String ... args2) {
        System.out.println("Display parameters as parsed by Maven (in canonical form) and comparison result:");
        if (args2.length == 0) {
            return;
        }
        MavenComparableVersion prev = null;
        int i = 1;
        for (String version : args2) {
            MavenComparableVersion c = new MavenComparableVersion(version);
            if (prev != null) {
                int compare = prev.compareTo(c);
                System.out.println("   " + prev.toString() + ' ' + (compare == 0 ? "==" : (compare < 0 ? "<" : ">")) + ' ' + version);
            }
            System.out.println(String.valueOf(i++) + ". " + version + " == " + c.getCanonical());
            prev = c;
        }
    }

    private static class ListItem
    extends ArrayList<Item>
    implements Item {
        private ListItem() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public boolean isNull() {
            return this.size() == 0;
        }

        void normalize() {
            for (int i = this.size() - 1; i >= 0; --i) {
                Item lastItem = (Item)this.get(i);
                if (lastItem.isNull()) {
                    this.remove(i);
                    continue;
                }
                if (!(lastItem instanceof ListItem)) break;
            }
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                if (this.size() == 0) {
                    return 0;
                }
                Item first = (Item)this.get(0);
                return first.compareTo(null);
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    Iterator left = this.iterator();
                    Iterator right = ((ListItem)item).iterator();
                    while (left.hasNext() || right.hasNext()) {
                        Item r;
                        Item l = left.hasNext() ? (Item)left.next() : null;
                        Item item2 = r = right.hasNext() ? (Item)right.next() : null;
                        int result2 = l == null ? (r == null ? 0 : -1 * r.compareTo(l)) : l.compareTo(r);
                        if (result2 == 0) continue;
                        return result2;
                    }
                    return 0;
                }
            }
            throw new RuntimeException("invalid item: " + item.getClass());
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            for (Item item : this) {
                if (buffer.length() > 0) {
                    buffer.append(item instanceof ListItem ? (char)'-' : '.');
                }
                buffer.append(item);
            }
            return buffer.toString();
        }
    }

    private static class StringItem
    implements Item {
        private static final String[] QUALIFIERS = new String[]{"alpha", "beta", "milestone", "rc", "snapshot", "", "sp"};
        private static final List<String> _QUALIFIERS = Arrays.asList(QUALIFIERS);
        private static final Properties ALIASES = new Properties();
        private static final String RELEASE_VERSION_INDEX;
        private String value;

        public StringItem(String value2, boolean followedByDigit) {
            if (followedByDigit && value2.length() == 1) {
                switch (value2.charAt(0)) {
                    case 'a': {
                        value2 = "alpha";
                        break;
                    }
                    case 'b': {
                        value2 = "beta";
                        break;
                    }
                    case 'm': {
                        value2 = "milestone";
                        break;
                    }
                }
            }
            this.value = ALIASES.getProperty(value2, value2);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean isNull() {
            return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX) == 0;
        }

        public static String comparableQualifier(String qualifier2) {
            int i = _QUALIFIERS.indexOf(qualifier2);
            return i == -1 ? _QUALIFIERS.size() + "-" + qualifier2 : String.valueOf(i);
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX);
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return StringItem.comparableQualifier(this.value).compareTo(StringItem.comparableQualifier(((StringItem)item).value));
                }
                case 2: {
                    return -1;
                }
            }
            throw new RuntimeException("invalid item: " + item.getClass());
        }

        public String toString() {
            return this.value;
        }

        static {
            ALIASES.put("ga", "");
            ALIASES.put("final", "");
            ALIASES.put("cr", "rc");
            RELEASE_VERSION_INDEX = String.valueOf(_QUALIFIERS.indexOf(""));
        }
    }

    private static class IntegerItem
    implements Item {
        private static final BigInteger BIG_INTEGER_ZERO = new BigInteger("0");
        private final BigInteger value;
        public static final IntegerItem ZERO = new IntegerItem();

        private IntegerItem() {
            this.value = BIG_INTEGER_ZERO;
        }

        public IntegerItem(String str) {
            this.value = new BigInteger(str);
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public boolean isNull() {
            return BIG_INTEGER_ZERO.equals(this.value);
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return BIG_INTEGER_ZERO.equals(this.value) ? 0 : 1;
            }
            switch (item.getType()) {
                case 0: {
                    return this.value.compareTo(((IntegerItem)item).value);
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
            }
            throw new RuntimeException("invalid item: " + item.getClass());
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static interface Item {
        public static final int INTEGER_ITEM = 0;
        public static final int STRING_ITEM = 1;
        public static final int LIST_ITEM = 2;

        public int compareTo(Item var1);

        public int getType();

        public boolean isNull();
    }
}

