/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeAnnotationContainer {
    public static final TypeAnnotationContainer EMPTY = new TypeAnnotationContainer(Collections.emptyList());
    private final List<TypeAnnotationEntry> myList;

    private TypeAnnotationContainer(List<TypeAnnotationEntry> entries) {
        this.myList = entries;
    }

    @NotNull
    public TypeAnnotationContainer forArrayElement() {
        if (this.isEmpty()) {
            TypeAnnotationContainer typeAnnotationContainer = this;
            if (typeAnnotationContainer == null) {
                TypeAnnotationContainer.$$$reportNull$$$0(0);
            }
            return typeAnnotationContainer;
        }
        List<TypeAnnotationEntry> list2 = ContainerUtil.mapNotNull(this.myList, entry -> ((TypeAnnotationEntry)entry).forPathElement(0));
        return list2.isEmpty() ? EMPTY : new TypeAnnotationContainer(list2);
    }

    @NotNull
    public TypeAnnotationContainer forEnclosingClass() {
        if (this.isEmpty()) {
            TypeAnnotationContainer typeAnnotationContainer = this;
            if (typeAnnotationContainer == null) {
                TypeAnnotationContainer.$$$reportNull$$$0(1);
            }
            return typeAnnotationContainer;
        }
        List<TypeAnnotationEntry> list2 = ContainerUtil.mapNotNull(this.myList, entry -> ((TypeAnnotationEntry)entry).forPathElement(1));
        return list2.isEmpty() ? EMPTY : new TypeAnnotationContainer(list2);
    }

    @NotNull
    public TypeAnnotationContainer forBound() {
        if (this.isEmpty()) {
            TypeAnnotationContainer typeAnnotationContainer = this;
            if (typeAnnotationContainer == null) {
                TypeAnnotationContainer.$$$reportNull$$$0(2);
            }
            return typeAnnotationContainer;
        }
        List<TypeAnnotationEntry> list2 = ContainerUtil.mapNotNull(this.myList, entry -> ((TypeAnnotationEntry)entry).forPathElement(2));
        return list2.isEmpty() ? EMPTY : new TypeAnnotationContainer(list2);
    }

    @NotNull
    public TypeAnnotationContainer forTypeArgument(int index2) {
        if (this.isEmpty()) {
            TypeAnnotationContainer typeAnnotationContainer = this;
            if (typeAnnotationContainer == null) {
                TypeAnnotationContainer.$$$reportNull$$$0(3);
            }
            return typeAnnotationContainer;
        }
        List<TypeAnnotationEntry> list2 = ContainerUtil.mapNotNull(this.myList, e -> e.forTypeArgument(index2));
        return list2.isEmpty() ? EMPTY : new TypeAnnotationContainer(list2);
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    public TypeAnnotationProvider getProvider(final PsiElement parent2) {
        if (this.isEmpty()) {
            return TypeAnnotationProvider.EMPTY;
        }
        return new TypeAnnotationProvider(){

            @Override
            public PsiAnnotation @NotNull [] getAnnotations() {
                ArrayList<ClsTypeAnnotationImpl> result2 = new ArrayList<ClsTypeAnnotationImpl>();
                for (TypeAnnotationEntry entry : TypeAnnotationContainer.this.myList) {
                    if (entry.myPath.length != 0) continue;
                    ClsTypeAnnotationImpl anno = parent2 instanceof PsiCompiledElement ? new ClsTypeAnnotationImpl(parent2, entry.myText) : JavaPsiFacade.getElementFactory(parent2.getProject()).createAnnotationFromText(entry.myText, parent2);
                    result2.add(anno);
                }
                PsiAnnotation[] psiAnnotationArray = result2.toArray(PsiAnnotation.EMPTY_ARRAY);
                if (psiAnnotationArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiAnnotationArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeAnnotationContainer$1", "getAnnotations"));
            }
        };
    }

    public void createAnnotationStubs(StubElement<?> parent2) {
        for (TypeAnnotationEntry entry : this.myList) {
            if (entry.myPath.length != 0) continue;
            new PsiAnnotationStubImpl(parent2, entry.myText);
        }
    }

    public PsiType applyTo(PsiType type2, PsiElement context2) {
        PsiType modifiedComponentType;
        PsiType componentType;
        if (this.isEmpty()) {
            return type2;
        }
        if (type2 instanceof PsiArrayType && (componentType = ((PsiArrayType)type2).getComponentType()) != (modifiedComponentType = this.forArrayElement().applyTo(componentType, context2))) {
            type2 = type2 instanceof PsiEllipsisType ? new PsiEllipsisType(modifiedComponentType) : modifiedComponentType.createArrayType();
        }
        return type2.annotate(this.getProvider(context2));
    }

    public static void writeTypeAnnotations(@NotNull StubOutputStream dataStream, @NotNull TypeAnnotationContainer container2) throws IOException {
        if (dataStream == null) {
            TypeAnnotationContainer.$$$reportNull$$$0(4);
        }
        if (container2 == null) {
            TypeAnnotationContainer.$$$reportNull$$$0(5);
        }
        dataStream.writeShort(container2.myList.size());
        for (TypeAnnotationEntry entry : container2.myList) {
            dataStream.writeShort(entry.myPath.length);
            dataStream.write(entry.myPath);
            dataStream.writeUTFFast(entry.myText);
        }
    }

    @NotNull
    public static TypeAnnotationContainer readTypeAnnotations(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            TypeAnnotationContainer.$$$reportNull$$$0(6);
        }
        int count = dataStream.readShort();
        TypeAnnotationEntry[] entries = new TypeAnnotationEntry[count];
        for (int i = 0; i < count; ++i) {
            short pathLength = dataStream.readShort();
            byte[] path = new byte[pathLength];
            dataStream.readFully(path);
            String text = dataStream.readUTFFast();
            entries[i] = new TypeAnnotationEntry(path, text);
        }
        return new TypeAnnotationContainer(Arrays.asList(entries));
    }

    public String toString() {
        return StringUtil.join(this.myList, "\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/TypeAnnotationContainer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "forArrayElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forEnclosingClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forBound";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forTypeArgument";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/TypeAnnotationContainer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeTypeAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readTypeAnnotations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class ClsTypeAnnotationImpl
    extends ClsElementImpl
    implements PsiAnnotation {
        private final NotNullLazyValue<ClsJavaCodeReferenceElementImpl> myReferenceElement;
        private final NotNullLazyValue<ClsAnnotationParameterListImpl> myParameterList;
        private final PsiElement myParent;
        private final String myText;

        ClsTypeAnnotationImpl(PsiElement parent2, String text) {
            this.myParent = parent2;
            this.myText = text;
            this.myReferenceElement = NotNullLazyValue.atomicLazy(() -> {
                int index2 = this.myText.indexOf(40);
                String refText = index2 > 0 ? this.myText.substring(1, index2) : this.myText.substring(1);
                return new ClsJavaCodeReferenceElementImpl(this, refText);
            });
            this.myParameterList = NotNullLazyValue.atomicLazy(() -> {
                PsiNameValuePair[] attrs = this.myText.indexOf(40) > 0 ? JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText(this.myText, this.myParent).getParameterList().getAttributes() : PsiNameValuePair.EMPTY_ARRAY;
                return new ClsAnnotationParameterListImpl(this, attrs);
            });
        }

        @Override
        @NotNull
        public PsiAnnotationParameterList getParameterList() {
            PsiAnnotationParameterList psiAnnotationParameterList = this.myParameterList.getValue();
            if (psiAnnotationParameterList == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(0);
            }
            return psiAnnotationParameterList;
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return this.getNameReferenceElement().getCanonicalText();
        }

        @Override
        @NotNull
        public PsiJavaCodeReferenceElement getNameReferenceElement() {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = this.myReferenceElement.getValue();
            if (psiJavaCodeReferenceElement == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(1);
            }
            return psiJavaCodeReferenceElement;
        }

        @Override
        @Nullable
        public PsiAnnotationMemberValue findAttributeValue(@Nullable String attributeName) {
            return PsiImplUtil.findAttributeValue(this, attributeName);
        }

        @Override
        @Nullable
        public PsiAnnotationMemberValue findDeclaredAttributeValue(@Nullable String attributeName) {
            return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
        }

        @Override
        public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@Nullable String attributeName, @Nullable T value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public PsiAnnotationOwner getOwner() {
            return ObjectUtils.tryCast(this.myParent, PsiAnnotationOwner.class);
        }

        @Override
        public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
            if (buffer == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(2);
            }
            buffer.append(this.myText);
        }

        @Override
        public String getText() {
            return this.myText;
        }

        @Override
        public void setMirror(@NotNull TreeElement element2) throws ClsElementImpl.InvalidMirrorException {
            if (element2 == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(3);
            }
            this.setMirrorCheckingType(element2, null);
            PsiAnnotation mirror = (PsiAnnotation)SourceTreeToPsiMap.treeToPsiNotNull(element2);
            ClsTypeAnnotationImpl.setMirror(this.getNameReferenceElement(), mirror.getNameReferenceElement());
            ClsTypeAnnotationImpl.setMirror(this.getParameterList(), mirror.getParameterList());
        }

        @Override
        public PsiElement @NotNull [] getChildren() {
            PsiElement[] psiElementArray = new PsiElement[]{this.myReferenceElement.getValue(), this.getParameterList()};
            if (psiElementArray == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(4);
            }
            return psiElementArray;
        }

        @Override
        public PsiElement getParent() {
            return this.myParent;
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(5);
            }
            if (visitor2 instanceof JavaElementVisitor) {
                ((JavaElementVisitor)visitor2).visitAnnotation(this);
            } else {
                visitor2.visitElement(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/cache/TypeAnnotationContainer$ClsTypeAnnotationImpl";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameReferenceElement";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/cache/TypeAnnotationContainer$ClsTypeAnnotationImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "appendMirrorText";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setMirror";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TypeAnnotationEntry {
        final byte @NotNull [] myPath;
        @NotNull
        final String myText;

        private TypeAnnotationEntry(byte @NotNull [] path, @NotNull String text) {
            if (text == null) {
                TypeAnnotationEntry.$$$reportNull$$$0(0);
            }
            if (path == null) {
                TypeAnnotationEntry.$$$reportNull$$$0(1);
            }
            this.myPath = path;
            this.myText = text;
        }

        private TypeAnnotationEntry forPathElement(int wanted) {
            if (this.myPath.length > 0 && this.myPath[0] == wanted) {
                return new TypeAnnotationEntry(Arrays.copyOfRange(this.myPath, 1, this.myPath.length), this.myText);
            }
            return null;
        }

        public TypeAnnotationEntry forTypeArgument(int index2) {
            if (this.myPath.length > 1 && this.myPath[0] == 3 && this.myPath[1] == index2) {
                return new TypeAnnotationEntry(Arrays.copyOfRange(this.myPath, 2, this.myPath.length), this.myText);
            }
            return null;
        }

        public String toString() {
            StringBuilder result2 = new StringBuilder();
            block6: for (int pos = 0; pos < this.myPath.length; ++pos) {
                switch (this.myPath[pos]) {
                    case 0: {
                        result2.append('[');
                        continue block6;
                    }
                    case 1: {
                        result2.append('.');
                        continue block6;
                    }
                    case 2: {
                        result2.append('*');
                        continue block6;
                    }
                    case 3: {
                        result2.append(this.myPath[++pos]).append(';');
                    }
                }
            }
            return result2 + "->" + this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/cache/TypeAnnotationContainer$TypeAnnotationEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Collector {
        public static final byte ARRAY_ELEMENT = 0;
        public static final byte ENCLOSING_CLASS = 1;
        public static final byte WILDCARD_BOUND = 2;
        public static final byte TYPE_ARGUMENT = 3;
        @NotNull
        private final ArrayList<TypeAnnotationEntry> myList;
        @NotNull
        protected final TypeInfo myTypeInfo;

        public Collector(@NotNull TypeInfo info) {
            if (info == null) {
                Collector.$$$reportNull$$$0(0);
            }
            this.myList = new ArrayList();
            this.myTypeInfo = info;
        }

        public void add(byte @NotNull [] path, @NotNull String text) {
            if (text == null) {
                Collector.$$$reportNull$$$0(1);
            }
            if (path == null) {
                Collector.$$$reportNull$$$0(2);
            }
            this.myList.add(new TypeAnnotationEntry(path, text));
        }

        public void install() {
            if (this.myList.isEmpty()) {
                this.myTypeInfo.setTypeAnnotations(EMPTY);
            } else {
                this.myList.trimToSize();
                this.myTypeInfo.setTypeAnnotations(new TypeAnnotationContainer(this.myList));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/cache/TypeAnnotationContainer$Collector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

