/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCatchParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTryExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirCatchParameterChecker
extends FirExpressionChecker<FirTryExpression> {
    @NotNull
    public static final FirCatchParameterChecker INSTANCE = new FirCatchParameterChecker();

    private FirCatchParameterChecker() {
    }

    @Override
    public void check(@NotNull FirTryExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (FirCatch catchEntry : expression2.getCatches()) {
            FirSession session;
            KtSourceElement source;
            FirProperty catchParameter = catchEntry.getParameter();
            if (catchParameter.getSource() == null) continue;
            KtSourceElement ktSourceElement = catchParameter.getSource();
            if ((ktSourceElement != null ? FirHelpersKt.getDefaultValueForParameter(ktSourceElement) : null) != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCATCH_PARAMETER_WITH_DEFAULT_VALUE(), (DiagnosticContext)context2, null, 8, null);
            }
            if (FirKeywordUtilsKt.getValOrVarKeyword(source) != null) {
                KtKeywordToken it;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAL_OR_VAR_ON_CATCH_PARAMETER(), (Object)it, (DiagnosticContext)context2, null, 16, null);
            }
            ConeKotlinType coneType = FirTypeUtilsKt.getConeType(catchParameter.getReturnTypeRef());
            if (coneType instanceof ConeTypeParameterType) {
                boolean isReified = ((ConeTypeParameterType)coneType).getLookupTag().getTypeParameterSymbol().isReified();
                if (isReified) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREIFIED_TYPE_IN_CATCH_CLAUSE(), (DiagnosticContext)context2, null, 8, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getTYPE_PARAMETER_IN_CATCH_CLAUSE(), (DiagnosticContext)context2, null, 8, null);
                }
            }
            if (FirHelpersKt.isSubtypeOfThrowable(coneType, session = context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getTHROWABLE_TYPE_MISMATCH(), (Object)coneType, (Object)InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context2.getSession()), coneType, session.getBuiltinTypes().getThrowableType().getType()), (DiagnosticContext)context2, null, 32, null);
        }
    }
}

