/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J<\u0010\t\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\n*\u00060\u0004j\u0002`\u00052\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\fJ \u0010\u000e\u001a\u00020\u000f*\u00060\u0004j\u0002`\u00052\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\fJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\n*\b\u0012\u0004\u0012\u00020\u00120\nJ0\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\n*\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\n2\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\fR\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/diagnostics/UnreachableCodeLightTreeHelper;", "", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "Lorg/jetbrains/kotlin/diagnostics/Node;", "(Lcom/intellij/util/diff/FlyweightCapableTreeStructure;)V", "getTree", "()Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "getLeavesOrReachableChildren", "", "reachable", "", "unreachable", "hasChildrenInSet", "", "set", "mergeAdjacentTextRanges", "Lcom/intellij/openapi/util/TextRange;", "removeReachableElementsWithMeaninglessSiblings", "reachableElements", "frontend.common-psi"})
@SourceDebugExtension(value={"SMAP\nUnreachableCodeLightTreeHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnreachableCodeLightTreeHelper.kt\norg/jetbrains/kotlin/diagnostics/UnreachableCodeLightTreeHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n766#2:88\n857#2,2:89\n1789#2,3:91\n*S KotlinDebug\n*F\n+ 1 UnreachableCodeLightTreeHelper.kt\norg/jetbrains/kotlin/diagnostics/UnreachableCodeLightTreeHelper\n*L\n62#1:88\n62#1:89,2\n67#1:91,3\n*E\n"})
public final class UnreachableCodeLightTreeHelper {
    @NotNull
    private final FlyweightCapableTreeStructure<LighterASTNode> tree;

    public UnreachableCodeLightTreeHelper(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
        Intrinsics.checkNotNullParameter(tree, "tree");
        this.tree = tree;
    }

    @NotNull
    public final FlyweightCapableTreeStructure<LighterASTNode> getTree() {
        return this.tree;
    }

    public final boolean hasChildrenInSet(@NotNull LighterASTNode $this$hasChildrenInSet, @NotNull Set<? extends LighterASTNode> set) {
        Intrinsics.checkNotNullParameter($this$hasChildrenInSet, "<this>");
        Intrinsics.checkNotNullParameter(set, "set");
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        LightTreePositioningStrategiesKt.traverseDescendants(this.tree, $this$hasChildrenInSet, (Function1<? super LighterASTNode, Boolean>)new Function1<LighterASTNode, Boolean>(result2, $this$hasChildrenInSet, set){
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ LighterASTNode $this_hasChildrenInSet;
            final /* synthetic */ Set<LighterASTNode> $set;
            {
                this.$result = $result;
                this.$this_hasChildrenInSet = $receiver;
                this.$set = $set;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull LighterASTNode it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (!this.$result.element && !Intrinsics.areEqual(it, this.$this_hasChildrenInSet) && this.$set.contains(it)) {
                    this.$result.element = true;
                }
                return !this.$result.element;
            }
        });
        return result2.element;
    }

    @NotNull
    public final List<LighterASTNode> getLeavesOrReachableChildren(@NotNull LighterASTNode $this$getLeavesOrReachableChildren, @NotNull Set<? extends LighterASTNode> reachable, @NotNull Set<? extends LighterASTNode> unreachable) {
        Intrinsics.checkNotNullParameter($this$getLeavesOrReachableChildren, "<this>");
        Intrinsics.checkNotNullParameter(reachable, "reachable");
        Intrinsics.checkNotNullParameter(unreachable, "unreachable");
        List result2 = new ArrayList();
        LightTreePositioningStrategiesKt.traverseDescendants(this.tree, $this$getLeavesOrReachableChildren, (Function1<? super LighterASTNode, Boolean>)new Function1<LighterASTNode, Boolean>(reachable, this, unreachable, (List<LighterASTNode>)result2){
            final /* synthetic */ Set<LighterASTNode> $reachable;
            final /* synthetic */ UnreachableCodeLightTreeHelper this$0;
            final /* synthetic */ Set<LighterASTNode> $unreachable;
            final /* synthetic */ List<LighterASTNode> $result;
            {
                this.$reachable = $reachable;
                this.this$0 = $receiver;
                this.$unreachable = $unreachable;
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull LighterASTNode element2) {
                boolean bl;
                boolean isReachable2;
                Intrinsics.checkNotNullParameter(element2, "element");
                boolean bl2 = isReachable2 = this.$reachable.contains(element2) && !this.this$0.hasChildrenInSet(element2, this.$unreachable);
                if (isReachable2 || LightTreeUtilsKt.getChildren(element2, this.this$0.getTree()).isEmpty()) {
                    this.$result.add(element2);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        });
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LighterASTNode> removeReachableElementsWithMeaninglessSiblings(@NotNull List<? extends LighterASTNode> $this$removeReachableElementsWithMeaninglessSiblings, @NotNull Set<? extends LighterASTNode> reachableElements) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$removeReachableElementsWithMeaninglessSiblings, "<this>");
        Intrinsics.checkNotNullParameter(reachableElements, "reachableElements");
        Set childrenToRemove = new LinkedHashSet();
        Iterator<? extends LighterASTNode> iterator2 = $this$removeReachableElementsWithMeaninglessSiblings.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            LighterASTNode element2 = iterator2.next();
            if (!reachableElements.contains(element2)) continue;
            childrenToRemove.add(element2);
            UnreachableCodeLightTreeHelper.removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless($this$removeReachableElementsWithMeaninglessSiblings, childrenToRemove, index2, -1);
            UnreachableCodeLightTreeHelper.removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless($this$removeReachableElementsWithMeaninglessSiblings, childrenToRemove, index2, 1);
        }
        Iterable $this$filter$iv = $this$removeReachableElementsWithMeaninglessSiblings;
        boolean $i$f$filter = false;
        Iterable index2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LighterASTNode it = (LighterASTNode)element$iv$iv;
            boolean bl = false;
            if (!(!childrenToRemove.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> mergeAdjacentTextRanges(@NotNull List<? extends TextRange> $this$mergeAdjacentTextRanges) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$mergeAdjacentTextRanges, "<this>");
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        Iterable iterable = $this$mergeAdjacentTextRanges;
        TextRange initial$iv = null;
        boolean $i$f$fold = false;
        TextRange accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            TextRange textRange;
            void elementRange;
            TextRange textRange2 = (TextRange)element$iv;
            TextRange currentTextRange = accumulator$iv;
            boolean bl = false;
            if (currentTextRange == null) {
                textRange = elementRange;
            } else if (currentTextRange.getEndOffset() == elementRange.getStartOffset()) {
                textRange = currentTextRange.union((TextRange)elementRange);
            } else {
                result2.add(currentTextRange);
                textRange = elementRange;
            }
            accumulator$iv = textRange;
        }
        TextRange lastRange = accumulator$iv;
        if (lastRange != null) {
            result2.add(lastRange);
        }
        return result2;
    }

    private static final void removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless(List<? extends LighterASTNode> $this_removeReachableElementsWithMeaninglessSiblings, Set<LighterASTNode> childrenToRemove, int elementIndex, int direction) {
        int index2 = elementIndex + direction;
        if (!(0 <= index2 ? index2 < $this_removeReachableElementsWithMeaninglessSiblings.size() : false)) {
            return;
        }
        LighterASTNode element2 = $this_removeReachableElementsWithMeaninglessSiblings.get(index2);
        if (LightTreePositioningStrategyKt.isFiller(element2) || Intrinsics.areEqual(element2.getTokenType(), KtTokens.COMMA)) {
            childrenToRemove.add(element2);
            UnreachableCodeLightTreeHelper.removeReachableElementsWithMeaninglessSiblings$collectSiblingsIfMeaningless($this_removeReachableElementsWithMeaninglessSiblings, childrenToRemove, index2, direction);
        }
    }
}

