/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtilRt {
    @Contract(value="null,!null,_ -> false; !null,null,_ -> false; null,null,_ -> true")
    public static boolean equal(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean caseSensitive) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        if (caseSensitive) {
            for (int i = 0; i < s1.length(); ++i) {
                if (s1.charAt(i) == s2.charAt(i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < s1.length(); ++i) {
                if (StringUtilRt.charsEqualIgnoreCase(s1.charAt(i), s2.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || StringUtilRt.toUpperCase(a) == StringUtilRt.toUpperCase(b) || StringUtilRt.toLowerCase(a) == StringUtilRt.toLowerCase(b);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        if (a <= 'z') {
            return a >= 'A' && a <= 'Z' ? (char)(a + 32) : a;
        }
        return Character.toLowerCase(a);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(0);
        }
        return StringUtilRt.convertLineSeparators(text, false);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(1);
        }
        return StringUtilRt.convertLineSeparators(text, "\n", null, keepCarriageReturn);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(2);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(3);
        }
        return StringUtilRt.convertLineSeparators(text, newSeparator, null);
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence convertLineSeparators(@NotNull CharSequence text, @NotNull String newSeparator) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(4);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(5);
        }
        return StringUtilRt.unifyLineSeparators(text, newSeparator, null, false);
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(6);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(7);
        }
        return StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep, false);
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(8);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(9);
        }
        String string2 = StringUtilRt.unifyLineSeparators(text, newSeparator, offsetsToKeep, keepCarriageReturn).toString();
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    private static CharSequence unifyLineSeparators(@NotNull CharSequence text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(11);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(12);
        }
        StringBuilder buffer = null;
        int intactLength = 0;
        boolean newSeparatorIsSlashN = "\n".equals(newSeparator);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                if (!newSeparatorIsSlashN) {
                    if (buffer == null) {
                        buffer = new StringBuilder(text.length());
                        buffer.append(text, 0, intactLength);
                    }
                    buffer.append(newSeparator);
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                    continue;
                }
                if (buffer == null) {
                    ++intactLength;
                    continue;
                }
                buffer.append('\n');
                continue;
            }
            if (c == '\r') {
                boolean followedByLineFeed;
                boolean bl = followedByLineFeed = i < text.length() - 1 && text.charAt(i + 1) == '\n';
                if (!followedByLineFeed && keepCarriageReturn) {
                    if (buffer == null) {
                        ++intactLength;
                        continue;
                    }
                    buffer.append('\r');
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(text.length());
                    buffer.append(text, 0, intactLength);
                }
                buffer.append(newSeparator);
                if (followedByLineFeed) {
                    ++i;
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 2, newSeparator.length());
                    continue;
                }
                StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                continue;
            }
            if (buffer == null) {
                ++intactLength;
                continue;
            }
            buffer.append(c);
        }
        CharSequence charSequence = buffer == null ? text : buffer;
        if (charSequence == null) {
            StringUtilRt.$$$reportNull$$$0(13);
        }
        return charSequence;
    }

    private static void shiftOffsets(int[] offsets, int changeOffset, int oldLength, int newLength) {
        if (offsets == null) {
            return;
        }
        int shift = newLength - oldLength;
        if (shift == 0) {
            return;
        }
        for (int i = 0; i < offsets.length; ++i) {
            int offset = offsets[i];
            if (offset < changeOffset + oldLength) continue;
            int n = i;
            offsets[n] = offsets[n] + shift;
        }
    }

    @Contract(pure=true)
    public static int parseInt(@Nullable String string2, int defaultValue) {
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string2, long defaultValue) {
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Contract(pure=true)
    public static double parseDouble(@Nullable String string2, double defaultValue) {
        if (string2 != null) {
            try {
                return Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Contract(pure=true)
    static <E extends Enum<E>> E parseEnum(@NotNull String string2, E defaultValue, @NotNull Class<E> clazz) {
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(14);
        }
        if (clazz == null) {
            StringUtilRt.$$$reportNull$$$0(15);
        }
        try {
            return Enum.valueOf(clazz, string2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull Class<?> aClass) {
        if (aClass == null) {
            StringUtilRt.$$$reportNull$$$0(16);
        }
        return StringUtilRt.getShortName(aClass.getName());
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName2) {
        if (fqName2 == null) {
            StringUtilRt.$$$reportNull$$$0(17);
        }
        return StringUtilRt.getShortName(fqName2, '.');
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName2, char separator) {
        int lastPointIdx;
        if (fqName2 == null) {
            StringUtilRt.$$$reportNull$$$0(18);
        }
        if ((lastPointIdx = fqName2.lastIndexOf(separator)) >= 0) {
            String string2 = fqName2.substring(lastPointIdx + 1);
            if (string2 == null) {
                StringUtilRt.$$$reportNull$$$0(19);
            }
            return string2;
        }
        String string3 = fqName2;
        if (string3 == null) {
            StringUtilRt.$$$reportNull$$$0(20);
        }
        return string3;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return s != null && s.length() != 0 && s.charAt(s.length() - 1) == suffix;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(21);
        }
        if (suffix == null) {
            StringUtilRt.$$$reportNull$$$0(22);
        }
        if ((l1 = text.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        if (str == null) {
            StringUtilRt.$$$reportNull$$$0(23);
        }
        if (prefix == null) {
            StringUtilRt.$$$reportNull$$$0(24);
        }
        return StringUtilRt.startsWithIgnoreCase(str, 0, prefix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, int startOffset, @NotNull String prefix) {
        int prefixLength;
        int stringLength;
        if (str == null) {
            StringUtilRt.$$$reportNull$$$0(25);
        }
        if (prefix == null) {
            StringUtilRt.$$$reportNull$$$0(26);
        }
        return (stringLength = str.length()) >= (prefixLength = prefix.length()) && str.regionMatches(true, startOffset, prefix, 0, prefixLength);
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(27);
        }
        if (suffix == null) {
            StringUtilRt.$$$reportNull$$$0(28);
        }
        if ((l1 = text.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (StringUtilRt.charsEqualIgnoreCase(text.charAt(i), suffix.charAt(i + l2 - l1))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(29);
        }
        start = Math.max(start, 0);
        for (int i = Math.min(end, s.length()) - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        if (StringUtilRt.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s) {
        return StringUtilRt.notNullize(s, "");
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtilRt.$$$reportNull$$$0(30);
        }
        String string2 = s == null ? defaultValue : s;
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(31);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(32);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuilder builder2 = new StringBuilder(s.length());
        boolean inQuotes = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separator && !inQuotes) {
                if (builder2.length() <= 0) continue;
                result2.add(builder2.toString());
                builder2.setLength(0);
                continue;
            }
            if (!(c != '\"' && c != '\'' || i > 0 && s.charAt(i - 1) == '\\')) {
                inQuotes = !inQuotes;
            }
            builder2.append(c);
        }
        if (builder2.length() > 0) {
            result2.add(builder2.toString());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            StringUtilRt.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize) {
        return StringUtilRt.formatFileSize(fileSize, " ");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize, @NotNull String string2) {
        void unitSeparator;
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(34);
        }
        if (fileSize < 0L) {
            throw new IllegalArgumentException("Invalid value: " + fileSize);
        }
        if (fileSize == 0L) {
            String string3 = '0' + (String)unitSeparator + 'B';
            if (string3 == null) {
                StringUtilRt.$$$reportNull$$$0(35);
            }
            return string3;
        }
        int rank = (int)((Math.log10(fileSize) + 2.1714778384307465E-6) / 3.0);
        double value2 = (double)fileSize / Math.pow(1000.0, rank);
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB"};
        String string4 = new DecimalFormat("0.##").format(value2) + (String)unitSeparator + units[rank];
        if (string4 == null) {
            StringUtilRt.$$$reportNull$$$0(36);
        }
        return string4;
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(37);
        }
        return s.length() > 1 && (s.charAt(0) == '\'' || s.charAt(0) == '\"') && s.charAt(0) == s.charAt(s.length() - 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(38);
        }
        String string2 = StringUtilRt.isQuotedString(s) ? s.substring(1, s.length() - 1) : s;
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(39);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s, char quotationChar) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(40);
        }
        boolean quoted = s.length() > 1 && quotationChar == s.charAt(0) && quotationChar == s.charAt(s.length() - 1);
        String string2 = quoted ? s.substring(1, s.length() - 1) : s;
        if (string2 == null) {
            StringUtilRt.$$$reportNull$$$0(41);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, @NotNull CharSequence prefix) {
        int l2;
        int l1;
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(42);
        }
        if (prefix == null) {
            StringUtilRt.$$$reportNull$$$0(43);
        }
        if ((l1 = text.length()) < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtilRt.$$$reportNull$$$0(44);
        }
        return StringUtilRt.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtilRt.$$$reportNull$$$0(45);
        }
        return StringUtilRt.stringHashCodeInsensitive(chars, from, to, 0);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        if (chars == null) {
            StringUtilRt.$$$reportNull$$$0(46);
        }
        int h = prefixHash;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtilRt.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 41: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtilRt";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 24: 
            case 26: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 29: 
            case 32: 
            case 37: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtilRt";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyLineSeparators";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 39: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 41: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unifyLineSeparators";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 38: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 41: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

