/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.signaturer;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.FirMangler;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.signaturer.FirManglerUtilKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002,-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\tH\u0002J$\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J&\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u0012J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0019J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u001aJ$\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u000eJ\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0006\u0010\u0016\u001a\u00020\u001cH\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u001cH\u0002J\u0014\u0010&\u001a\u00020'*\u00020\u001c2\u0006\u0010(\u001a\u00020\nH\u0002J\f\u0010)\u001a\u00020**\u00020\u0010H\u0002J\f\u0010+\u001a\u00020**\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "", "mangler", "Lorg/jetbrains/kotlin/fir/backend/FirMangler;", "(Lorg/jetbrains/kotlin/fir/backend/FirMangler;)V", "getMangler", "()Lorg/jetbrains/kotlin/fir/backend/FirMangler;", "signatureCache", "", "Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$FirDeclarationWithParentId;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "calculatePublicSignature", "declarationWithParentId", "composeAccessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isSetter", "", "containingClass", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "composeSignature", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "forceExpect", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "composeSignatureImpl", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "composeTypeParameterSignature", "index", "", "containerSignature", "computeSignatureHashAndDescriptionFor", "Lkotlin/Pair;", "", "", "isTopLevelPrivate", "fakeFileSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "commonSignature", "getterOrDefault", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "setterOrDefault", "FirDeclarationWithParentId", "SignatureBuilder", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFirBasedSignatureComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBasedSignatureComposer.kt\norg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,264:1\n1#2:265\n21#3:266\n21#3:274\n21#3:275\n21#3:276\n372#4,7:267\n*S KotlinDebug\n*F\n+ 1 FirBasedSignatureComposer.kt\norg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer\n*L\n107#1:266\n239#1:274\n252#1:275\n259#1:276\n112#1:267,7\n*E\n"})
public final class FirBasedSignatureComposer {
    @NotNull
    private final FirMangler mangler;
    @NotNull
    private final Map<FirDeclarationWithParentId, IdSignature.CommonSignature> signatureCache;

    public FirBasedSignatureComposer(@NotNull FirMangler mangler) {
        Intrinsics.checkNotNullParameter(mangler, "mangler");
        this.mangler = mangler;
        this.signatureCache = new LinkedHashMap();
    }

    @NotNull
    public final FirMangler getMangler() {
        return this.mangler;
    }

    private final Pair<Long, String> computeSignatureHashAndDescriptionFor(FirDeclaration declaration2) {
        FirMangler $this$computeSignatureHashAndDescriptionFor_u24lambda_u241 = this.mangler;
        boolean bl = false;
        String it = $this$computeSignatureHashAndDescriptionFor_u24lambda_u241.signatureString(declaration2, false);
        boolean bl2 = false;
        return TuplesKt.to($this$computeSignatureHashAndDescriptionFor_u24lambda_u241.getHashMangle(it), it);
    }

    @Nullable
    public final IdSignature composeSignature(@NotNull FirClassLikeDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return this.composeSignatureImpl(declaration2, null, false);
    }

    @Nullable
    public final IdSignature composeSignature(@NotNull FirCallableDeclaration declaration2, @Nullable ConeClassLikeLookupTag containingClass, boolean forceExpect) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return this.composeSignatureImpl(declaration2, containingClass, forceExpect);
    }

    public static /* synthetic */ IdSignature composeSignature$default(FirBasedSignatureComposer firBasedSignatureComposer, FirCallableDeclaration firCallableDeclaration, ConeClassLikeLookupTag coneClassLikeLookupTag, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            coneClassLikeLookupTag = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return firBasedSignatureComposer.composeSignature(firCallableDeclaration, coneClassLikeLookupTag, bl);
    }

    @Nullable
    public final IdSignature composeSignature(@NotNull FirScript declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return this.composeSignatureImpl(declaration2, null, false);
    }

    @Nullable
    public final IdSignature composeTypeParameterSignature(int index2, @Nullable IdSignature containerSignature) {
        if (containerSignature == null) {
            return null;
        }
        return new IdSignature.CompositeSignature(containerSignature, new IdSignature.LocalSignature("<TP>", Long.valueOf(index2), null));
    }

    @Nullable
    public final IdSignature composeAccessorSignature(@NotNull FirProperty property, boolean isSetter, @Nullable ConeClassLikeLookupTag containingClass) {
        Intrinsics.checkNotNullParameter(property, "property");
        IdSignature.CommonSignature propSig = null;
        IdSignature.FileSignature fileSig = null;
        IdSignature propertySignature = FirBasedSignatureComposer.composeSignature$default(this, property, containingClass, false, 4, null);
        if (propertySignature instanceof IdSignature.CompositeSignature) {
            IdSignature idSignature = ((IdSignature.CompositeSignature)propertySignature).getInner();
            IdSignature.CommonSignature commonSignature = idSignature instanceof IdSignature.CommonSignature ? (IdSignature.CommonSignature)idSignature : null;
            if (commonSignature == null) {
                return null;
            }
            propSig = commonSignature;
            idSignature = ((IdSignature.CompositeSignature)propertySignature).getContainer();
            IdSignature.FileSignature fileSignature = idSignature instanceof IdSignature.FileSignature ? (IdSignature.FileSignature)idSignature : null;
            if (fileSignature == null) {
                return null;
            }
            fileSig = fileSignature;
        } else if (propertySignature instanceof IdSignature.CommonSignature) {
            propSig = (IdSignature.CommonSignature)propertySignature;
            fileSig = null;
        } else {
            return null;
        }
        FirPropertyAccessor accessor = isSetter ? this.setterOrDefault(property) : this.getterOrDefault(property);
        Pair<Long, String> pair = this.computeSignatureHashAndDescriptionFor(accessor);
        long id = ((Number)pair.component1()).longValue();
        String description2 = pair.component2();
        String accessorFqName = propSig.getDeclarationFqName() + '.' + FirManglerUtilKt.getIrName(accessor);
        IdSignature.CommonSignature commonSig = new IdSignature.CommonSignature(propSig.getPackageFqName(), accessorFqName, id, propSig.getMask(), description2);
        IdSignature.AccessorSignature accessorSig = new IdSignature.AccessorSignature(propSig, commonSig);
        return fileSig != null ? (IdSignature)new IdSignature.CompositeSignature(fileSig, accessorSig) : (IdSignature)accessorSig;
    }

    public static /* synthetic */ IdSignature composeAccessorSignature$default(FirBasedSignatureComposer firBasedSignatureComposer, FirProperty firProperty, boolean bl, ConeClassLikeLookupTag coneClassLikeLookupTag, int n, Object object) {
        if ((n & 4) != 0) {
            coneClassLikeLookupTag = null;
        }
        return firBasedSignatureComposer.composeAccessorSignature(firProperty, bl, coneClassLikeLookupTag);
    }

    private final IdSignature composeSignatureImpl(FirDeclaration declaration2, ConeClassLikeLookupTag containingClass, boolean forceExpect) {
        IdSignature idSignature;
        IdSignature.CommonSignature commonSignature;
        block10: {
            block11: {
                if (declaration2 instanceof FirAnonymousObject || declaration2 instanceof FirAnonymousFunction) {
                    return null;
                }
                if (declaration2 instanceof FirRegularClass && FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)declaration2).isLocal()) {
                    return null;
                }
                if (!(declaration2 instanceof FirCallableDeclaration)) break block10;
                FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration2;
                boolean $i$f$getVisibility = false;
                if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE)) {
                    return null;
                }
                Object object = ClassMembersKt.dispatchReceiverClassLookupTagOrNull((FirCallableDeclaration)declaration2);
                if (object != null && (object = ((ConeClassLikeLookupTag)object).getClassId()) != null ? ((ClassId)object).isLocal() : false) break block11;
                Object object2 = containingClass;
                boolean bl = object2 != null && (object2 = ((ConeClassLikeLookupTag)object2).getClassId()) != null ? ((ClassId)object2).isLocal() : false;
                if (!bl) break block10;
            }
            return null;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = containingClass;
        FirDeclarationWithParentId declarationWithParentId = new FirDeclarationWithParentId(declaration2, coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null, forceExpect);
        Map<FirDeclarationWithParentId, IdSignature.CommonSignature> $this$getOrPut$iv = this.signatureCache;
        boolean $i$f$getOrPut = false;
        IdSignature.CommonSignature value$iv = $this$getOrPut$iv.get(declarationWithParentId);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature.CommonSignature answer$iv = this.calculatePublicSignature(declarationWithParentId);
            $this$getOrPut$iv.put(declarationWithParentId, answer$iv);
            commonSignature = answer$iv;
        } else {
            commonSignature = value$iv;
        }
        IdSignature.CommonSignature publicSignature = commonSignature;
        if (this.isTopLevelPrivate(declaration2)) {
            IdSignature.FileSignature fileSig = this.fakeFileSignature(declaration2, publicSignature);
            idSignature = new IdSignature.CompositeSignature(fileSig, publicSignature);
        } else {
            idSignature = publicSignature;
        }
        IdSignature resultSignature = idSignature;
        return resultSignature;
    }

    private final IdSignature.CommonSignature calculatePublicSignature(FirDeclarationWithParentId declarationWithParentId) {
        IdSignature.CommonSignature commonSignature;
        FirDeclaration declaration2 = declarationWithParentId.component1();
        ClassId containingClassId = declarationWithParentId.component2();
        SignatureBuilder builder2 = new SignatureBuilder(declarationWithParentId.getForceExpect());
        try {
            declaration2.accept(builder2, null);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error while composing signature for " + UtilsKt.render(declaration2), t);
        }
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirRegularClass) {
            ClassId classId = FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)declaration2);
            String string2 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String string3 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
            commonSignature = new IdSignature.CommonSignature(string2, string3, builder2.getHashId(), builder2.getMask(), builder2.getDescription());
        } else if (firDeclaration instanceof FirTypeAlias) {
            ClassId classId = ((FirTypeAlias)declaration2).getSymbol().getClassId();
            String string4 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string4, "asString(...)");
            String string5 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue(string5, "asString(...)");
            commonSignature = new IdSignature.CommonSignature(string4, string5, builder2.getHashId(), builder2.getMask(), builder2.getDescription());
        } else if (firDeclaration instanceof FirCallableDeclaration) {
            ClassId classId;
            Object object;
            ClassId classId2 = containingClassId;
            if (classId2 == null) {
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableDeclaration)declaration2);
                classId2 = coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null;
            }
            if ((object = (classId = classId2)) == null || (object = ((ClassId)object).getPackageFqName()) == null) {
                object = ((FirCallableDeclaration)declaration2).getSymbol().getCallableId().getPackageName();
            }
            Object object2 = object;
            Intrinsics.checkNotNull(object2);
            Object packageName2 = object2;
            Name callableName = FirManglerUtilKt.getIrName((FirCallableDeclaration)declaration2);
            String string6 = ((FqName)packageName2).asString();
            Intrinsics.checkNotNullExpressionValue(string6, "asString(...)");
            Object object3 = classId;
            if (object3 == null || (object3 = ((ClassId)object3).getRelativeClassName()) == null || (object3 = ((FqName)object3).child(callableName)) == null || (object3 = ((FqName)object3).asString()) == null) {
                object3 = callableName.asString();
            }
            Object object4 = object3;
            Intrinsics.checkNotNull(object4);
            IdSignature.CommonSignature commonSignature2 = new IdSignature.CommonSignature(string6, (String)object4, builder2.getHashId(), builder2.getMask(), builder2.getDescription());
            commonSignature = commonSignature2;
        } else if (firDeclaration instanceof FirScript) {
            String string7 = ((FirScript)declaration2).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string7, "asString(...)");
            String string8 = ((FirScript)declaration2).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string8, "asString(...)");
            commonSignature = new IdSignature.CommonSignature(string7, string8, builder2.getHashId(), builder2.getMask(), builder2.getDescription());
        } else {
            throw new IllegalStateException(("Unsupported FIR declaration in signature composer: " + UtilsKt.render(declaration2)).toString());
        }
        return commonSignature;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTopLevelPrivate(FirDeclaration declaration2) {
        if (FirVisibilityCheckerKt.getOwnerLookupTag(declaration2.getSymbol()) != null) return false;
        if (!(declaration2 instanceof FirMemberDeclaration)) return false;
        FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration2;
        boolean $i$f$getVisibility = false;
        if (!Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) return false;
        return true;
    }

    private final IdSignature.FileSignature fakeFileSignature(FirDeclaration $this$fakeFileSignature, IdSignature.CommonSignature commonSignature) {
        return new IdSignature.FileSignature($this$fakeFileSignature, new FqName(commonSignature.getPackageFqName() + '.' + commonSignature.getDeclarationFqName()), "<unknown>");
    }

    private final FirPropertyAccessor getterOrDefault(FirProperty $this$getterOrDefault) {
        FirPropertyAccessor firPropertyAccessor = $this$getterOrDefault.getGetter();
        if (firPropertyAccessor == null) {
            FirMemberDeclaration $this$visibility$iv = $this$getterOrDefault;
            boolean $i$f$getVisibility = false;
            firPropertyAccessor = new FirDefaultPropertyGetter(null, $this$getterOrDefault.getModuleData(), $this$getterOrDefault.getOrigin(), $this$getterOrDefault.getReturnTypeRef(), $this$visibility$iv.getStatus().getVisibility(), $this$getterOrDefault.getSymbol(), null, null, null, null, 960, null);
        }
        return firPropertyAccessor;
    }

    private final FirPropertyAccessor setterOrDefault(FirProperty $this$setterOrDefault) {
        FirPropertyAccessor firPropertyAccessor = $this$setterOrDefault.getSetter();
        if (firPropertyAccessor == null) {
            FirMemberDeclaration $this$visibility$iv = $this$setterOrDefault;
            boolean $i$f$getVisibility = false;
            firPropertyAccessor = new FirDefaultPropertySetter(null, $this$setterOrDefault.getModuleData(), $this$setterOrDefault.getOrigin(), $this$setterOrDefault.getReturnTypeRef(), $this$visibility$iv.getStatus().getVisibility(), $this$setterOrDefault.getSymbol(), null, null, null, null, null, 1984, null);
        }
        return firPropertyAccessor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$FirDeclarationWithParentId;", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "forceExpect", "", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/name/ClassId;Z)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getDeclaration", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getForceExpect", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "fir2ir"})
    private static final class FirDeclarationWithParentId {
        @NotNull
        private final FirDeclaration declaration;
        @Nullable
        private final ClassId classId;
        private final boolean forceExpect;

        public FirDeclarationWithParentId(@NotNull FirDeclaration declaration2, @Nullable ClassId classId, boolean forceExpect) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            this.declaration = declaration2;
            this.classId = classId;
            this.forceExpect = forceExpect;
        }

        @NotNull
        public final FirDeclaration getDeclaration() {
            return this.declaration;
        }

        @Nullable
        public final ClassId getClassId() {
            return this.classId;
        }

        public final boolean getForceExpect() {
            return this.forceExpect;
        }

        @NotNull
        public final FirDeclaration component1() {
            return this.declaration;
        }

        @Nullable
        public final ClassId component2() {
            return this.classId;
        }

        public final boolean component3() {
            return this.forceExpect;
        }

        @NotNull
        public final FirDeclarationWithParentId copy(@NotNull FirDeclaration declaration2, @Nullable ClassId classId, boolean forceExpect) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            return new FirDeclarationWithParentId(declaration2, classId, forceExpect);
        }

        public static /* synthetic */ FirDeclarationWithParentId copy$default(FirDeclarationWithParentId firDeclarationWithParentId, FirDeclaration firDeclaration, ClassId classId, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                firDeclaration = firDeclarationWithParentId.declaration;
            }
            if ((n & 2) != 0) {
                classId = firDeclarationWithParentId.classId;
            }
            if ((n & 4) != 0) {
                bl = firDeclarationWithParentId.forceExpect;
            }
            return firDeclarationWithParentId.copy(firDeclaration, classId, bl);
        }

        @NotNull
        public String toString() {
            return "FirDeclarationWithParentId(declaration=" + this.declaration + ", classId=" + this.classId + ", forceExpect=" + this.forceExpect + ')';
        }

        public int hashCode() {
            int result2 = this.declaration.hashCode();
            result2 = result2 * 31 + (this.classId == null ? 0 : this.classId.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.forceExpect);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FirDeclarationWithParentId)) {
                return false;
            }
            FirDeclarationWithParentId firDeclarationWithParentId = (FirDeclarationWithParentId)other;
            if (!Intrinsics.areEqual(this.declaration, firDeclarationWithParentId.declaration)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.classId, firDeclarationWithParentId.classId)) {
                return false;
            }
            return this.forceExpect == firDeclarationWithParentId.forceExpect;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$2\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'2\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u0002002\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u0002032\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u0002092\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$SignatureBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "", "forceExpect", "", "(Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;Z)V", "description", "", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "hashId", "", "getHashId", "()Ljava/lang/Long;", "setHashId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "mask", "getMask", "()J", "setMask", "(J)V", "setExpected", "f", "setHashAndDescriptionFor", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitScript", "script", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "fir2ir"})
    @SourceDebugExtension(value={"SMAP\nFirBasedSignatureComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBasedSignatureComposer.kt\norg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$SignatureBuilder\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,264:1\n37#2:265\n37#2:266\n37#2:267\n37#2:268\n37#2:269\n37#2:270\n37#2:271\n*S KotlinDebug\n*F\n+ 1 FirBasedSignatureComposer.kt\norg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$SignatureBuilder\n*L\n202#1:265\n210#1:266\n215#1:267\n220#1:268\n225#1:269\n230#1:270\n234#1:271\n*E\n"})
    private final class SignatureBuilder
    extends FirVisitor<Unit, Object> {
        private final boolean forceExpect;
        @Nullable
        private Long hashId;
        @Nullable
        private String description;
        private long mask;

        public SignatureBuilder(boolean forceExpect) {
            this.forceExpect = forceExpect;
        }

        @Nullable
        public final Long getHashId() {
            return this.hashId;
        }

        public final void setHashId(@Nullable Long l) {
            this.hashId = l;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable String string2) {
            this.description = string2;
        }

        public final long getMask() {
            return this.mask;
        }

        public final void setMask(long l) {
            this.mask = l;
        }

        private final void setHashAndDescriptionFor(FirDeclaration declaration2) {
            Pair it = FirBasedSignatureComposer.this.computeSignatureHashAndDescriptionFor(declaration2);
            boolean bl = false;
            this.hashId = (Long)it.getFirst();
            this.description = (String)it.getSecond();
        }

        private final void setExpected(boolean f) {
            this.mask |= IdSignature.Flags.IS_EXPECT.encode(f || this.forceExpect);
        }

        @Override
        public void visitElement(@NotNull FirElement element2, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(element2, "element");
            String string2 = "Should not be here";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            FirMemberDeclaration $this$isExpect$iv = regularClass;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitScript(@NotNull FirScript script, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(script, "script");
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            FirMemberDeclaration $this$isExpect$iv = typeAlias;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(constructor2, "constructor");
            this.setHashAndDescriptionFor(constructor2);
            FirMemberDeclaration $this$isExpect$iv = constructor2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            this.setHashAndDescriptionFor(simpleFunction);
            FirMemberDeclaration $this$isExpect$iv = simpleFunction;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitProperty(@NotNull FirProperty property, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(property, "property");
            this.setHashAndDescriptionFor(property);
            FirMemberDeclaration $this$isExpect$iv = property;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitField(@NotNull FirField field, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(field, "field");
            this.setHashAndDescriptionFor(field);
            FirMemberDeclaration $this$isExpect$iv = field;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Object data2) {
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            FirMemberDeclaration $this$isExpect$iv = enumEntry;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }
    }
}

