/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PersistentRangeMarker
extends RangeMarkerImpl {
    @NotNull
    private LinesCols myLinesCols;
    private volatile boolean documentLoaded;

    PersistentRangeMarker(@NotNull DocumentEx document2, int startOffset, int endOffset, boolean register) {
        if (document2 == null) {
            PersistentRangeMarker.$$$reportNull$$$0(0);
        }
        super(document2, startOffset, endOffset, register, false);
        this.myLinesCols = Objects.requireNonNull(PersistentRangeMarker.storeLinesAndCols(document2, this.getStartOffset(), this.getEndOffset()));
        this.documentLoaded = true;
    }

    PersistentRangeMarker(@NotNull VirtualFile virtualFile, int startOffset, int endOffset, int startLine, int startCol, int endLine, int endCol, boolean register) {
        if (virtualFile == null) {
            PersistentRangeMarker.$$$reportNull$$$0(1);
        }
        super(virtualFile, startOffset, endOffset, register);
        this.myLinesCols = new LinesCols(startLine, startCol, endLine, endCol);
        this.documentLoaded = FileDocumentManager.getInstance().getCachedDocument(virtualFile) != null;
    }

    @Nullable
    static LinesCols storeLinesAndCols(@NotNull Document myDocument, int startOffset, int endOffset) {
        if (myDocument == null) {
            PersistentRangeMarker.$$$reportNull$$$0(2);
        }
        LineCol start = PersistentRangeMarker.calcLineCol(myDocument, startOffset);
        LineCol end = PersistentRangeMarker.calcLineCol(myDocument, endOffset);
        if (start == null || end == null) {
            return null;
        }
        return new LinesCols(start.line, start.col, end.line, end.col);
    }

    private static LineCol calcLineCol(@NotNull Document document2, int offset) {
        if (document2 == null) {
            PersistentRangeMarker.$$$reportNull$$$0(3);
        }
        if (offset <= document2.getTextLength()) {
            int line = document2.getLineNumber(offset);
            int col = offset - document2.getLineStartOffset(line);
            if (col < 0) {
                return null;
            }
            return new LineCol(line, col);
        }
        return null;
    }

    @Nullable
    static Pair.NonNull<TextRange, LinesCols> translateViaDiff(@NotNull DocumentEventImpl event, @NotNull LinesCols linesCols) {
        if (event == null) {
            PersistentRangeMarker.$$$reportNull$$$0(4);
        }
        if (linesCols == null) {
            PersistentRangeMarker.$$$reportNull$$$0(5);
        }
        try {
            int myStartLine = event.translateLineViaDiffStrict(linesCols.myStartLine);
            Document document2 = event.getDocument();
            if (myStartLine < 0 || myStartLine >= document2.getLineCount()) {
                return null;
            }
            int start = document2.getLineStartOffset(myStartLine) + linesCols.myStartColumn;
            if (start >= document2.getTextLength()) {
                return null;
            }
            int myEndLine = event.translateLineViaDiffStrict(linesCols.myEndLine);
            if (myEndLine < 0 || myEndLine >= document2.getLineCount()) {
                return null;
            }
            int end = document2.getLineStartOffset(myEndLine) + linesCols.myEndColumn;
            if (end > document2.getTextLength() || end < start) {
                return null;
            }
            if (end > event.getDocument().getTextLength() || myEndLine < myStartLine || myStartLine == myEndLine && linesCols.myEndColumn < linesCols.myStartColumn || event.getDocument().getLineCount() < myEndLine) {
                return null;
            }
            return Pair.createNonNull(new TextRange(start, end), new LinesCols(myStartLine, linesCols.myStartColumn, myEndLine, linesCols.myEndColumn));
        }
        catch (FilesTooBigForDiffException e) {
            return null;
        }
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            PersistentRangeMarker.$$$reportNull$$$0(6);
        }
        if (!this.isValid()) {
            return;
        }
        Pair.NonNull<TextRange, LinesCols> pair = PersistentRangeMarker.applyChange(e, this, this.intervalStart(), this.intervalEnd(), this.isGreedyToLeft(), this.isGreedyToRight(), this.isStickingToRight(), this.myLinesCols);
        if (pair == null) {
            this.invalidate(e);
            return;
        }
        this.setIntervalStart(((TextRange)pair.first).getStartOffset());
        this.setIntervalEnd(((TextRange)pair.first).getEndOffset());
        this.myLinesCols = (LinesCols)pair.second;
    }

    @Nullable
    private static Pair.NonNull<TextRange, LinesCols> applyChange(@NotNull DocumentEvent event, @NotNull Segment range, int intervalStart, int intervalEnd, boolean greedyLeft, boolean greedyRight, boolean stickingToRight, @NotNull LinesCols linesCols) {
        if (event == null) {
            PersistentRangeMarker.$$$reportNull$$$0(7);
        }
        if (range == null) {
            PersistentRangeMarker.$$$reportNull$$$0(8);
        }
        if (linesCols == null) {
            PersistentRangeMarker.$$$reportNull$$$0(9);
        }
        boolean shouldTranslateViaDiff = PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, range.getStartOffset(), range.getEndOffset());
        Pair.NonNull<TextRange, LinesCols> translated = null;
        if (shouldTranslateViaDiff) {
            translated = PersistentRangeMarker.translateViaDiff((DocumentEventImpl)event, linesCols);
        }
        if (translated == null) {
            TextRange fallback = PersistentRangeMarker.applyChange(event, intervalStart, intervalEnd, greedyLeft, greedyRight, stickingToRight);
            if (fallback == null) {
                return null;
            }
            LinesCols lc = PersistentRangeMarker.storeLinesAndCols(event.getDocument(), fallback.getStartOffset(), fallback.getEndOffset());
            if (lc == null) {
                return null;
            }
            translated = Pair.createNonNull(fallback, lc);
        }
        return translated;
    }

    @Override
    public String toString() {
        return "PersistentRangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " " + this.myLinesCols + (this.isGreedyToRight() ? "]" : ")");
    }

    @Override
    public int getStartOffset() {
        if (!this.isDocumentLoaded()) {
            ReadAction.run(() -> this.getDocument());
        }
        return super.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        if (!this.isDocumentLoaded()) {
            ReadAction.run(() -> this.getDocument());
        }
        return super.getEndOffset();
    }

    @Override
    void reRegister(@NotNull DocumentImpl document2, int tabSize) {
        if (document2 == null) {
            PersistentRangeMarker.$$$reportNull$$$0(10);
        }
        LinesCols linesCols = this.myLinesCols;
        int startOffset = DocumentUtil.calculateOffset(document2, linesCols.myStartLine, linesCols.myStartColumn, tabSize);
        int endOffset = DocumentUtil.calculateOffset(document2, linesCols.myEndLine, linesCols.myEndColumn, tabSize);
        document2.registerRangeMarker(this, startOffset, endOffset, this.isGreedyToLeft(), this.isGreedyToRight(), 0);
        this.documentLoaded = true;
    }

    private boolean isDocumentLoaded() {
        return this.documentLoaded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDocument";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linesCols";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/PersistentRangeMarker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "storeLinesAndCols";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calcLineCol";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "translateViaDiff";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "changedUpdateImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "applyChange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "reRegister";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class LinesCols {
        private final int myStartLine;
        private final int myStartColumn;
        private final int myEndLine;
        private final int myEndColumn;

        private LinesCols(int startLine, int startColumn, int endLine, int endColumn) {
            this.myStartLine = startLine;
            this.myStartColumn = startColumn;
            this.myEndLine = endLine;
            this.myEndColumn = endColumn;
        }

        public String toString() {
            return this.myStartLine + ":" + this.myStartColumn + "-" + this.myEndLine + ":" + this.myEndColumn;
        }
    }

    private static class LineCol {
        private final int line;
        private final int col;

        LineCol(int line, int col) {
            this.line = line;
            this.col = col;
        }
    }
}

