/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.util.slicedMap;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import kotlin.jvm.functions.Function3;
import ksp.com.google.common.collect.ArrayListMultimap;
import ksp.com.google.common.collect.ImmutableMap;
import ksp.com.google.common.collect.Multimap;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.util.keyFMap.KeyFMap;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.util.slicedMap.AbstractWritableSlice;
import ksp.org.jetbrains.kotlin.util.slicedMap.KeyWithSlice;
import ksp.org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import ksp.org.jetbrains.kotlin.util.slicedMap.OpenAddressLinearProbingHashTable;
import ksp.org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import ksp.org.jetbrains.kotlin.util.slicedMap.RewritePolicy;
import ksp.org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class SlicedMapImpl
implements MutableSlicedMap {
    private final boolean alwaysAllowRewrite;
    @Nullable
    private Map<Object, KeyFMap> map = null;
    private Multimap<WritableSlice<?, ?>, Object> collectiveSliceKeys = null;

    public SlicedMapImpl(boolean alwaysAllowRewrite) {
        this.alwaysAllowRewrite = alwaysAllowRewrite;
    }

    @Override
    public <K, V> void put(WritableSlice<K, V> slice, K key, V value2) {
        Object oldValue;
        KeyFMap holder;
        if (!slice.check(key, value2)) {
            return;
        }
        if (this.map == null) {
            this.map = new OpenAddressLinearProbingHashTable();
        }
        if ((holder = this.map.get(key)) == null) {
            holder = KeyFMap.EMPTY_MAP;
        }
        KeyWithSlice<K, V, WritableSlice<K, V>> sliceKey = slice.getKey();
        RewritePolicy rewritePolicy = slice.getRewritePolicy();
        if (!this.alwaysAllowRewrite && rewritePolicy.rewriteProcessingNeeded(key) && (oldValue = holder.get(sliceKey)) != null && !rewritePolicy.processRewrite(slice, key, oldValue, value2)) {
            return;
        }
        if (slice.isCollective()) {
            if (this.collectiveSliceKeys == null) {
                this.collectiveSliceKeys = ArrayListMultimap.create();
            }
            this.collectiveSliceKeys.put(slice, key);
        }
        this.map.put(key, holder.plus(sliceKey, value2));
        slice.afterPut(this, key, value2);
    }

    @Override
    public void clear() {
        this.map = null;
        this.collectiveSliceKeys = null;
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        KeyFMap holder = this.map != null ? this.map.get(key) : null;
        Object value2 = holder == null ? null : (Object)holder.get(slice.getKey());
        return slice.computeValue(this, key, value2, value2 == null);
    }

    @Override
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        assert (slice.isCollective()) : "Keys are not collected for slice " + slice;
        if (this.collectiveSliceKeys == null) {
            return Collections.emptyList();
        }
        return this.collectiveSliceKeys.get(slice);
    }

    @Override
    public void forEach(@NotNull Function3<WritableSlice, Object, Object, Void> f2) {
        if (f2 == null) {
            SlicedMapImpl.$$$reportNull$$$0(0);
        }
        if (this.map == null) {
            return;
        }
        this.map.forEach((? super K key, ? super V holder) -> {
            if (holder == null) {
                return;
            }
            for (Key<?> sliceKey : holder.getKeys()) {
                Object value2 = holder.get(sliceKey);
                f2.invoke((Object)((AbstractWritableSlice)sliceKey).getSlice(), key, value2);
            }
        });
    }

    @Override
    @NotNull
    public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
        if (slice == null) {
            SlicedMapImpl.$$$reportNull$$$0(1);
        }
        if (this.map == null) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                SlicedMapImpl.$$$reportNull$$$0(2);
            }
            return immutableMap;
        }
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        this.map.forEach((? super K key, ? super V holder) -> {
            Object value2 = holder.get(slice.getKey());
            if (value2 != null) {
                builder2.put(key, value2);
            }
        });
        ImmutableMap immutableMap = builder2.build();
        if (immutableMap == null) {
            SlicedMapImpl.$$$reportNull$$$0(3);
        }
        return immutableMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slice";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSliceContents";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSliceContents";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

