/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.xml.util;

import ksp.com.intellij.openapi.util.text.StringUtilRt;
import ksp.com.intellij.openapi.util.text.Strings;
import ksp.org.jdom.Verifier;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.Nls;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class XmlStringUtil {
    private XmlStringUtil() {
    }

    @NotNull
    public static String wrapInCDATA(@NotNull String str) {
        if (str == null) {
            XmlStringUtil.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        int cur = 0;
        int len = str.length();
        while (cur < len) {
            int next = Strings.indexOf((CharSequence)str, "]]>", cur);
            next = next < 0 ? len : next + 1;
            sb.append("<![CDATA[").append(str.subSequence(cur, next)).append("]]>");
            cur = next;
        }
        String string = sb.toString();
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Contract(value="null->null; !null->!null", pure=true)
    public static String escapeString(@Nullable String str) {
        return XmlStringUtil.escapeString(str, false);
    }

    @Contract(value="null,_->null; !null,_->!null", pure=true)
    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace) {
        return XmlStringUtil.escapeString(str, escapeWhiteSpace, true);
    }

    @Contract(value="null,_,_->null; !null,_,_->!null", pure=true)
    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace, boolean convertNoBreakSpace) {
        if (str == null) {
            return null;
        }
        StringBuilder buffer = null;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            String entity;
            char ch = str.charAt(i2);
            switch (ch) {
                case '\n': {
                    entity = escapeWhiteSpace ? "&#10;" : null;
                    break;
                }
                case '\r': {
                    entity = escapeWhiteSpace ? "&#13;" : null;
                    break;
                }
                case '\t': {
                    entity = escapeWhiteSpace ? "&#9;" : null;
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\u00a0': {
                    entity = convertNoBreakSpace ? "&nbsp;" : null;
                    break;
                }
                default: {
                    entity = null;
                }
            }
            buffer = XmlStringUtil.appendEscapedSymbol(str, buffer, i2, entity, ch);
        }
        return buffer == null ? str : buffer.toString();
    }

    @Nullable
    public static StringBuilder appendEscapedSymbol(@NotNull String str, StringBuilder buffer, int i2, String entity, char ch) {
        if (str == null) {
            XmlStringUtil.$$$reportNull$$$0(2);
        }
        if (buffer == null) {
            if (entity != null) {
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str, 0, i2);
                buffer.append(entity);
            }
        } else if (entity == null) {
            buffer.append(ch);
        } else {
            buffer.append(entity);
        }
        return buffer;
    }

    @Contract(pure=true)
    @NotNull
    public static String wrapInHtml(@NotNull CharSequence result2) {
        if (result2 == null) {
            XmlStringUtil.$$$reportNull$$$0(3);
        }
        String string = "<html>" + result2 + "</html>";
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String wrapInHtmlLines(CharSequence ... lines) {
        if (lines == null) {
            XmlStringUtil.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder("<html>");
        for (int i2 = 0; i2 < lines.length; ++i2) {
            CharSequence sequence2 = lines[i2];
            if (i2 > 0) {
                sb.append("<br>");
            }
            sb.append("<nobr>").append(sequence2).append("</nobr>");
        }
        String string = sb.append("</html>").toString();
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String wrapInHtmlTag(@Nls @NotNull String text, @NonNls @NotNull String tagWord) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(7);
        }
        if (tagWord == null) {
            XmlStringUtil.$$$reportNull$$$0(8);
        }
        String string = String.format("<%s>%s</%s>", tagWord, text, tagWord);
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String wrapInHtmlTagWithAttributes(@Nls @NotNull String text, @NonNls @NotNull String tagWord, @NonNls @NotNull String attributes) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(10);
        }
        if (tagWord == null) {
            XmlStringUtil.$$$reportNull$$$0(11);
        }
        if (attributes == null) {
            XmlStringUtil.$$$reportNull$$$0(12);
        }
        String string = String.format("<%s %s>%s</%s>", tagWord, attributes, text, tagWord);
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String formatLink(@NonNls @NotNull String targetUrl, @Nls @NotNull String text) {
        if (targetUrl == null) {
            XmlStringUtil.$$$reportNull$$$0(14);
        }
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(15);
        }
        return XmlStringUtil.wrapInHtmlTagWithAttributes(text, "a", "href=\"" + targetUrl + "\"");
    }

    public static boolean isWrappedInHtml(@NotNull String tooltip) {
        if (tooltip == null) {
            XmlStringUtil.$$$reportNull$$$0(16);
        }
        return StringUtilRt.startsWithIgnoreCase(tooltip, "<html>") && Strings.endsWithIgnoreCase(tooltip, "</html>");
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String toolTip) {
        if (toolTip == null) {
            XmlStringUtil.$$$reportNull$$$0(17);
        }
        toolTip = Strings.trimStart(toolTip, "<html>");
        toolTip = Strings.trimStart(toolTip, "<body>");
        toolTip = Strings.trimEnd(toolTip, "</html>");
        String string = toolTip = Strings.trimEnd(toolTip, "</body>");
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertToHtmlContent(@NotNull String text) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(19);
        }
        String string = XmlStringUtil.isWrappedInHtml(text) ? XmlStringUtil.stripHtml(text) : XmlStringUtil.escapeString(text);
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String escapeIllegalXmlChars(@NotNull String text) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(21);
        }
        StringBuilder b2 = null;
        int lastPos = 0;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            int c2 = text.codePointAt(i2);
            if (Character.isSupplementaryCodePoint(c2)) {
                ++i2;
            }
            if (c2 != 35 && Verifier.isXMLCharacter(c2)) continue;
            if (b2 == null) {
                b2 = new StringBuilder(text.length() + 5);
            }
            b2.append(text, lastPos, i2).append('#');
            if (c2 != 35) {
                b2.append(Integer.toHexString(c2));
            }
            b2.append('#');
            lastPos = i2 + 1;
        }
        String string = b2 == null ? text : b2.append(text, lastPos, text.length()).toString();
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static String unescapeIllegalXmlChars(@NotNull String text) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(23);
        }
        StringBuilder b2 = null;
        int lastPos = 0;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            int charCode;
            int numberEnd;
            char c2 = text.charAt(i2);
            if (c2 != '#' || (numberEnd = text.indexOf(35, i2 + 1)) <= 0) continue;
            try {
                charCode = numberEnd == i2 + 1 ? 35 : Integer.parseInt(text.substring(i2 + 1, numberEnd), 16);
            }
            catch (NumberFormatException e2) {
                continue;
            }
            if (b2 == null) {
                b2 = new StringBuilder(text.length());
            }
            b2.append(text, lastPos, i2);
            b2.append((char)charCode);
            i2 = numberEnd;
            lastPos = i2 + 1;
        }
        String string = b2 == null ? text : b2.append(text, lastPos, text.length()).toString();
        if (string == null) {
            XmlStringUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/xml/util/XmlStringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagWord";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetUrl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolTip";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/xml/util/XmlStringUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInCDATA";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtml";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtmlLines";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtmlTag";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtmlTagWithAttributes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToHtmlContent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeIllegalXmlChars";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeIllegalXmlChars";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCDATA";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtml";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtmlLines";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtmlTag";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtmlTagWithAttributes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "formatLink";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isWrappedInHtml";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertToHtmlContent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "escapeIllegalXmlChars";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unescapeIllegalXmlChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

