/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import ksp.com.intellij.core.JavaPsiBundle;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiIntersectionType;
import ksp.com.intellij.psi.PsiPrimitiveType;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypes;
import ksp.com.intellij.psi.TypeAnnotationProvider;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import ksp.com.intellij.psi.util.InheritanceUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.org.jetbrains.annotations.NotNull;

public class TypeCompatibilityConstraint
implements ConstraintFormula {
    private PsiType myT;
    private PsiType myS;

    public TypeCompatibilityConstraint(@NotNull PsiType t2, @NotNull PsiType s2) {
        if (t2 == null) {
            TypeCompatibilityConstraint.$$$reportNull$$$0(0);
        }
        if (s2 == null) {
            TypeCompatibilityConstraint.$$$reportNull$$$0(1);
        }
        this.myT = t2.annotate(TypeAnnotationProvider.EMPTY);
        this.myS = s2.annotate(TypeAnnotationProvider.EMPTY);
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        PsiClassType boxedType;
        if (session.isProperType(this.myT) && session.isProperType(this.myS)) {
            boolean assignable = TypeConversionUtil.isAssignable(this.myT, this.myS);
            if (!assignable) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.not.convertible", session.getPresentableText(this.myS), session.getPresentableText(this.myT)));
            }
            return assignable;
        }
        if (this.myS instanceof PsiPrimitiveType && !PsiTypes.voidType().equals(this.myS) && (boxedType = ((PsiPrimitiveType)this.myS).getBoxedType(session.getManager(), session.getScope())) != null) {
            constraints.add(new TypeCompatibilityConstraint(this.myT, boxedType));
            return true;
        }
        if (this.myT instanceof PsiPrimitiveType && !PsiTypes.voidType().equals(this.myT) && (boxedType = ((PsiPrimitiveType)this.myT).getBoxedType(session.getManager(), session.getScope())) != null) {
            constraints.add(new TypeEqualityConstraint(boxedType, this.myS));
            return true;
        }
        if (TypeCompatibilityConstraint.isUncheckedConversion(this.myT, this.myS, session)) {
            session.setErased();
            return true;
        }
        constraints.add(new StrictSubtypingConstraint(this.myT, this.myS));
        return true;
    }

    public static boolean isUncheckedConversion(PsiType t2, PsiType s2, InferenceSession session) {
        if (t2 instanceof PsiClassType && !((PsiClassType)t2).isRaw()) {
            PsiClassType.ClassResolveResult tResult = ((PsiClassType)t2).resolveGenerics();
            PsiClass tClass = tResult.getElement();
            if (s2 instanceof PsiClassType && TypeCompatibilityConstraint.isUncheckedConversion(tClass, (PsiClassType)s2, session)) {
                return true;
            }
            if (s2 instanceof PsiIntersectionType) {
                for (PsiType conjunct : ((PsiIntersectionType)s2).getConjuncts()) {
                    if (!(conjunct instanceof PsiClassType) || !TypeCompatibilityConstraint.isUncheckedConversion(tClass, (PsiClassType)conjunct, session)) continue;
                    return true;
                }
            }
        } else if (t2 instanceof PsiArrayType && s2 != null && t2.getArrayDimensions() == s2.getArrayDimensions()) {
            return TypeCompatibilityConstraint.isUncheckedConversion(t2.getDeepComponentType(), s2.getDeepComponentType(), session);
        }
        return false;
    }

    private static boolean isUncheckedConversion(PsiClass tClass, PsiClassType s2, InferenceSession session) {
        PsiClassType.ClassResolveResult sResult = s2.resolveGenerics();
        PsiClass sClass = sResult.getElement();
        if (tClass != null && sClass != null && !(sClass instanceof InferenceVariable)) {
            PsiSubstitutor sSubstitutor = TypeConversionUtil.getClassSubstitutor(tClass, sClass, sResult.getSubstitutor());
            if (sSubstitutor != null) {
                if (PsiUtil.isRawSubstitutor(tClass, sSubstitutor)) {
                    return true;
                }
            } else if (tClass instanceof InferenceVariable && s2.isRaw()) {
                for (PsiType bound : ((InferenceVariable)tClass).getBounds(InferenceBound.UPPER)) {
                    PsiClass boundClass;
                    if (session.isProperType(bound) || !InheritanceUtil.isInheritorOrSelf(boundClass = PsiUtil.resolveClassInClassTypeOnly(bound), sClass, true)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
        this.myS = substitutor2.substitute(this.myS);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        TypeCompatibilityConstraint that = (TypeCompatibilityConstraint)o2;
        if (!this.myS.equals(that.myS)) {
            return false;
        }
        return this.myT.equals(that.myT);
    }

    public int hashCode() {
        int result2 = this.myT.hashCode();
        result2 = 31 * result2 + this.myS.hashCode();
        return result2;
    }

    public String toString() {
        return this.myS.getPresentableText() + " -> " + this.myT.getPresentableText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "t";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "s";
                break;
            }
        }
        objectArray[1] = "ksp/com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeCompatibilityConstraint";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

