/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import java.util.Collection;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.PlatformToKotlinClassMapper;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtImportDirective;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;

public class PlatformClassesMappedToKotlinChecker {
    public static void checkPlatformClassesMappedToKotlin(@NotNull PlatformToKotlinClassMapper platformToKotlinMap, @NotNull BindingTrace trace, @NotNull KtImportDirective importDirective, @NotNull Collection<? extends DeclarationDescriptor> descriptors) {
        KtExpression importedReference;
        if (platformToKotlinMap == null) {
            PlatformClassesMappedToKotlinChecker.$$$reportNull$$$0(0);
        }
        if (trace == null) {
            PlatformClassesMappedToKotlinChecker.$$$reportNull$$$0(1);
        }
        if (importDirective == null) {
            PlatformClassesMappedToKotlinChecker.$$$reportNull$$$0(2);
        }
        if (descriptors == null) {
            PlatformClassesMappedToKotlinChecker.$$$reportNull$$$0(3);
        }
        if ((importedReference = importDirective.getImportedReference()) != null) {
            for (DeclarationDescriptor declarationDescriptor : descriptors) {
                PlatformClassesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(platformToKotlinMap, trace, importedReference, declarationDescriptor);
            }
        }
    }

    public static void reportPlatformClassMappedToKotlin(@NotNull PlatformToKotlinClassMapper platformToKotlinMap, @NotNull BindingTrace trace, @NotNull KtElement element2, @NotNull DeclarationDescriptor descriptor2) {
        if (platformToKotlinMap == null) {
            PlatformClassesMappedToKotlinChecker.$$$reportNull$$$0(4);
        }
        if (trace == null) {
            PlatformClassesMappedToKotlinChecker.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            PlatformClassesMappedToKotlinChecker.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            PlatformClassesMappedToKotlinChecker.$$$reportNull$$$0(7);
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        Collection<ClassDescriptor> kotlinAnalogsForClass = platformToKotlinMap.mapPlatformClass((ClassDescriptor)descriptor2);
        if (!kotlinAnalogsForClass.isEmpty()) {
            trace.report(Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN.on(element2, kotlinAnalogsForClass));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformToKotlinMap";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDirective";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "ksp/org/jetbrains/kotlin/resolve/PlatformClassesMappedToKotlinChecker";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPlatformClassesMappedToKotlin";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "reportPlatformClassMappedToKotlin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

