/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaResolveResult;
import ksp.com.intellij.psi.LambdaUtil;
import ksp.com.intellij.psi.PsiCall;
import ksp.com.intellij.psi.PsiCallExpression;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiConditionalExpression;
import ksp.com.intellij.psi.PsiDiamondType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiExpressionList;
import ksp.com.intellij.psi.PsiLambdaExpression;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiMethodCallExpression;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiResolveHelper;
import ksp.com.intellij.psi.PsiReturnStatement;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.PsiTypes;
import ksp.com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import ksp.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.CompoundInitialState;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import ksp.com.intellij.psi.infos.MethodCandidateInfo;
import ksp.com.intellij.psi.util.CachedValueProvider;
import ksp.com.intellij.psi.util.CachedValuesManager;
import ksp.com.intellij.psi.util.PsiModificationTracker;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class InferenceSessionContainer {
    private static final Logger LOG = Logger.getInstance(InferenceSessionContainer.class);
    private final Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    InferenceSessionContainer() {
    }

    public void registerNestedSession(InferenceSession session) {
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.getInferenceSessionContainer().myNestedSessions);
    }

    @Contract(value="_, !null -> !null")
    public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType(arg, PsiCall.class));
        return session == null ? defaultSession : session.getInferenceSubstitution();
    }

    void registerNestedSession(InferenceSession session, @NotNull PsiType returnType2, PsiExpression returnExpression) {
        InferenceSession inferenceSession;
        PsiSubstitutor callSession;
        if (returnType2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(0);
        }
        if ((callSession = this.findNestedSubstitutor(((PsiCallExpression)returnExpression).getArgumentList(), null)) == null && (inferenceSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, returnExpression, returnType2, false)) != null && inferenceSession != session) {
            this.registerNestedSession(inferenceSession);
            session.propagateVariables(inferenceSession);
        }
    }

    static PsiSubstitutor infer(final PsiTypeParameter @NotNull [] typeParameters2, final PsiParameter @NotNull [] parameters2, final PsiExpression @NotNull [] arguments2, final @NotNull PsiSubstitutor partialSubstitutor, final @NotNull PsiElement parent2, final @NotNull ParameterTypeInferencePolicy policy, final @Nullable MethodCandidateInfo currentMethod) {
        class NoContainer {
            NoContainer() {
            }

            PsiSubstitutor infer(boolean prohibitCaching) {
                InferenceSession inferenceSession = new InferenceSession(typeParameters2, partialSubstitutor, parent2.getManager(), parent2, policy);
                inferenceSession.initExpressionConstraints(parameters2, arguments2, currentMethod != null ? currentMethod.getElement() : null, currentMethod != null && currentMethod.isVarargs());
                return inferenceSession.performGuardedInference(parameters2, arguments2, parent2, currentMethod, PsiSubstitutor.EMPTY, prohibitCaching);
            }
        }
        PsiCall topLevelCall;
        if (partialSubstitutor == null) {
            InferenceSessionContainer.$$$reportNull$$$0(1);
        }
        if (parent2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(2);
        }
        if (policy == null) {
            InferenceSessionContainer.$$$reportNull$$$0(3);
        }
        if (typeParameters2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(4);
        }
        if (parameters2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(5);
        }
        if (arguments2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(6);
        }
        PsiExpressionList argumentList = InferenceSession.getArgumentList(parent2);
        if (parent2 instanceof PsiCall && !MethodCandidateInfo.isOverloadCheck(argumentList) && (topLevelCall = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(parent2, false, () -> {
            if (parent2 instanceof PsiExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent2)) {
                return null;
            }
            return LambdaUtil.treeWalkUp(parent2);
        })) != null) {
            InferenceSession session;
            if (MethodCandidateInfo.isOverloadCheck() || !PsiDiamondType.ourDiamondGuard.currentStack().isEmpty() || !policy.equals(DefaultParameterTypeInferencePolicy.INSTANCE)) {
                session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy, currentMethod);
            } else {
                Map<PsiElement, InferenceSession> sessions;
                InferenceSession childSession;
                session = (InferenceSession)CachedValuesManager.getCachedValue(topLevelCall, () -> new CachedValueProvider.Result<InferenceSession>(InferenceSessionContainer.startTopLevelInference(topLevelCall, DefaultParameterTypeInferencePolicy.INSTANCE, null), PsiModificationTracker.MODIFICATION_COUNT));
                if (session != null && (childSession = (sessions = session.getInferenceSessionContainer().myNestedSessions).get(parent2)) != null) {
                    for (PsiTypeParameter parameter2 : typeParameters2) {
                        if (childSession.getInferenceSubstitution().getSubstitutionMap().containsKey(parameter2)) continue;
                        session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy, currentMethod);
                        break;
                    }
                }
            }
            if (session != null) {
                PsiSubstitutor childSubstitutor = InferenceSessionContainer.inferNested(parameters2, arguments2, (PsiCall)parent2, currentMethod, session);
                if (childSubstitutor != null) {
                    return childSubstitutor;
                }
                return new NoContainer().infer(true);
            }
            if (topLevelCall instanceof PsiMethodCallExpression) {
                return new InferenceSession(typeParameters2, partialSubstitutor, parent2.getManager(), parent2, policy).prepareSubstitution();
            }
        }
        return new NoContainer().infer(false);
    }

    private static PsiSubstitutor inferNested(PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments2, @NotNull PsiCall parent2, @NotNull MethodCandidateInfo currentMethod, @NotNull InferenceSession parentSession) {
        List<String> errorMessages;
        if (parent2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(7);
        }
        if (currentMethod == null) {
            InferenceSessionContainer.$$$reportNull$$$0(8);
        }
        if (parentSession == null) {
            InferenceSessionContainer.$$$reportNull$$$0(9);
        }
        if (parameters2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(10);
        }
        if (arguments2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(11);
        }
        if ((errorMessages = parentSession.getIncompatibleErrorMessages()) != null && !MethodCandidateInfo.isOverloadCheck()) {
            return null;
        }
        CompoundInitialState compoundInitialState = InferenceSessionContainer.createState(parentSession);
        InitialInferenceState initialInferenceState = compoundInitialState.getInitialState(parent2);
        if (initialInferenceState != null) {
            InferenceSession childSession = new InferenceSession(initialInferenceState, parentSession.getInferencePolicy());
            return childSession.collectAdditionalAndInfer(parameters2, arguments2, currentMethod, compoundInitialState.getInitialSubstitutor());
        }
        PsiElement gParent = PsiUtil.skipParenthesizedExprUp(parent2.getParent());
        while (true) {
            PsiCall call2;
            if (gParent instanceof PsiReturnStatement) {
                gParent = PsiTreeUtil.getParentOfType(gParent, PsiLambdaExpression.class);
            }
            if (gParent instanceof PsiConditionalExpression) {
                gParent = PsiUtil.skipParenthesizedExprUp(gParent.getParent());
            }
            if (!(gParent instanceof PsiLambdaExpression) || (call2 = PsiTreeUtil.getParentOfType(gParent, PsiCall.class)) == null) break;
            initialInferenceState = compoundInitialState.getInitialState(call2);
            if (initialInferenceState != null) {
                PsiParameter[] methodParameters;
                PsiExpressionList argumentList = call2.getArgumentList();
                int idx = argumentList != null ? LambdaUtil.getLambdaIdx(argumentList, gParent) : -1;
                JavaResolveResult result2 = PsiDiamondType.getDiamondsAwareResolveResult(call2);
                PsiElement method = result2.getElement();
                if (!(method instanceof PsiMethod) || idx <= -1 || (methodParameters = ((PsiMethod)method).getParameterList().getParameters()).length == 0) break;
                InferenceSession sessionInsideLambda = new InferenceSession(initialInferenceState, parentSession.getInferencePolicy());
                sessionInsideLambda.collectAdditionalAndInfer(methodParameters, argumentList.getExpressions(), (MethodCandidateInfo)result2, compoundInitialState.getInitialSubstitutor());
                return InferenceSessionContainer.inferNested(parameters2, arguments2, parent2, currentMethod, sessionInsideLambda);
            }
            gParent = PsiUtil.skipParenthesizedExprUp(call2.getParent());
        }
        return null;
    }

    private static CompoundInitialState createState(InferenceSession topLevelSession) {
        PsiSubstitutor topInferenceSubstitutor = InferenceSessionContainer.replaceVariables(topLevelSession.getInferenceVariables());
        final LinkedHashMap<PsiElement, InitialInferenceState> nestedStates = new LinkedHashMap<PsiElement, InitialInferenceState>();
        InferenceSessionContainer copy = new InferenceSessionContainer(){

            @Override
            public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
                PsiSubstitutor substitutor2 = super.findNestedSubstitutor(arg, null);
                if (substitutor2 != null) {
                    return substitutor2;
                }
                InitialInferenceState state = (InitialInferenceState)nestedStates.get(PsiTreeUtil.getParentOfType(arg, PsiCall.class));
                if (state != null) {
                    return state.getInferenceSubstitutor();
                }
                return super.findNestedSubstitutor(arg, defaultSession);
            }
        };
        Map<PsiElement, InferenceSession> nestedSessions = topLevelSession.getInferenceSessionContainer().myNestedSessions;
        if (!nestedSessions.isEmpty()) {
            Project project = nestedSessions.keySet().iterator().next().getProject();
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
            List<InitialInferenceState.VariableInfo> variableInfos = ContainerUtil.map(topLevelSession.getInferenceVariables(), var -> new InitialInferenceState.VariableInfo((InferenceVariable)var, topInferenceSubstitutor, factory2));
            for (Map.Entry<PsiElement, InferenceSession> entry : nestedSessions.entrySet()) {
                nestedStates.put(entry.getKey(), entry.getValue().createInitialState(copy, variableInfos, topInferenceSubstitutor));
            }
        }
        HashMap<PsiTypeParameter, PsiType> map = new HashMap<PsiTypeParameter, PsiType>();
        for (InferenceVariable variable : topLevelSession.getInferenceVariables()) {
            PsiClass psiClass;
            PsiType instantiation = variable.getInstantiation();
            if (instantiation == PsiTypes.nullType() || !((psiClass = PsiUtil.resolveClassInClassTypeOnly(topInferenceSubstitutor.substitute(variable))) instanceof InferenceVariable)) continue;
            map.put((PsiTypeParameter)psiClass, instantiation);
        }
        return new CompoundInitialState(PsiSubstitutor.createSubstitutor(map), nestedStates);
    }

    @Nullable
    private static InferenceSession startTopLevelInference(PsiCall topLevelCall, ParameterTypeInferencePolicy policy, MethodCandidateInfo currentMethod) {
        JavaResolveResult result2 = PsiDiamondType.getDiamondsAwareResolveResult(topLevelCall);
        if (result2 instanceof MethodCandidateInfo) {
            PsiMethod method = ((MethodCandidateInfo)result2).getElement();
            PsiParameter[] topLevelParameters = method.getParameterList().getParameters();
            PsiExpressionList topLevelCallArgumentList = topLevelCall.getArgumentList();
            LOG.assertTrue(topLevelCallArgumentList != null, topLevelCall);
            PsiExpression[] topLevelArguments = topLevelCallArgumentList.getExpressions();
            return PsiResolveHelper.ourGraphGuard.doPreventingRecursion(topLevelCall, true, () -> {
                InferenceSession topLevelSession = new InferenceSession(method.getTypeParameters(), ((MethodCandidateInfo)result2).getSiteSubstitutor(), topLevelCall.getManager(), topLevelCall, policy);
                topLevelSession.setCurrentMethod(currentMethod);
                topLevelSession.initExpressionConstraints(topLevelParameters, topLevelArguments, method, ((MethodCandidateInfo)result2).isVarargs());
                topLevelSession.performGuardedInference(topLevelParameters, topLevelArguments, topLevelCall, (MethodCandidateInfo)result2, PsiSubstitutor.EMPTY, false);
                return topLevelSession;
            });
        }
        return null;
    }

    @NotNull
    private static PsiSubstitutor replaceVariables(Collection<InferenceVariable> inferenceVariables) {
        InferenceVariable[] oldVars;
        ArrayList<InferenceVariable> targetVars = new ArrayList<InferenceVariable>();
        HashMap<InferenceVariable, PsiClassType> map = new HashMap<InferenceVariable, PsiClassType>();
        for (InferenceVariable variable : oldVars = inferenceVariables.toArray(new InferenceVariable[0])) {
            InferenceVariable newVariable = new InferenceVariable(variable.getCallContext(), variable.getParameter(), variable.getName());
            map.put(variable, JavaPsiFacade.getElementFactory(variable.getProject()).createType(newVariable));
            targetVars.add(newVariable);
            if (variable.isThrownBound()) {
                newVariable.setThrownBound();
            }
            newVariable.putUserData(InferenceSession.ORIGINAL_CAPTURE, variable.getUserData(InferenceSession.ORIGINAL_CAPTURE));
        }
        PsiSubstitutor substitutor2 = PsiSubstitutor.createSubstitutor(map);
        for (int i2 = 0; i2 < targetVars.size(); ++i2) {
            InferenceVariable var = (InferenceVariable)targetVars.get(i2);
            for (InferenceBound boundType : InferenceBound.values()) {
                for (PsiType bound : oldVars[i2].getBounds(boundType)) {
                    var.addBound(substitutor2.substitute(bound), boundType, null);
                }
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            InferenceSessionContainer.$$$reportNull$$$0(12);
        }
        return psiSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialSubstitutor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMethod";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSession";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceVariables";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerNestedSession";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "infer";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inferNested";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

