/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.FirSessionComponent;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession;
import ksp.org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import ksp.org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import ksp.org.jetbrains.kotlin.fir.scopes.FirScope;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import ksp.org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirActualizingScope;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/FirDefaultParametersResolver;", "Lksp/org/jetbrains/kotlin/fir/FirSessionComponent;", "<init>", "()V", "declaresDefaultValue", "", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lksp/org/jetbrains/kotlin/fir/resolve/ScopeSession;", "function", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "originScope", "Lksp/org/jetbrains/kotlin/fir/scopes/FirScope;", "index", "", "resolve"})
public final class FirDefaultParametersResolver
implements FirSessionComponent {
    public final boolean declaresDefaultValue(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull FirFunction function2, @Nullable FirScope originScope, int index2) {
        FirTypeScope firTypeScope;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (DeclarationUtilsKt.itOrExpectHasDefaultParameterValue(function2, index2)) {
            return true;
        }
        if (!(function2 instanceof FirSimpleFunction)) {
            return false;
        }
        FirNamedFunctionSymbol symbol = ((FirSimpleFunction)function2).getSymbol();
        FirScope firScope = originScope;
        if (firScope instanceof FirTypeScope) {
            firTypeScope = (FirTypeScope)originScope;
        } else if (firScope instanceof FirActualizingScope || firScope instanceof FirAbstractImportingScope) {
            FirRegularClass firRegularClass = ResolveUtilsKt.getContainingClass(function2);
            if (firRegularClass == null) {
                return false;
            }
            FirRegularClass containingClass = firRegularClass;
            firTypeScope = FirKotlinScopeProviderKt.scopeForClass(containingClass, ConeSubstitutor.Empty.INSTANCE, session, scopeSession, containingClass.getSymbol().toLookupTag(), null);
        } else {
            return false;
        }
        FirTypeScope typeScope = firTypeScope;
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(typeScope, symbol, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirDefaultParametersResolver.declaresDefaultValue$lambda$0(index2, result2, arg_0)));
        return result2.element;
    }

    private static final ProcessorAction declaresDefaultValue$lambda$0(int $index, Ref.BooleanRef $result, FirNamedFunctionSymbol overridden) {
        Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
        if (DeclarationUtilsKt.itOrExpectHasDefaultParameterValue((FirFunction)overridden.getFir(), $index)) {
            $result.element = true;
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }
}

