/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmIrInliner;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.MarkNecessaryInlinedClassesAsRegeneratedLowering;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.expressions.IrClassReference;
import ksp.org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeBuilder;
import ksp.org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@PhaseDescription(name="InlinedClassReferencesBoxingLowering", prerequisite={JvmIrInliner.class, MarkNecessaryInlinedClassesAsRegeneratedLowering.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/InlinedClassReferencesBoxingLowering;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "visitElement", "element", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "visitClassReference", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrClassReference;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nInlinedClassReferencesBoxingLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlinedClassReferencesBoxingLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InlinedClassReferencesBoxingLowering\n+ 2 IrSimpleTypeImpl.kt\norg/jetbrains/kotlin/ir/types/impl/IrSimpleTypeImplKt\n*L\n1#1,63:1\n169#2:64\n*S KotlinDebug\n*F\n+ 1 InlinedClassReferencesBoxingLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InlinedClassReferencesBoxingLowering\n*L\n57#1:64\n*E\n"})
public final class InlinedClassReferencesBoxingLowering
extends IrVisitorVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public InlinedClassReferencesBoxingLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getConfig().getEnableIrInliner()) {
            IrVisitorsKt.acceptChildrenVoid((IrElement)irFile, this);
        }
    }

    @Override
    public void visitElement(@NotNull IrElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        IrVisitorsKt.acceptChildrenVoid(element2, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitClassReference(expression2);
        IrElement irElement = JvmIrInlineUtilsKt.getAttributeOwnerBeforeInline(expression2);
        Object object = irElement instanceof IrClassReference ? (IrClassReference)irElement : null;
        boolean wasTypeParameterClassRefBeforeInline = (object != null && (object = ((IrClassReference)object).getClassType()) != null ? IrTypesKt.getClassifierOrNull((IrType)object) : null) instanceof IrTypeParameterSymbol;
        if (wasTypeParameterClassRefBeforeInline && IrTypePredicatesKt.isPrimitiveType$default(expression2.getClassType(), false, 1, null)) {
            void $this$visitClassReference_u24lambda_u242;
            IrSimpleTypeBuilder irSimpleTypeBuilder;
            IrType boxedPrimitive = IrTypesKt.makeNullable(expression2.getClassType());
            if (!(boxedPrimitive instanceof IrSimpleType)) {
                boolean $i$a$-require-InlinedClassReferencesBoxingLowering$visitClassReference$32 = false;
                String $i$a$-require-InlinedClassReferencesBoxingLowering$visitClassReference$32 = "Type is expected to be " + Reflection.getOrCreateKotlinClass(IrSimpleType.class).getSimpleName() + ": " + RenderIrElementKt.render$default(boxedPrimitive, null, 1, null);
                throw new IllegalArgumentException($i$a$-require-InlinedClassReferencesBoxingLowering$visitClassReference$32.toString());
            }
            expression2.setClassType(boxedPrimitive);
            IrType classReferenceType = expression2.getType();
            if (!(classReferenceType instanceof IrSimpleType && IrTypePredicatesKt.isKClass(classReferenceType))) {
                boolean $i$a$-require-InlinedClassReferencesBoxingLowering$visitClassReference$42 = false;
                String $i$a$-require-InlinedClassReferencesBoxingLowering$visitClassReference$42 = "Type of the type reference is expected to be KClass: " + RenderIrElementKt.render$default(classReferenceType, null, 1, null);
                throw new IllegalArgumentException($i$a$-require-InlinedClassReferencesBoxingLowering$visitClassReference$42.toString());
            }
            IrSimpleType $this$buildSimpleType$iv = (IrSimpleType)classReferenceType;
            boolean $i$f$buildSimpleType = false;
            IrSimpleTypeBuilder irSimpleTypeBuilder2 = irSimpleTypeBuilder = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
            IrClassReference irClassReference = expression2;
            boolean bl2 = false;
            $this$visitClassReference_u24lambda_u242.setArguments(CollectionsKt.listOf((Object)boxedPrimitive));
            irClassReference.setType(IrSimpleTypeImplKt.buildSimpleType(irSimpleTypeBuilder));
        }
    }
}

