/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.model;

import java.util.AbstractCollection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import ksp.com.intellij.concurrency.ThreadContext;
import ksp.com.intellij.model.AllowedSideEffectsElement;
import ksp.com.intellij.openapi.application.AccessToken;
import ksp.com.intellij.openapi.diagnostic.ControlFlowException;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\bf\u0018\u0000 \u00022\u00020\u0001:\u0003\u0002\u0003\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lksp/com/intellij/model/SideEffectGuard;", "", "Companion", "EffectType", "SideEffectNotAllowedException", "intellij.platform.core"})
public interface SideEffectGuard {
    @NotNull
    public static final Companion Companion = ksp.com.intellij.model.SideEffectGuard$Companion.$$INSTANCE;

    @JvmStatic
    public static void checkSideEffectAllowed(@NotNull EffectType effectType) {
        Companion.checkSideEffectAllowed(effectType);
    }

    @JvmStatic
    public static <T> T computeWithoutSideEffects(@NotNull Function0<? extends T> action) {
        return Companion.computeWithoutSideEffects(action);
    }

    @JvmStatic
    public static <T> T computeWithAllowedSideEffectsBlocking(@NotNull EnumSet<EffectType> effects, @NotNull Function0<? extends T> action) {
        return Companion.computeWithAllowedSideEffectsBlocking(effects, action);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007JK\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042'\u0010\f\u001a#\b\u0001\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r\u00a2\u0006\u0002\b\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0011J/\u0010\u0012\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0013H\u0007\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lksp/com/intellij/model/SideEffectGuard$Companion;", "", "()V", "NO_EFFECTS", "Ljava/util/EnumSet;", "Lksp/com/intellij/model/SideEffectGuard$EffectType;", "checkSideEffectAllowed", "", "effectType", "computeWithAllowedSideEffects", "T", "effects", "action", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Ljava/util/EnumSet;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "computeWithAllowedSideEffectsBlocking", "Lkotlin/Function0;", "(Ljava/util/EnumSet;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "computeWithoutSideEffects", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isAllowed", "", "intellij.platform.core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final EnumSet<EffectType> NO_EFFECTS;

        private Companion() {
        }

        @JvmStatic
        public final void checkSideEffectAllowed(@NotNull EffectType effectType) {
            Intrinsics.checkNotNullParameter((Object)((Object)effectType), (String)"effectType");
            if (!this.isAllowed(effectType)) {
                throw new SideEffectNotAllowedException(effectType);
            }
        }

        @JvmStatic
        public final <T> T computeWithoutSideEffects(@NotNull Function0<? extends T> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return this.computeWithAllowedSideEffectsBlocking(NO_EFFECTS, action);
        }

        @Nullable
        public final <T> Object computeWithAllowedSideEffects(@NotNull EnumSet<EffectType> effects, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action, @NotNull Continuation<? super T> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)new AllowedSideEffectsElement(effects)), action, $completion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T computeWithAllowedSideEffectsBlocking(@NotNull EnumSet<EffectType> effects, @NotNull Function0<? extends T> action) {
            Object object;
            Intrinsics.checkNotNullParameter(effects, (String)"effects");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            CoroutineContext context2 = ThreadContext.currentThreadContext();
            AutoCloseable autoCloseable = ThreadContext.installThreadContext(context2.plus((CoroutineContext)new AllowedSideEffectsElement(effects)), true);
            Throwable throwable = null;
            try {
                AccessToken it = (AccessToken)autoCloseable;
                boolean bl2 = false;
                object = action.invoke();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return (T)object;
        }

        private final boolean isAllowed(EffectType effectType) {
            Object object = (AllowedSideEffectsElement)ThreadContext.currentThreadContext().get((CoroutineContext.Key)AllowedSideEffectsElement.Companion);
            return object != null && (object = ((AllowedSideEffectsElement)object).getSideEffects()) != null ? ((AbstractCollection)object).contains((Object)effectType) : true;
        }

        static {
            $$INSTANCE = new Companion();
            EnumSet<EffectType> enumSet = EnumSet.noneOf(EffectType.class);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
            NO_EFFECTS = enumSet;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lksp/com/intellij/model/SideEffectGuard$EffectType;", "", "(Ljava/lang/String;I)V", "PROJECT_MODEL", "SETTINGS", "EXEC", "INVOKE_LATER", "intellij.platform.core"})
    public static final class EffectType
    extends Enum<EffectType> {
        public static final /* enum */ EffectType PROJECT_MODEL = new EffectType();
        public static final /* enum */ EffectType SETTINGS = new EffectType();
        public static final /* enum */ EffectType EXEC = new EffectType();
        public static final /* enum */ EffectType INVOKE_LATER = new EffectType();
        private static final /* synthetic */ EffectType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EffectType[] values() {
            return (EffectType[])$VALUES.clone();
        }

        public static EffectType valueOf(String value2) {
            return Enum.valueOf(EffectType.class, value2);
        }

        @NotNull
        public static EnumEntries<EffectType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = effectTypeArray = new EffectType[]{EffectType.PROJECT_MODEL, EffectType.SETTINGS, EffectType.EXEC, EffectType.INVOKE_LATER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lksp/com/intellij/model/SideEffectGuard$SideEffectNotAllowedException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "Lksp/com/intellij/openapi/diagnostic/ControlFlowException;", "effectType", "Lksp/com/intellij/model/SideEffectGuard$EffectType;", "(Lcom/intellij/model/SideEffectGuard$EffectType;)V", "intellij.platform.core"})
    public static final class SideEffectNotAllowedException
    extends IllegalStateException
    implements ControlFlowException {
        public SideEffectNotAllowedException(@NotNull EffectType effectType) {
            Intrinsics.checkNotNullParameter((Object)((Object)effectType), (String)"effectType");
            super("Side effect not allowed: " + effectType.name());
        }
    }
}

