/*
 * Decompiled with CFR 0.152.
 */
package ksp.io.opentelemetry.api.internal;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ksp.javax.annotation.Nullable;

public final class ReadOnlyArrayMap<K, V>
extends AbstractMap<K, V> {
    private final List<Object> array;
    private final int size;

    public static <K, V> Map<K, V> wrap(List<Object> array) {
        if (array.isEmpty()) {
            return Collections.emptyMap();
        }
        return new ReadOnlyArrayMap<K, V>(array);
    }

    private ReadOnlyArrayMap(List<Object> array) {
        this.array = array;
        this.size = array.size() / 2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object o2) {
        if (o2 == null) {
            return false;
        }
        return this.arrayIndexOfKey(o2) != -1;
    }

    @Override
    public boolean containsValue(Object o2) {
        for (int i2 = 0; i2 < this.array.size(); i2 += 2) {
            if (!this.value(i2 + 1).equals(o2)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public V get(Object o2) {
        if (o2 == null) {
            return null;
        }
        int i2 = this.arrayIndexOfKey(o2);
        return i2 != -1 ? (V)this.value(i2 + 1) : null;
    }

    int arrayIndexOfKey(Object o2) {
        int result2 = -1;
        for (int i2 = 0; i2 < this.array.size(); i2 += 2) {
            if (!o2.equals(this.key(i2))) continue;
            return i2;
        }
        return result2;
    }

    K key(int i2) {
        return (K)this.array.get(i2);
    }

    V value(int i2) {
        return (V)this.array.get(i2);
    }

    @Override
    public Set<K> keySet() {
        return new KeySetView();
    }

    @Override
    public Collection<V> values() {
        return new ValuesView();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySetView();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public V put(K key, V value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("ReadOnlyArrayMap{");
        for (int i2 = 0; i2 < this.array.size(); i2 += 2) {
            result2.append(this.key(i2)).append('=').append(this.value(i2 + 1));
            result2.append(',');
        }
        result2.setLength(result2.length() - 1);
        return result2.append("}").toString();
    }

    final class KeySetView
    extends SetView<K> {
        KeySetView() {
        }

        @Override
        K elementAtArrayIndex(int i2) {
            return ReadOnlyArrayMap.this.key(i2);
        }

        @Override
        public boolean contains(Object o2) {
            return ReadOnlyArrayMap.this.containsKey(o2);
        }
    }

    final class ValuesView
    extends SetView<V> {
        ValuesView() {
        }

        @Override
        V elementAtArrayIndex(int i2) {
            return ReadOnlyArrayMap.this.value(i2 + 1);
        }

        @Override
        public boolean contains(Object o2) {
            return ReadOnlyArrayMap.this.containsValue(o2);
        }
    }

    final class EntrySetView
    extends SetView<Map.Entry<K, V>> {
        EntrySetView() {
        }

        @Override
        Map.Entry<K, V> elementAtArrayIndex(int i2) {
            return new AbstractMap.SimpleImmutableEntry(ReadOnlyArrayMap.this.key(i2), ReadOnlyArrayMap.this.value(i2 + 1));
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry) || ((Map.Entry)o2).getKey() == null) {
                return false;
            }
            Map.Entry that = (Map.Entry)o2;
            int i2 = ReadOnlyArrayMap.this.arrayIndexOfKey(that.getKey());
            if (i2 == -1) {
                return false;
            }
            return ReadOnlyArrayMap.this.value(i2 + 1).equals(that.getValue());
        }
    }

    abstract class SetView<E>
    implements Set<E> {
        SetView() {
        }

        @Override
        public int size() {
            return ReadOnlyArrayMap.this.size;
        }

        abstract E elementAtArrayIndex(int var1);

        @Override
        public Iterator<E> iterator() {
            return new ReadOnlyIterator();
        }

        @Override
        public Object[] toArray() {
            return this.copyTo(new Object[ReadOnlyArrayMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            T[] result2 = a2.length >= ReadOnlyArrayMap.this.size ? a2 : (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size());
            return this.copyTo(result2);
        }

        <T> T[] copyTo(T[] dest) {
            int d2 = 0;
            for (int i2 = 0; i2 < ReadOnlyArrayMap.this.array.size(); i2 += 2) {
                dest[d2++] = this.elementAtArrayIndex(i2);
            }
            return dest;
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            if (c2 == null) {
                return false;
            }
            if (c2.isEmpty()) {
                return true;
            }
            for (Object element2 : c2) {
                if (this.contains(element2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean add(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        final class ReadOnlyIterator
        implements Iterator<E> {
            int current = 0;

            ReadOnlyIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.current < ReadOnlyArrayMap.this.array.size();
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result2 = SetView.this.elementAtArrayIndex(this.current);
                this.current += 2;
                return result2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

