/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.editor.impl;

import java.util.Arrays;
import ksp.com.intellij.openapi.editor.ex.LineIterator;
import ksp.com.intellij.openapi.editor.impl.LineIteratorImpl;
import ksp.com.intellij.openapi.util.text.LineTokenizer;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.BitUtil;
import ksp.com.intellij.util.text.CharArrayUtil;
import ksp.com.intellij.util.text.MergingCharSequence;
import ksp.it.unimi.dsi.fastutil.bytes.ByteArrayList;
import ksp.it.unimi.dsi.fastutil.ints.IntArrayList;
import ksp.it.unimi.dsi.fastutil.ints.IntList;
import ksp.org.jetbrains.annotations.NotNull;

public final class LineSet {
    private static final int MODIFIED_MASK = 4;
    private static final int SEPARATOR_MASK = 3;
    private final int[] myStarts;
    private final byte[] myFlags;
    private final int myLength;

    private LineSet(int[] starts, byte[] flags, int length) {
        this.myStarts = starts;
        this.myFlags = flags;
        this.myLength = length;
    }

    public static LineSet createLineSet(CharSequence text) {
        return LineSet.createLineSet(text, false);
    }

    @NotNull
    private static LineSet createLineSet(@NotNull CharSequence text, boolean markModified) {
        if (text == null) {
            LineSet.$$$reportNull$$$0(0);
        }
        IntArrayList starts = new IntArrayList();
        ByteArrayList flags = new ByteArrayList();
        LineTokenizer lineTokenizer = new LineTokenizer(text);
        while (!lineTokenizer.atEnd()) {
            starts.add(lineTokenizer.getOffset());
            flags.add((byte)(lineTokenizer.getLineSeparatorLength() | (markModified ? 4 : 0)));
            lineTokenizer.advance();
        }
        return new LineSet(starts.toIntArray(), flags.toByteArray(), text.length());
    }

    @NotNull
    LineSet update(@NotNull CharSequence prevText, int start, int end, @NotNull CharSequence replacement, boolean wholeTextReplaced) {
        if (prevText == null) {
            LineSet.$$$reportNull$$$0(1);
        }
        if (replacement == null) {
            LineSet.$$$reportNull$$$0(2);
        }
        if (this.myLength == 0) {
            return LineSet.createLineSet(replacement, !wholeTextReplaced);
        }
        MergingCharSequence newText = StringUtil.replaceSubSequence(prevText, start, end, replacement);
        if (LineSet.hasChar(prevText, start - 1, '\r') && (LineSet.hasChar(prevText, start, '\n') || LineSet.hasChar(newText, start, '\n'))) {
            replacement = new MergingCharSequence("\r", replacement);
            --start;
        }
        if (LineSet.hasChar(prevText, end, '\n') && (LineSet.hasChar(prevText, end - 1, '\r') || LineSet.hasChar(newText, start + replacement.length() - 1, '\r'))) {
            replacement = new MergingCharSequence(replacement, "\n");
            ++end;
        }
        LineSet result2 = this.isSingleLineChange(start, end, replacement) ? this.updateInsideOneLine(this.findLineIndex(start), replacement.length() - (end - start)) : this.genericUpdate(start, end, replacement);
        LineSet lineSet = wholeTextReplaced ? result2.clearModificationFlags() : result2;
        if (lineSet == null) {
            LineSet.$$$reportNull$$$0(3);
        }
        return lineSet;
    }

    private static boolean hasChar(CharSequence s2, int index2, char c2) {
        return index2 >= 0 && index2 < s2.length() && s2.charAt(index2) == c2;
    }

    private boolean isSingleLineChange(int start, int end, @NotNull CharSequence replacement) {
        if (replacement == null) {
            LineSet.$$$reportNull$$$0(4);
        }
        if (start == 0 && end == this.myLength && replacement.length() == 0) {
            return false;
        }
        int startLine = this.findLineIndex(start);
        return startLine == this.findLineIndex(end) && !CharArrayUtil.containLineBreaks(replacement) && !this.isLastEmptyLine(startLine);
    }

    @NotNull
    private LineSet updateInsideOneLine(int line, int lengthDelta) {
        int[] starts = (int[])this.myStarts.clone();
        int i2 = line + 1;
        while (i2 < starts.length) {
            int n2 = i2++;
            starts[n2] = starts[n2] + lengthDelta;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        int n3 = line;
        flags[n3] = (byte)(flags[n3] | 4);
        return new LineSet(starts, flags, this.myLength + lengthDelta);
    }

    private LineSet genericUpdate(int startOffset, int endOffset, CharSequence replacement) {
        int startLine = this.findLineIndex(startOffset);
        int endLine = this.findLineIndex(endOffset);
        LineSet patch = LineSet.createLineSet(replacement, true);
        int lengthShift = patch.myLength - (endOffset - startOffset);
        int startLineStart = this.getLineStart(startLine);
        boolean addStartLine = startOffset - startLineStart > 0 || patch.myStarts.length > 0 || endOffset < this.myLength;
        boolean addEndLine = endOffset < this.myLength && patch.myLength > 0 && patch.getSeparatorLength(patch.myStarts.length - 1) > 0;
        int newLineCount = startLine + (addStartLine ? 1 : 0) + Math.max(patch.myStarts.length - 1, 0) + (addEndLine ? 1 : 0) + Math.max(this.myStarts.length - endLine - 1, 0);
        int[] starts = ArrayUtil.newIntArray(newLineCount);
        byte[] flags = ArrayUtil.newByteArray(newLineCount);
        if (startLine > 0) {
            System.arraycopy(this.myStarts, 0, starts, 0, startLine);
            System.arraycopy(this.myFlags, 0, flags, 0, startLine);
        }
        int toIndex = startLine;
        if (addStartLine) {
            starts[toIndex] = startLineStart;
            flags[toIndex] = patch.myStarts.length > 0 ? patch.myFlags[0] : 4;
            ++toIndex;
        }
        toIndex = patch.shiftData(starts, flags, 1, toIndex, patch.myStarts.length - 1, startOffset);
        if (endOffset < this.myLength) {
            if (addEndLine) {
                starts[toIndex] = endOffset + lengthShift;
                flags[toIndex] = (byte)(this.myFlags[endLine] | 4);
                ++toIndex;
            } else if (toIndex > 0) {
                flags[toIndex - 1] = (byte)(this.myFlags[endLine] | 4);
            }
        }
        this.shiftData(starts, flags, endLine + 1, toIndex, this.myStarts.length - (endLine + 1), lengthShift);
        return new LineSet(starts, flags, this.myLength + lengthShift);
    }

    private int shiftData(int[] dstStarts, byte[] dstFlags, int srcOffset, int dstOffset, int count, int offsetDelta) {
        if (count < 0) {
            return dstOffset;
        }
        System.arraycopy(this.myFlags, srcOffset, dstFlags, dstOffset, count);
        for (int i2 = 0; i2 < count; ++i2) {
            dstStarts[dstOffset + i2] = this.myStarts[srcOffset + i2] + offsetDelta;
        }
        return dstOffset + count;
    }

    public int findLineIndex(int offset) {
        if (offset < 0 || offset > this.myLength) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + ". Should be in range: [0, " + this.myLength + "]");
        }
        if (this.myLength == 0) {
            return 0;
        }
        if (offset == this.myLength) {
            return this.getLineCount() - 1;
        }
        int bsResult = Arrays.binarySearch(this.myStarts, offset);
        return bsResult >= 0 ? bsResult : -bsResult - 2;
    }

    @NotNull
    public LineIterator createIterator() {
        return new LineIteratorImpl(this);
    }

    public int getLineStart(int index2) {
        this.checkLineIndex(index2);
        return this.isLastEmptyLine(index2) ? this.myLength : this.myStarts[index2];
    }

    private boolean isLastEmptyLine(int index2) {
        return index2 == this.myFlags.length && this.hasEol(index2 - 1);
    }

    private boolean hasEol(int lineIndex) {
        return lineIndex >= 0 && this.getSeparatorLengthUnsafe(lineIndex) > 0;
    }

    public int getLineEnd(int index2) {
        this.checkLineIndex(index2);
        return index2 >= this.myStarts.length - 1 ? this.myLength : this.myStarts[index2 + 1];
    }

    private void checkLineIndex(int index2) {
        if (index2 < 0 || index2 >= this.getLineCount()) {
            throw new IndexOutOfBoundsException("Wrong line: " + index2 + ". Available lines count: " + this.getLineCount());
        }
    }

    boolean isModified(int index2) {
        this.checkLineIndex(index2);
        return !this.isLastEmptyLine(index2) && BitUtil.isSet((int)this.myFlags[index2], 4);
    }

    @NotNull
    LineSet setModified(@NotNull IntList indices) {
        int index2;
        if (indices == null) {
            LineSet.$$$reportNull$$$0(5);
        }
        if (indices.isEmpty()) {
            LineSet lineSet = this;
            if (lineSet == null) {
                LineSet.$$$reportNull$$$0(6);
            }
            return lineSet;
        }
        if (indices.size() == 1 && (this.isLastEmptyLine(index2 = indices.getInt(0)) || this.isModified(index2))) {
            LineSet lineSet = this;
            if (lineSet == null) {
                LineSet.$$$reportNull$$$0(7);
            }
            return lineSet;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        for (int i2 = 0; i2 < indices.size(); ++i2) {
            int index3;
            int n2 = index3 = indices.getInt(i2);
            flags[n2] = (byte)(flags[n2] | 4);
        }
        return new LineSet(this.myStarts, flags, this.myLength);
    }

    @NotNull
    LineSet clearModificationFlags(int startLine, int endLine) {
        if (startLine > endLine) {
            throw new IllegalArgumentException("endLine < startLine: " + endLine + " < " + startLine + "; lineCount: " + this.getLineCount());
        }
        this.checkLineIndex(startLine);
        this.checkLineIndex(endLine - 1);
        if (this.isLastEmptyLine(endLine - 1)) {
            --endLine;
        }
        if (startLine >= endLine) {
            LineSet lineSet = this;
            if (lineSet == null) {
                LineSet.$$$reportNull$$$0(8);
            }
            return lineSet;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        int i2 = startLine;
        while (i2 < endLine) {
            int n2 = i2++;
            flags[n2] = (byte)(flags[n2] & 0xFFFFFFFB);
        }
        return new LineSet(this.myStarts, flags, this.myLength);
    }

    @NotNull
    LineSet clearModificationFlags() {
        LineSet lineSet = this.getLineCount() == 0 ? this : this.clearModificationFlags(0, this.getLineCount());
        if (lineSet == null) {
            LineSet.$$$reportNull$$$0(9);
        }
        return lineSet;
    }

    int getSeparatorLength(int index2) {
        this.checkLineIndex(index2);
        return this.getSeparatorLengthUnsafe(index2);
    }

    private int getSeparatorLengthUnsafe(int index2) {
        return index2 < this.myFlags.length ? this.myFlags[index2] & 3 : 0;
    }

    public int getLineCount() {
        return this.myStarts.length + (this.isLastEmptyLine(this.myStarts.length) ? 1 : 0);
    }

    public int getLength() {
        return this.myLength;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevText";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/editor/impl/LineSet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/editor/impl/LineSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setModified";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "clearModificationFlags";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLineSet";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSingleLineChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

