/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.common.actualizer.checker

import ksp.org.jetbrains.kotlin.ir.IrDiagnosticReporter
import ksp.org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo
import ksp.org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMap
import ksp.org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMatchingContext
import ksp.org.jetbrains.kotlin.ir.types.IrTypeSystemContext

internal interface IrExpectActualChecker {
    interface Context {
        val expectActualMap: IrExpectActualMap
        val classActualizationInfo: ClassActualizationInfo
        val typeSystemContext: IrTypeSystemContext
        val diagnosticsReporter: IrDiagnosticReporter
        val matchingContext: IrExpectActualMatchingContext
    }

    fun check(context: Context)
}
