// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.pom.java;

import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface InternalPersistentJavaLanguageLevelReaderService {
  LanguageLevel getPersistedLanguageLevel(@NotNull VirtualFile fileNotDir);

  final class DefaultImpl implements InternalPersistentJavaLanguageLevelReaderService {
    @Override
    public LanguageLevel getPersistedLanguageLevel(@NotNull VirtualFile fileNotDir) {
      return null;
    }
  }
}
