/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.expressions.IrClassReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import ksp.org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import ksp.org.jetbrains.kotlin.name.FqName;

@PhaseDescription(name="RepeatedAnnotation")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J&\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/RepeatedAnnotationLowering;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "visitElement", "element", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "visitFile", "declaration", "visitDeclaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "transformAnnotations", "", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "annotations", "getOrCreateContainerClass", "annotationClass", "wrapAnnotationEntriesInContainer", "containerClass", "entries", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nRepeatedAnnotationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepeatedAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/RepeatedAnnotationLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1516#2,3:136\n1519#2,3:146\n2746#2,3:149\n382#3,7:139\n1#4:152\n*S KotlinDebug\n*F\n+ 1 RepeatedAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/RepeatedAnnotationLowering\n*L\n86#1:136,3\n86#1:146,3\n87#1:149,3\n86#1:139,7\n*E\n"})
public final class RepeatedAnnotationLowering
extends IrVisitorVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public RepeatedAnnotationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrVisitorsKt.acceptVoid((IrElement)irFile, this);
    }

    @Override
    public void visitElement(@NotNull IrElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        IrVisitorsKt.acceptChildrenVoid(element2, this);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        declaration2.setAnnotations(this.transformAnnotations(declaration2.getAnnotations()));
        super.visitFile(declaration2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        declaration2.setAnnotations(this.transformAnnotations(declaration2.getAnnotations()));
        super.visitDeclaration(declaration2);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2.getKind() == ClassKind.ANNOTATION_CLASS && IrUtilsKt.hasAnnotation((IrAnnotationContainer)declaration2, StandardNames.FqNames.repeatable)) {
            IrAnnotationContainer irAnnotationContainer = declaration2;
            FqName fqName = JvmAnnotationNames.REPEATABLE_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"REPEATABLE_ANNOTATION");
            if (!IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName)) {
                declaration2.getDeclarations().add(this.context.getCachedDeclarations().getRepeatedAnnotationSyntheticContainer(declaration2));
            }
        }
        super.visitClass(declaration2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrConstructorCall> transformAnnotations(List<? extends IrConstructorCall> annotations2) {
        boolean bl2;
        void annotationsByClass;
        block11: {
            void destination$iv;
            void $this$groupByTo$iv;
            if (!this.context.getState().getClassBuilderMode().generateBodies) {
                return annotations2;
            }
            if (annotations2.size() < 2) {
                return annotations2;
            }
            Iterable iterable = annotations2;
            Map map = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv : $this$groupByTo$iv) {
                Object object;
                void $this$getOrPut$iv$iv;
                IrConstructorCall it = (IrConstructorCall)element$iv;
                boolean bl3 = false;
                IrClass key$iv = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)it.getSymbol().getOwner());
                void var11_16 = destination$iv;
                IrClass key$iv$iv = key$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                List list$iv = (List)object;
                list$iv.add(element$iv);
            }
            annotationsByClass = destination$iv;
            Iterable $this$none$iv = annotationsByClass.values();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    List it = (List)element$iv;
                    boolean bl5 = false;
                    if (!(it.size() > 1)) continue;
                    bl2 = false;
                    break block11;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            return annotations2;
        }
        List result2 = new ArrayList();
        for (IrConstructorCall annotation : annotations2) {
            List grouped2;
            IrClass annotationClass = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)annotation.getSymbol().getOwner());
            if ((List)annotationsByClass.remove(annotationClass) == null) continue;
            if (grouped2.size() < 2) {
                result2.add(CollectionsKt.single((List)grouped2));
                continue;
            }
            IrClass containerClass = this.getOrCreateContainerClass(annotationClass);
            result2.add(this.wrapAnnotationEntriesInContainer(annotationClass, containerClass, grouped2));
        }
        return result2;
    }

    private final IrClass getOrCreateContainerClass(IrClass annotationClass) {
        Object object;
        Object v1;
        block5: {
            List<IrConstructorCall> metaAnnotations = annotationClass.getAnnotations();
            Iterable iterable = metaAnnotations;
            for (Object t2 : iterable) {
                IrConstructorCall it = (IrConstructorCall)t2;
                boolean bl2 = false;
                FqName fqName = JvmAnnotationNames.REPEATABLE_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"REPEATABLE_ANNOTATION");
                if (!IrUtilsKt.isAnnotation(it, fqName)) continue;
                v1 = t2;
                break block5;
            }
            v1 = null;
        }
        IrConstructorCall jvmRepeatable = v1;
        if (jvmRepeatable != null) {
            IrExpression containerClassReference = (IrExpression)jvmRepeatable.getArguments().get(0);
            if (!(containerClassReference instanceof IrClassReference)) {
                boolean bl3 = false;
                String string = "Repeatable annotation container value must be a class reference: " + annotationClass;
                throw new IllegalArgumentException(string.toString());
            }
            IrClassifierSymbol irClassifierSymbol = ((IrClassReference)containerClassReference).getSymbol();
            object = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (object == null || (object = (IrClass)object.getOwner()) == null) {
                throw new IllegalStateException(("Repeatable annotation container must be a class: " + annotationClass).toString());
            }
        } else {
            object = this.context.getCachedDeclarations().getRepeatedAnnotationSyntheticContainer(annotationClass);
        }
        return object;
    }

    private final IrConstructorCall wrapAnnotationEntriesInContainer(IrClass annotationClass, IrClass containerClass, List<? extends IrConstructorCall> entries) {
        IrConstructorCallImpl irConstructorCallImpl;
        IrSimpleType annotationType2 = IrTypesKt.typeWith(annotationClass, new IrType[0]);
        IrType irType = IrUtilsKt.getDefaultType(containerClass);
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(containerClass);
        Intrinsics.checkNotNull((Object)irConstructor);
        IrConstructorCallImpl $this$wrapAnnotationEntriesInContainer_u24lambda_u244 = irConstructorCallImpl = BuildersKt.fromSymbolOwner$default(IrConstructorCallImpl.Companion, irType, irConstructor.getSymbol(), null, 4, null);
        boolean bl2 = false;
        IrType[] irTypeArray = new IrType[]{annotationType2};
        $this$wrapAnnotationEntriesInContainer_u24lambda_u244.getArguments().set(0, BuildersKt.IrVarargImpl(-1, -1, IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), irTypeArray), annotationType2, entries));
        return irConstructorCallImpl;
    }
}

