/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.InputStream;
import ksp.org.jetbrains.annotations.NotNull;

public class UnsyncByteArrayInputStream
extends InputStream {
    protected final byte[] myBuffer;
    private int myPosition;
    private final int myCount;
    private int myMarkedPosition;

    public UnsyncByteArrayInputStream(@NotNull byte[] buf) {
        if (buf == null) {
            UnsyncByteArrayInputStream.$$$reportNull$$$0(0);
        }
        this(buf, 0, buf.length);
    }

    public UnsyncByteArrayInputStream(@NotNull byte[] buf, int offset, int length) {
        if (buf == null) {
            UnsyncByteArrayInputStream.$$$reportNull$$$0(1);
        }
        this.myBuffer = buf;
        this.myPosition = offset;
        this.myCount = Math.min(offset + length, buf.length);
        this.myMarkedPosition = offset;
    }

    @Override
    public int read() {
        return this.myPosition < this.myCount ? this.myBuffer[this.myPosition++] & 0xFF : -1;
    }

    public int readShortLittleEndian() {
        int position = this.myPosition;
        if (position >= this.myCount - 1) {
            return -1;
        }
        byte ch1 = this.myBuffer[position];
        byte ch2 = this.myBuffer[position + 1];
        this.myPosition += 2;
        return ch1 & 0xFF | ch2 << 8 & 0xFF00;
    }

    @Override
    public int read(@NotNull byte[] b2, int off, int len) {
        if (b2 == null) {
            UnsyncByteArrayInputStream.$$$reportNull$$$0(2);
        }
        if (off < 0 || len < 0 || len > b2.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.myPosition >= this.myCount) {
            return -1;
        }
        if (this.myPosition + len > this.myCount) {
            len = this.myCount - this.myPosition;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.myBuffer, this.myPosition, b2, off, len);
        this.myPosition += len;
        return len;
    }

    @Override
    public long skip(long n2) {
        if ((long)this.myPosition + n2 > (long)this.myCount) {
            n2 = this.myCount - this.myPosition;
        }
        if (n2 < 0L) {
            return 0L;
        }
        this.myPosition = (int)((long)this.myPosition + n2);
        return n2;
    }

    @Override
    public int available() {
        return this.myCount - this.myPosition;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        this.myMarkedPosition = this.myPosition;
    }

    @Override
    public void reset() {
        this.myPosition = this.myMarkedPosition;
    }

    public String toString() {
        return this.getClass() + " (" + this.available() + " bytes available out of " + this.myCount + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/util/io/UnsyncByteArrayInputStream";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

