/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageExtension;
import ksp.com.intellij.lang.LanguageParserDefinitions;
import ksp.com.intellij.lang.ParserDefinition;
import ksp.com.intellij.lang.TokenSeparatorGenerator;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.TokenType;
import ksp.com.intellij.psi.impl.source.tree.Factory;
import ksp.com.intellij.psi.impl.source.tree.LeafElement;
import ksp.com.intellij.psi.util.PsiUtilCore;

public final class LanguageTokenSeparatorGenerators
extends LanguageExtension<TokenSeparatorGenerator> {
    public static final LanguageTokenSeparatorGenerators INSTANCE = new LanguageTokenSeparatorGenerators();

    private LanguageTokenSeparatorGenerators() {
        super("ksp.com.intellij.lang.tokenSeparatorGenerator", new TokenSeparatorGenerator(){

            @Override
            public ASTNode generateWhitespaceBetweenTokens(ASTNode left, ASTNode right) {
                ParserDefinition parserDefinition;
                Language l2 = PsiUtilCore.getNotAnyLanguage(left);
                Language rightLang = PsiUtilCore.getNotAnyLanguage(right);
                if (rightLang.isKindOf(l2)) {
                    l2 = rightLang;
                }
                if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l2)) != null) {
                    LeafElement generatedWhitespace;
                    PsiManager manager = right.getTreeParent().getPsi().getManager();
                    switch (parserDefinition.spaceExistenceTypeBetweenTokens(left, right)) {
                        case MUST: {
                            generatedWhitespace = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, null, manager);
                            break;
                        }
                        case MUST_LINE_BREAK: {
                            generatedWhitespace = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n", 0, 1, null, manager);
                            break;
                        }
                        default: {
                            generatedWhitespace = null;
                        }
                    }
                    return generatedWhitespace;
                }
                return null;
            }
        });
    }
}

