/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeNotFunctionAsOperator;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeDynamicType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirConventionFunctionCallChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkNotFunctionAsOperator", "", "callExpression", "receiver", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "checkNoGetSetMethods", "checkCompareToTypeMismatch", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConventionFunctionCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConventionFunctionCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConventionFunctionCallChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n21#2,2:101\n1#3:103\n*S KotlinDebug\n*F\n+ 1 FirConventionFunctionCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConventionFunctionCallChecker\n*L\n55#1:101,2\n*E\n"})
public final class FirConventionFunctionCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirConventionFunctionCallChecker INSTANCE = new FirConventionFunctionCallChecker();

    private FirConventionFunctionCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        boolean notFunctionAsOperatorIsReportedOnDispatch = this.checkNotFunctionAsOperator(expression2, expression2.getDispatchReceiver(), context2, reporter);
        boolean notFunctionAsOperatorIsReportedOnExtension = this.checkNotFunctionAsOperator(expression2, expression2.getExtensionReceiver(), context2, reporter);
        if (!notFunctionAsOperatorIsReportedOnDispatch && !notFunctionAsOperatorIsReportedOnExtension) {
            this.checkCompareToTypeMismatch(expression2, reporter, context2);
        }
        this.checkNoGetSetMethods(expression2, reporter, context2);
    }

    private final boolean checkNotFunctionAsOperator(FirFunctionCall callExpression, FirExpression receiver, CheckerContext context2, DiagnosticReporter reporter) {
        Object object;
        Object v3;
        FirExpression unwrapped;
        block9: {
            List<ConeDiagnostic> list;
            FirExpression firExpression = callExpression.getDispatchReceiver();
            if ((firExpression != null ? FirTypeUtilsKt.getResolvedType(firExpression) : null) instanceof ConeDynamicType) {
                return false;
            }
            FirExpression firExpression2 = receiver;
            if (firExpression2 == null || (firExpression2 = FirExpressionUtilKt.unwrapSmartcastExpression(firExpression2)) == null) {
                return false;
            }
            unwrapped = firExpression2;
            FirExpression firExpression3 = unwrapped;
            if (firExpression3 instanceof FirQualifiedAccessExpression) {
                list = ((FirQualifiedAccessExpression)unwrapped).getNonFatalDiagnostics();
            } else if (firExpression3 instanceof FirResolvedQualifier) {
                list = ((FirResolvedQualifier)unwrapped).getNonFatalDiagnostics();
            } else {
                return false;
            }
            List<ConeDiagnostic> nonFatalDiagnostics = list;
            Iterable $this$firstIsInstanceOrNull$iv = nonFatalDiagnostics;
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof ConeNotFunctionAsOperator)) continue;
                v3 = element$iv;
                break block9;
            }
            v3 = null;
        }
        if ((object = (ConeNotFunctionAsOperator)v3) == null || (object = ((ConeNotFunctionAsOperator)object).getSymbol()) == null) {
            return false;
        }
        Object diagnosticSymbol = object;
        ClassId classId = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType(unwrapped));
        Intrinsics.checkNotNull((Object)classId);
        if (!Intrinsics.areEqual((Object)classId.getShortClassName(), (Object)OperatorNameConventions.ITERATOR)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)callExpression.getCalleeReference().getSource(), FirErrors.INSTANCE.getNOT_FUNCTION_AS_OPERATOR(), (Object)(diagnosticSymbol instanceof FirPropertySymbol ? "Property" : "Object"), diagnosticSymbol, (DiagnosticContext)context2, null, 32, null);
            return true;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unwrapped.getSource(), FirErrors.INSTANCE.getITERATOR_MISSING(), (DiagnosticContext)context2, null, 8, null);
        return false;
    }

    private final void checkNoGetSetMethods(FirFunctionCall expression2, DiagnosticReporter reporter, CheckerContext context2) {
        Object object = expression2.getCalleeReference();
        FirErrorNamedReference firErrorNamedReference = object instanceof FirErrorNamedReference ? (FirErrorNamedReference)object : null;
        if (firErrorNamedReference == null) {
            return;
        }
        FirErrorNamedReference calleeReference = firErrorNamedReference;
        ConeDiagnostic coneDiagnostic = calleeReference.getDiagnostic();
        ConeUnresolvedNameError coneUnresolvedNameError = coneDiagnostic instanceof ConeUnresolvedNameError ? (ConeUnresolvedNameError)coneDiagnostic : null;
        if (coneUnresolvedNameError == null) {
            return;
        }
        ConeUnresolvedNameError diagnostic = coneUnresolvedNameError;
        KtSourceElement ktSourceElement = expression2.getCalleeReference().getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE)) {
            object = diagnostic.getName();
            if (Intrinsics.areEqual((Object)object, (Object)OperatorNameConventions.GET)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)calleeReference.getSource(), FirErrors.INSTANCE.getNO_GET_METHOD(), (DiagnosticContext)context2, null, 8, null);
            } else if (Intrinsics.areEqual((Object)object, (Object)OperatorNameConventions.SET)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)calleeReference.getSource(), FirErrors.INSTANCE.getNO_SET_METHOD(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkCompareToTypeMismatch(FirFunctionCall expression2, DiagnosticReporter reporter, CheckerContext context2) {
        if (expression2.getOrigin() == FirFunctionCallOrigin.Operator && Intrinsics.areEqual((Object)expression2.getCalleeReference().getName(), (Object)OperatorNameConventions.COMPARE_TO)) {
            ConeKotlinType it = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getResolvedType(expression2), context2.getSession(), null, 2, null);
            boolean bl2 = false;
            boolean bl3 = !(ConeBuiltinTypeUtilsKt.isInt(it) || it instanceof ConeDynamicType || ConeTypeUtilsKt.hasError(it));
            if (bl3) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getCOMPARE_TO_TYPE_MISMATCH(), (Object)FirTypeUtilsKt.getResolvedType(expression2), (DiagnosticContext)context2, null, 16, null);
            }
        }
    }
}

