/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.pom.java;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import ksp.com.intellij.core.JavaPsiBundle;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.Nls;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.PropertyKey;

public enum JavaFeature {
    ASSERTIONS(LanguageLevel.JDK_1_4, "feature.assertions"),
    ENUMS(LanguageLevel.JDK_1_5, "feature.enums"),
    GENERICS(LanguageLevel.JDK_1_5, "feature.generics"),
    ANNOTATIONS(LanguageLevel.JDK_1_5, "feature.annotations"),
    STATIC_IMPORTS(LanguageLevel.JDK_1_5, "feature.static.imports"),
    FOR_EACH(LanguageLevel.JDK_1_5, "feature.for.each"),
    VARARGS(LanguageLevel.JDK_1_5, "feature.varargs"),
    OVERRIDE_INTERFACE(LanguageLevel.JDK_1_6, "feature.override.interface"),
    HEX_FP_LITERALS(LanguageLevel.JDK_1_5, "feature.hex.fp.literals"),
    DIAMOND_TYPES(LanguageLevel.JDK_1_7, "feature.diamond.types"),
    MULTI_CATCH(LanguageLevel.JDK_1_7, "feature.multi.catch", true),
    TRY_WITH_RESOURCES(LanguageLevel.JDK_1_7, "feature.try.with.resources"),
    BIN_LITERALS(LanguageLevel.JDK_1_7, "feature.binary.literals"),
    UNDERSCORES(LanguageLevel.JDK_1_7, "feature.underscores.in.literals"),
    STRING_SWITCH(LanguageLevel.JDK_1_7, "feature.string.switch"),
    STREAM_OPTIONAL(LanguageLevel.JDK_1_8, "feature.stream.and.optional.api", true),
    ADVANCED_COLLECTIONS_API(LanguageLevel.JDK_1_8, "feature.advanced.collection.api", true),
    THREAD_LOCAL_WITH_INITIAL(LanguageLevel.JDK_1_8, "feature.with.initial", true),
    EXTENSION_METHODS(LanguageLevel.JDK_1_8, "feature.extension.methods"),
    METHOD_REFERENCES(LanguageLevel.JDK_1_8, "feature.method.references"),
    LAMBDA_EXPRESSIONS(LanguageLevel.JDK_1_8, "feature.lambda.expressions"),
    TYPE_ANNOTATIONS(LanguageLevel.JDK_1_8, "feature.type.annotations"),
    RECEIVERS(LanguageLevel.JDK_1_8, "feature.type.receivers"),
    INTERSECTION_CASTS(LanguageLevel.JDK_1_8, "feature.intersections.in.casts"),
    STATIC_INTERFACE_CALLS(LanguageLevel.JDK_1_8, "feature.static.interface.calls"),
    EFFECTIVELY_FINAL(LanguageLevel.JDK_1_8, "feature.effectively.final"),
    REFS_AS_RESOURCE(LanguageLevel.JDK_1_9, "feature.try.with.resources.refs"),
    MODULES(LanguageLevel.JDK_1_9, "feature.modules"),
    COLLECTION_FACTORIES(LanguageLevel.JDK_1_9, "feature.collection.factories"),
    PRIVATE_INTERFACE_METHODS(LanguageLevel.JDK_1_9, "feature.private.interface.methods"),
    LVTI(LanguageLevel.JDK_10, "feature.lvti"),
    VAR_LAMBDA_PARAMETER(LanguageLevel.JDK_11, "feature.var.lambda.parameter"),
    NESTMATES(LanguageLevel.JDK_11, "feature.nestmates"),
    ENHANCED_SWITCH(LanguageLevel.JDK_14, "feature.enhanced.switch"),
    SWITCH_EXPRESSION(LanguageLevel.JDK_14, "feature.switch.expressions"),
    SERIAL_ANNOTATION(LanguageLevel.JDK_14, "feature.serial.annotation"),
    TEXT_BLOCK_ESCAPES(LanguageLevel.JDK_15, "feature.text.block.escape.sequences"),
    TEXT_BLOCKS(LanguageLevel.JDK_15, "feature.text.blocks"),
    RECORDS(LanguageLevel.JDK_16, "feature.records"),
    PATTERNS(LanguageLevel.JDK_16, "feature.patterns.instanceof"),
    LOCAL_INTERFACES(LanguageLevel.JDK_16, "feature.local.interfaces"),
    LOCAL_ENUMS(LanguageLevel.JDK_16, "feature.local.enums"),
    INNER_STATICS(LanguageLevel.JDK_16, "feature.inner.statics"),
    SEALED_CLASSES(LanguageLevel.JDK_17, "feature.sealed.classes"),
    ALWAYS_STRICTFP(LanguageLevel.JDK_17, "feature.strictfp"),
    INNER_NOT_CAPTURE_THIS(LanguageLevel.JDK_18, "feature.no.this.capture"),
    JAVADOC_SNIPPETS(LanguageLevel.JDK_18, "feature.javadoc.snippets"),
    PATTERNS_IN_SWITCH(LanguageLevel.JDK_21, "feature.patterns.in.switch", LanguageLevel.JDK_17_PREVIEW, LanguageLevel.JDK_18_PREVIEW, LanguageLevel.JDK_19_PREVIEW, LanguageLevel.JDK_20_PREVIEW),
    PATTERN_GUARDS_AND_RECORD_PATTERNS(LanguageLevel.JDK_21, "feature.pattern.guard.and.record.patterns", LanguageLevel.JDK_19_PREVIEW, LanguageLevel.JDK_20_PREVIEW),
    VIRTUAL_THREADS(LanguageLevel.JDK_21, "feature.virtual.threads", LanguageLevel.JDK_19_PREVIEW, LanguageLevel.JDK_20_PREVIEW),
    FOREIGN_FUNCTIONS(LanguageLevel.JDK_21, "feature.foreign.functions", LanguageLevel.JDK_19_PREVIEW, LanguageLevel.JDK_20_PREVIEW),
    ENUM_QUALIFIED_NAME_IN_SWITCH(LanguageLevel.JDK_21, "feature.enum.qualified.name.in.switch"),
    SEQUENCED_COLLECTIONS(LanguageLevel.JDK_21, "feature.sequenced.collections"),
    STRING_TEMPLATES(LanguageLevel.JDK_21_PREVIEW, "feature.string.templates"),
    UNNAMED_PATTERNS_AND_VARIABLES(LanguageLevel.JDK_22, "feature.unnamed.vars"){

        @Override
        public boolean isSufficient(@NotNull LanguageLevel useSiteLevel) {
            if (useSiteLevel == null) {
                1.$$$reportNull$$$0(0);
            }
            return super.isSufficient(useSiteLevel) || LanguageLevel.JDK_21_PREVIEW == useSiteLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useSiteLevel", "ksp/com/intellij/pom/java/JavaFeature$1", "isSufficient"));
        }
    }
    ,
    IMPLICIT_CLASSES(LanguageLevel.JDK_21_PREVIEW, "feature.implicit.classes"),
    SCOPED_VALUES(LanguageLevel.JDK_21_PREVIEW, "feature.scoped.values"),
    STRUCTURED_CONCURRENCY(LanguageLevel.JDK_21_PREVIEW, "feature.structured.concurrency"),
    CLASSFILE_API(LanguageLevel.JDK_22_PREVIEW, "feature.classfile.api"),
    STREAM_GATHERERS(LanguageLevel.JDK_22_PREVIEW, "feature.stream.gatherers"),
    STATEMENTS_BEFORE_SUPER(LanguageLevel.JDK_22_PREVIEW, "feature.statements.before.super"),
    RECORD_PATTERNS_IN_FOR_EACH(LanguageLevel.JDK_X, "feature.record.patterns.in.for.each", LanguageLevel.JDK_20_PREVIEW);

    @NotNull
    private final LanguageLevel myLevel;
    @PropertyKey(resourceBundle="messages.JavaPsiBundle")
    @NotNull
    private final @PropertyKey(resourceBundle="messages.JavaPsiBundle") @NotNull String myKey;
    private final boolean myCanBeCustomized;
    private final Set<LanguageLevel> myObsoletePreviewLevels;

    private JavaFeature(LanguageLevel level, String key) {
        if (level == null) {
            JavaFeature.$$$reportNull$$$0(0);
        }
        if (key == null) {
            JavaFeature.$$$reportNull$$$0(1);
        }
        this(level, key, false);
    }

    private JavaFeature(@NotNull /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull @NotNull LanguageLevel level, String key, LanguageLevel ... obsoletePreviewLevels) {
        if (level == null) {
            JavaFeature.$$$reportNull$$$0(2);
        }
        if (key == null) {
            JavaFeature.$$$reportNull$$$0(3);
        }
        if (obsoletePreviewLevels == null) {
            JavaFeature.$$$reportNull$$$0(4);
        }
        this.myLevel = level;
        this.myKey = key;
        this.myCanBeCustomized = false;
        this.myObsoletePreviewLevels = EnumSet.noneOf(LanguageLevel.class);
        for (LanguageLevel obsoletePreviewLevel : obsoletePreviewLevels) {
            if (!obsoletePreviewLevel.isUnsupported()) {
                throw new IllegalArgumentException(obsoletePreviewLevel.toString());
            }
            this.myObsoletePreviewLevels.add(obsoletePreviewLevel);
        }
    }

    private JavaFeature(LanguageLevel level, String key, boolean canBeCustomized) {
        if (level == null) {
            JavaFeature.$$$reportNull$$$0(5);
        }
        if (key == null) {
            JavaFeature.$$$reportNull$$$0(6);
        }
        this.myLevel = level;
        this.myKey = key;
        this.myCanBeCustomized = canBeCustomized;
        this.myObsoletePreviewLevels = Collections.emptySet();
    }

    @NotNull
    @Nls
    public String getFeatureName() {
        String string2 = JavaPsiBundle.message(this.myKey, new Object[0]);
        if (string2 == null) {
            JavaFeature.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @NotNull
    public LanguageLevel getMinimumLevel() {
        LanguageLevel languageLevel = this.myLevel;
        if (languageLevel == null) {
            JavaFeature.$$$reportNull$$$0(8);
        }
        return languageLevel;
    }

    @Contract(pure=true)
    public boolean canBeCustomized() {
        return this.myCanBeCustomized;
    }

    @Contract(pure=true)
    public boolean isSufficient(@NotNull LanguageLevel useSiteLevel) {
        if (useSiteLevel == null) {
            JavaFeature.$$$reportNull$$$0(9);
        }
        return (useSiteLevel.isAtLeast(this.myLevel) || useSiteLevel.isUnsupported() && this.myObsoletePreviewLevels.contains((Object)useSiteLevel)) && (!this.myLevel.isPreview() || useSiteLevel.isPreview());
    }

    @Contract(pure=true)
    public boolean isLimited() {
        return false;
    }

    @Contract(pure=true)
    public LanguageLevel getStandardLevel() {
        return this.myLevel.isPreview() ? null : this.myLevel;
    }

    @Nullable
    @Contract(pure=true)
    public static JavaFeature convertFromPreviewFeatureName(@NotNull @NonNls String feature) {
        if (feature == null) {
            JavaFeature.$$$reportNull$$$0(10);
        }
        switch (feature) {
            case "PATTERN_MATCHING_IN_INSTANCEOF": {
                return PATTERNS;
            }
            case "TEXT_BLOCKS": {
                return TEXT_BLOCKS;
            }
            case "RECORDS": {
                return RECORDS;
            }
            case "SEALED_CLASSES": {
                return SEALED_CLASSES;
            }
            case "STRING_TEMPLATES": {
                return STRING_TEMPLATES;
            }
            case "UNNAMED_CLASSES": 
            case "IMPLICIT_CLASSES": {
                return IMPLICIT_CLASSES;
            }
            case "SCOPED_VALUES": {
                return SCOPED_VALUES;
            }
            case "STRUCTURED_CONCURRENCY": {
                return STRUCTURED_CONCURRENCY;
            }
            case "CLASSFILE_API": {
                return CLASSFILE_API;
            }
            case "STREAM_GATHERERS": {
                return STREAM_GATHERERS;
            }
            case "FOREIGN": {
                return FOREIGN_FUNCTIONS;
            }
            case "VIRTUAL_THREADS": {
                return VIRTUAL_THREADS;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obsoletePreviewLevels";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/pom/java/JavaFeature";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useSiteLevel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/pom/java/JavaFeature";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumLevel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSufficient";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertFromPreviewFeatureName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

