/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.resolve.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import ksp.org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtElementImplStub;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/diagnostics/JsModuleChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkSuperClass", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsModuleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsModuleChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n295#2,2:67\n*S KotlinDebug\n*F\n+ 1 JsModuleChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleChecker\n*L\n59#1:67,2\n*E\n"})
public final class JsModuleChecker
implements DeclarationChecker {
    @NotNull
    public static final JsModuleChecker INSTANCE = new JsModuleChecker();

    private JsModuleChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        BindingTrace trace = context2.getTrace();
        this.checkSuperClass(declaration2, descriptor2, trace);
        if (AnnotationsUtils.getModuleName(descriptor2) == null && !AnnotationsUtils.isNonModule(descriptor2)) {
            return;
        }
        if (descriptor2 instanceof PropertyDescriptor && ((PropertyDescriptor)descriptor2).isVar()) {
            trace.report(ErrorsJs.JS_MODULE_PROHIBITED_ON_VAR.on((KtElement)((PsiElement)declaration2)));
        }
        if (!AnnotationsUtils.isNativeObject(descriptor2)) {
            trace.report(ErrorsJs.JS_MODULE_PROHIBITED_ON_NON_NATIVE.on((KtElement)((PsiElement)declaration2)));
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            boolean isFileModuleOrNonModule;
            boolean bl2 = isFileModuleOrNonModule = AnnotationsUtils.getFileModuleName(trace.getBindingContext(), descriptor2) != null || AnnotationsUtils.isFromNonModuleFile(trace.getBindingContext(), descriptor2);
            if (isFileModuleOrNonModule) {
                trace.report(ErrorsJs.NESTED_JS_MODULE_PROHIBITED.on((KtElement)((PsiElement)declaration2)));
            }
        }
    }

    private final void checkSuperClass(KtDeclaration declaration2, DeclarationDescriptor descriptor2, BindingTrace trace) {
        Object v2;
        ClassDescriptor superClass;
        block3: {
            if (!(descriptor2 instanceof ClassDescriptor)) {
                return;
            }
            ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2);
            if (classDescriptor == null) {
                return;
            }
            superClass = classDescriptor;
            Intrinsics.checkNotNull((Object)declaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            Iterable $this$firstOrNull$iv = ((KtClassOrObject)declaration2).getSuperTypeListEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtSuperTypeListEntry entry = (KtSuperTypeListEntry)element$iv;
                boolean bl2 = false;
                Object object = (KotlinType)trace.get(BindingContext.TYPE, entry.getTypeReference());
                if (!Intrinsics.areEqual((Object)(object != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null), (Object)superClass)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        KtSuperTypeListEntry psi = v2;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        KtSuperTypeListEntry ktSuperTypeListEntry = psi;
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, trace, descriptor2, superClass, ktSuperTypeListEntry != null ? (KtElementImplStub)ktSuperTypeListEntry : (KtElementImplStub)((Object)declaration2));
    }
}

