/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J/\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0015R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeIdentifierChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "invalidChars", "", "", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkNameAndReport", "name", "Lksp/org/jetbrains/kotlin/name/Name;", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "checkNameAndReport$checkers_native", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeIdentifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeIdentifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeIdentifierChecker\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,56:1\n1088#2,2:57\n*S KotlinDebug\n*F\n+ 1 FirNativeIdentifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeIdentifierChecker\n*L\n45#1:57,2\n*E\n"})
public final class FirNativeIdentifierChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirNativeIdentifierChecker INSTANCE = new FirNativeIdentifierChecker();
    @NotNull
    private static final Set<Character> invalidChars;

    private FirNativeIdentifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement source = declaration2.getSource();
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirRegularClass) {
            this.checkNameAndReport$checkers_native(((FirRegularClass)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirSimpleFunction) {
            this.checkNameAndReport$checkers_native(((FirSimpleFunction)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirTypeParameter) {
            this.checkNameAndReport$checkers_native(((FirTypeParameter)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkNameAndReport$checkers_native(((FirProperty)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirTypeAlias) {
            this.checkNameAndReport$checkers_native(((FirTypeAlias)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirValueParameter) {
            this.checkNameAndReport$checkers_native(((FirValueParameter)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirEnumEntry) {
            this.checkNameAndReport$checkers_native(((FirEnumEntry)declaration2).getName(), source, context2, reporter);
        } else {
            return;
        }
    }

    public final void checkNameAndReport$checkers_native(@NotNull Name name2, @Nullable KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (source != null && !(source.getKind() instanceof KtFakeSourceElementKind) && !name2.isSpecial()) {
            String message;
            String string2;
            String string3 = name2.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            String text = string3;
            if (((CharSequence)text).length() == 0) {
                string2 = "should not be empty";
            } else {
                boolean bl2;
                block5: {
                    CharSequence $this$any$iv = text;
                    boolean $i$f$any = false;
                    for (int i2 = 0; i2 < $this$any$iv.length(); ++i2) {
                        char element$iv;
                        char it = element$iv = $this$any$iv.charAt(i2);
                        boolean bl3 = false;
                        if (!invalidChars.contains(Character.valueOf(it))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
                string2 = message = bl2 ? "contains illegal characters: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)invalidChars, (Iterable)StringsKt.toSet((CharSequence)text)), (CharSequence)"", (CharSequence)"\"", (CharSequence)"\"", (int)0, null, null, (int)56, null) : null;
            }
            if (message != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirNativeErrors.INSTANCE.getINVALID_CHARACTERS_NATIVE(), (Object)message, (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf(','), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('|'), Character.valueOf('\u00a7'), Character.valueOf('%'), Character.valueOf('@')};
        invalidChars = SetsKt.setOf((Object[])objectArray);
    }
}

