/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirPrimaryConstructorSuperTypeCheckerPlatformComponentKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import ksp.org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkSuperTypeNotInitialized", "primaryConstructorSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "regularClass", "checkSupertypeInitializedWithoutPrimaryConstructor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPrimaryConstructorSuperTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPrimaryConstructorSuperTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,119:1\n64#2:120\n34#3:121\n40#3:122\n57#4,11:123\n21#4,2:134\n*S KotlinDebug\n*F\n+ 1 FirPrimaryConstructorSuperTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker\n*L\n32#1:120\n32#1:121\n43#1:122\n69#1:123,11\n69#1:134,2\n*E\n"})
public final class FirPrimaryConstructorSuperTypeChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirPrimaryConstructorSuperTypeChecker INSTANCE = new FirPrimaryConstructorSuperTypeChecker();

    private FirPrimaryConstructorSuperTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirClass $this$isInterface$iv = declaration2;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        boolean bl2 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        if (bl2) {
            SourceNavigator $this$check_u24lambda_u240 = SourceNavigator.Companion.forElement(declaration2);
            boolean bl3 = false;
            for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
                if (!$this$check_u24lambda_u240.isInConstructorCallee(superTypeRef)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
            }
            return;
        }
        ClassKind $this$isEnumEntry$iv = declaration2.getClassKind();
        boolean $i$f$isEnumEntry = false;
        if ($this$isEnumEntry$iv == ClassKind.ENUM_ENTRY) {
            return;
        }
        FirConstructorSymbol primaryConstructorSymbol = ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.primaryConstructorIfAny(declaration2, context2.getSession());
        if (primaryConstructorSymbol == null || FirDeclarationUtilKt.isErrorPrimaryConstructor(primaryConstructorSymbol)) {
            this.checkSupertypeInitializedWithoutPrimaryConstructor(declaration2, reporter, context2);
        } else {
            this.checkSuperTypeNotInitialized(primaryConstructorSymbol, declaration2, context2, reporter);
        }
    }

    private final void checkSuperTypeNotInitialized(FirConstructorSymbol primaryConstructorSymbol, FirClass regularClass, CheckerContext context2, DiagnosticReporter reporter) {
        FirTypeRef constructedTypeRef;
        FirDelegatedConstructorCall delegatedConstructorCall;
        FirRegularClass containingClass;
        block19: {
            block18: {
                Iterator<Object> iterator2;
                block17: {
                    Iterable $this$lastIsInstanceOrNull$iv = context2.getContainingDeclarations();
                    boolean $i$f$lastIsInstanceOrNull = false;
                    if ($this$lastIsInstanceOrNull$iv instanceof List) {
                        int n2 = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                        if (0 <= n2) {
                            do {
                                int i$iv;
                                Iterator<Object> element$iv;
                                if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n2--)) instanceof FirRegularClass)) continue;
                                iterator2 = element$iv;
                                break block17;
                            } while (0 <= n2);
                        }
                        iterator2 = null;
                    } else {
                        Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                        boolean $i$f$firstIsInstanceOrNull = false;
                        for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                            if (!(element$iv$iv instanceof FirRegularClass)) continue;
                            iterator2 = (Iterator<Object>)element$iv$iv;
                            break block17;
                        }
                        iterator2 = null;
                    }
                }
                containingClass = (FirRegularClass)((Object)iterator2);
                FirDelegatedConstructorCall firDelegatedConstructorCall = primaryConstructorSymbol.getResolvedDelegatedConstructorCall();
                if (firDelegatedConstructorCall == null) {
                    return;
                }
                delegatedConstructorCall = firDelegatedConstructorCall;
                constructedTypeRef = delegatedConstructorCall.getConstructedTypeRef();
                if (constructedTypeRef instanceof FirImplicitAnyTypeRef) break block18;
                KtSourceElement ktSourceElement = constructedTypeRef.getSource();
                if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PluginGenerated.INSTANCE)) break block19;
            }
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType(constructedTypeRef), context2.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol superClassSymbol = firRegularClassSymbol;
        if (superClassSymbol.getClassKind().isSingleton()) {
            return;
        }
        if (DeclarationUtilsKt.isEffectivelyExpect(regularClass, containingClass, context2) || DeclarationUtilsKt.isEffectivelyExternal(regularClass, containingClass, context2)) {
            return;
        }
        KtSourceElement ktSourceElement = delegatedConstructorCall.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement delegatedCallSource = ktSourceElement;
        if (!(delegatedCallSource.getKind() instanceof KtFakeSourceElementKind)) {
            return;
        }
        Set<ClassId> supertypesToSkip = FirPrimaryConstructorSuperTypeCheckerPlatformComponentKt.getPrimaryConstructorSuperTypePlatformSupport(context2.getSession()).getSupertypesThatDontNeedInitializationInSubtypesConstructors();
        if (supertypesToSkip.contains(superClassSymbol.getClassId())) {
            return;
        }
        if (!Intrinsics.areEqual((Object)delegatedCallSource.getElementType(), (Object)KtNodeTypes.SUPER_TYPE_CALL_ENTRY)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)constructedTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_NOT_INITIALIZED(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkSupertypeInitializedWithoutPrimaryConstructor(FirClass regularClass, DiagnosticReporter reporter, CheckerContext context2) {
        SourceNavigator $this$checkSupertypeInitializedWithoutPrimaryConstructor_u24lambda_u241 = SourceNavigator.Companion.forElement(regularClass);
        boolean bl2 = false;
        for (FirTypeRef superTypeRef : regularClass.getSuperTypeRefs()) {
            if (!$this$checkSupertypeInitializedWithoutPrimaryConstructor_u24lambda_u241.isInConstructorCallee(superTypeRef)) continue;
            KtSourceElement ktSourceElement = superTypeRef.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = regularClass.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

