/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.decompiler.psi.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.DeserializerForClassfileDecompilerKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.ResolverForDecompiler;
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.text.BuildDecompiledTextKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.text.IncompatibleAbiVersionKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import ksp.org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import ksp.org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import ksp.org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.renderer.DescriptorRenderer;
import ksp.org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import ksp.org.jetbrains.kotlin.types.FlexibleTypesKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.error.ErrorType;
import ksp.org.jetbrains.kotlin.types.error.ErrorTypeKind;
import ksp.org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"buildDecompiledTextForClassFile", "Lksp/org/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "classFile", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "resolver", "Lksp/org/jetbrains/kotlin/analysis/decompiler/psi/ResolverForDecompiler;", "decompilerRendererForClassFiles", "Lksp/org/jetbrains/kotlin/renderer/DescriptorRenderer;", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nbuildDecompiledTextForClassFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 buildDecompiledTextForClassFile.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextForClassFileKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1374#2:70\n1460#2,5:71\n*S KotlinDebug\n*F\n+ 1 buildDecompiledTextForClassFile.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextForClassFileKt\n*L\n50#1:70\n50#1:71,5\n*E\n"})
public final class BuildDecompiledTextForClassFileKt {
    @NotNull
    private static final DescriptorRenderer decompilerRendererForClassFiles = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)BuildDecompiledTextForClassFileKt::decompilerRendererForClassFiles$lambda$2));

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DecompiledText buildDecompiledTextForClassFile(@NotNull VirtualFile classFile, @NotNull ResolverForDecompiler resolver) {
        DecompiledText decompiledText;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = ClsKotlinBinaryClassCache.getKotlinBinaryClassHeaderData$default(ClsKotlinBinaryClassCache.Companion.getInstance(), classFile, null, 2, null);
        if (kotlinBinaryClassHeaderData == null) {
            throw new IllegalStateException(("Decompiled data factory shouldn't be called on an unsupported file: " + classFile).toString());
        }
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData classHeader = kotlinBinaryClassHeaderData;
        ClassId classId = classHeader.getClassId();
        if (!classHeader.getMetadataVersion().isCompatibleWithCurrentCompilerVersion()) {
            return IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)MetadataVersion.INSTANCE, (BinaryVersion)classHeader.getMetadataVersion());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[classHeader.getKind().ordinal()]) {
            case 1: 
            case 2: {
                decompiledText = BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile$buildText(classHeader, resolver.resolveDeclarationsInFacade(classId.asSingleFqName()));
                break;
            }
            case 3: {
                decompiledText = BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile$buildText(classHeader, CollectionsKt.listOfNotNull((Object)resolver.resolveTopLevelClass(classId)));
                break;
            }
            case 4: {
                void $this$flatMapTo$iv$iv;
                List<KotlinJvmBinaryClass> partClasses = ClsClassFinder.INSTANCE.findMultifileClassParts(classFile, classId, classHeader.getPartNamesIfMultifileFacade());
                Iterable $this$flatMap$iv = partClasses;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    KotlinJvmBinaryClass partClass = (KotlinJvmBinaryClass)element$iv$iv;
                    boolean bl2 = false;
                    Iterable list$iv$iv = resolver.resolveDeclarationsInFacade(partClass.getClassId().asSingleFqName());
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List partMembers = (List)destination$iv$iv;
                decompiledText = BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile$buildText(classHeader, partMembers);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown header kind: " + classHeader + ", class " + classId);
            }
        }
        return decompiledText;
    }

    public static /* synthetic */ DecompiledText buildDecompiledTextForClassFile$default(VirtualFile virtualFile, ResolverForDecompiler resolverForDecompiler, int n2, Object object) {
        if ((n2 & 2) != 0) {
            resolverForDecompiler = DeserializerForClassfileDecompilerKt.DeserializerForClassfileDecompiler(virtualFile);
        }
        return BuildDecompiledTextForClassFileKt.buildDecompiledTextForClassFile(virtualFile, resolverForDecompiler);
    }

    private static final DecompiledText buildDecompiledTextForClassFile$buildText(ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData classHeader, List<? extends DeclarationDescriptor> declarations2) {
        return BuildDecompiledTextKt.buildDecompiledText(classHeader.getPackageNameWithFallback(), declarations2, decompilerRendererForClassFiles);
    }

    private static final KotlinType decompilerRendererForClassFiles$lambda$2$lambda$1(KotlinType type2) {
        KotlinType kotlinType;
        KotlinType kotlinType2;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        KotlinType kotlinType3 = kotlinType2 = FlexibleTypesKt.isFlexible(type2) ? (KotlinType)FlexibleTypesKt.asFlexibleType(type2).getLowerBound() : type2;
        if (kotlinType2 instanceof ErrorType) {
            String[] stringArray = new String[]{'`' + StringsKt.replace$default((String)((ErrorType)kotlinType2).getDebugMessage(), (String)"`", (String)"'", (boolean)false, (int)4, null) + '`'};
            kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_TYPE, stringArray);
        } else {
            kotlinType = kotlinType2;
        }
        return kotlinType;
    }

    private static final Unit decompilerRendererForClassFiles$lambda$2(DescriptorRendererOptions $this$withOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$withOptions, (String)"$this$withOptions");
        BuildDecompiledTextKt.defaultDecompilerRendererOptions($this$withOptions);
        $this$withOptions.setTypeNormalizer((Function1<? super KotlinType, ? extends KotlinType>)((Function1)BuildDecompiledTextForClassFileKt::decompilerRendererForClassFiles$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinClassHeader.Kind.values().length];
            try {
                nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS_PART.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

