/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.search;

import ksp.com.intellij.lang.LanguageMatcher;
import ksp.com.intellij.notebook.editor.BackedVirtualFile;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.search.FileLanguageGlobalScope;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.psi.search.LocalSearchScope;
import ksp.com.intellij.psi.search.SearchScope;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class PsiSearchScopeUtil {
    public static final Key<SearchScope> USE_SCOPE_KEY = Key.create("search.use.scope");

    @Nullable
    public static SearchScope union(@Nullable SearchScope a2, @Nullable SearchScope b2) {
        return a2 == null ? b2 : (b2 == null ? a2 : a2.union(b2));
    }

    public static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiElement element2) {
        if (scope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(1);
        }
        if (scope instanceof LocalSearchScope) {
            LocalSearchScope local = (LocalSearchScope)scope;
            return PsiSearchScopeUtil.isInScope(local, element2);
        }
        GlobalSearchScope globalScope = (GlobalSearchScope)scope;
        return PsiSearchScopeUtil.isInScope(globalScope, element2);
    }

    public static boolean isInScope(@NotNull GlobalSearchScope globalScope, @NotNull PsiElement element2) {
        PsiFile file2;
        if (globalScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(3);
        }
        if ((file2 = element2.getContainingFile()) == null) {
            return true;
        }
        while (file2 != null) {
            if (globalScope.contains(BackedVirtualFile.getOriginFileIfBacked(file2.getOriginalFile().getViewProvider().getVirtualFile()))) {
                return true;
            }
            PsiElement context2 = file2.getContext();
            file2 = context2 == null ? null : context2.getContainingFile();
        }
        return false;
    }

    public static boolean isInScope(@NotNull LocalSearchScope local, @NotNull PsiElement element2) {
        PsiElement[] scopeElements;
        if (local == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(5);
        }
        for (PsiElement scopeElement : scopeElements = local.getScope()) {
            if (!PsiTreeUtil.isAncestor(scopeElement, element2, false)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    @NotNull
    public static SearchScope restrictScopeTo(@NotNull SearchScope originalScope, FileType ... fileTypes) {
        if (originalScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(6);
        }
        if (fileTypes == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(7);
        }
        if (originalScope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)originalScope, fileTypes);
            if (globalSearchScope == null) {
                PsiSearchScopeUtil.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }
        LocalSearchScope localSearchScope = LocalSearchScope.getScopeRestrictedByFileTypes((LocalSearchScope)originalScope, fileTypes);
        if (localSearchScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(9);
        }
        return localSearchScope;
    }

    @ApiStatus.Experimental
    @Contract(pure=true)
    @NotNull
    public static SearchScope restrictScopeToFileLanguage(@NotNull Project project, @NotNull SearchScope originalScope, @NotNull LanguageMatcher matcher) {
        if (project == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(10);
        }
        if (originalScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(11);
        }
        if (matcher == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(12);
        }
        if (originalScope instanceof GlobalSearchScope) {
            return new FileLanguageGlobalScope(project, (GlobalSearchScope)originalScope, matcher);
        }
        LocalSearchScope localSearchScope = LocalSearchScope.getScopeRestrictedByFileLanguage((LocalSearchScope)originalScope, matcher);
        if (localSearchScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(13);
        }
        return localSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/search/PsiSearchScopeUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/search/PsiSearchScopeUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeTo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeToFileLanguage";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeTo";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeToFileLanguage";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

