/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.util.PsiElementFilter;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public interface PsiElementProcessor<T extends PsiElement> {
    public boolean execute(@NotNull T var1);

    public static class FindElement<T extends PsiElement>
    implements PsiElementProcessor<T> {
        private volatile T myFoundElement;

        public boolean isFound() {
            return this.myFoundElement != null;
        }

        @Nullable
        public T getFoundElement() {
            return this.myFoundElement;
        }

        public boolean setFound(T element2) {
            this.myFoundElement = element2;
            return false;
        }

        @Override
        public boolean execute(@NotNull T element2) {
            if (element2 == null) {
                FindElement.$$$reportNull$$$0(0);
            }
            return this.setFound(element2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "ksp/com/intellij/psi/search/PsiElementProcessor$FindElement", "execute"));
        }
    }

    public static class CollectElementsWithLimit<T extends PsiElement>
    extends CollectElements<T> {
        private final AtomicInteger myCount;
        private volatile boolean myOverflow;
        private final int myLimit;

        public CollectElementsWithLimit(int limit) {
            this.myCount = new AtomicInteger(0);
            this.myLimit = limit;
        }

        public CollectElementsWithLimit(int limit, @NotNull Collection<T> collection) {
            if (collection == null) {
                CollectElementsWithLimit.$$$reportNull$$$0(0);
            }
            super(collection);
            this.myCount = new AtomicInteger(0);
            this.myLimit = limit;
        }

        @Override
        public boolean execute(@NotNull T element2) {
            if (element2 == null) {
                CollectElementsWithLimit.$$$reportNull$$$0(1);
            }
            if (this.myCount.get() == this.myLimit) {
                this.myOverflow = true;
                return false;
            }
            this.myCount.incrementAndGet();
            return super.execute(element2);
        }

        public boolean isOverflow() {
            return this.myOverflow;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/psi/search/PsiElementProcessor$CollectElementsWithLimit";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Deprecated
    public static class CollectFilteredElements<T extends PsiElement>
    extends CollectElements<T> {
        private final PsiElementFilter myFilter;

        public CollectFilteredElements(@NotNull PsiElementFilter filter, @NotNull Collection<T> collection) {
            if (filter == null) {
                CollectFilteredElements.$$$reportNull$$$0(0);
            }
            if (collection == null) {
                CollectFilteredElements.$$$reportNull$$$0(1);
            }
            super(collection);
            this.myFilter = filter;
        }

        public CollectFilteredElements(@NotNull PsiElementFilter filter) {
            if (filter == null) {
                CollectFilteredElements.$$$reportNull$$$0(2);
            }
            this.myFilter = filter;
        }

        @Override
        public boolean execute(@NotNull T element2) {
            if (element2 == null) {
                CollectFilteredElements.$$$reportNull$$$0(3);
            }
            return !this.myFilter.isAccepted((PsiElement)element2) || super.execute(element2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/psi/search/PsiElementProcessor$CollectFilteredElements";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CollectElements<T extends PsiElement>
    implements PsiElementProcessor<T> {
        private final Collection<T> myCollection;

        public CollectElements() {
            this(new ArrayList());
        }

        public CollectElements(@NotNull Collection<T> collection) {
            if (collection == null) {
                CollectElements.$$$reportNull$$$0(0);
            }
            this.myCollection = Collections.synchronizedCollection(collection);
        }

        public PsiElement @NotNull [] toArray() {
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(this.myCollection);
            if (psiElementArray == null) {
                CollectElements.$$$reportNull$$$0(1);
            }
            return psiElementArray;
        }

        @NotNull
        public Collection<T> getCollection() {
            Collection<T> collection = this.myCollection;
            if (collection == null) {
                CollectElements.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public T @NotNull [] toArray(T[] array) {
            PsiElement[] psiElementArray = (PsiElement[])this.myCollection.toArray(array);
            if (psiElementArray == null) {
                CollectElements.$$$reportNull$$$0(3);
            }
            return psiElementArray;
        }

        @Override
        public boolean execute(@NotNull T element2) {
            if (element2 == null) {
                CollectElements.$$$reportNull$$$0(4);
            }
            this.myCollection.add(element2);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/search/PsiElementProcessor$CollectElements";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/search/PsiElementProcessor$CollectElements";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCollection";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

